/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ClusterLinkRecord
implements ApiMessage {
    String clusterLinkName;
    Uuid clusterLinkId;
    String remoteClusterId;
    String tenantPrefix;
    String linkMode;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("remote_cluster_id", (Type)Type.COMPACT_STRING, "The ID of the remote cluster for this cluster link."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("tenant_prefix", (Type)Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("remote_cluster_id", (Type)Type.COMPACT_STRING, "The ID of the remote cluster for this cluster link."), new Field("link_mode", (Type)Type.COMPACT_STRING, "The mode of this cluster link. It can be either a destination initiated or source initiated cluster link."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("tenant_prefix", (Type)Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ClusterLinkRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ClusterLinkRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ClusterLinkRecord() {
        this.clusterLinkName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.remoteClusterId = "";
        this.tenantPrefix = null;
        this.linkMode = "DESTINATION";
    }

    public short apiKey() {
        return 10000;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field remoteClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field remoteClusterId had invalid length " + length);
        }
        this.remoteClusterId = _readable.readString(length);
        this.tenantPrefix = null;
        if (_version >= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkMode was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkMode had invalid length " + length);
            }
            this.linkMode = _readable.readString(length);
        } else {
            this.linkMode = "DESTINATION";
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.tenantPrefix = null;
                        continue block3;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field tenantPrefix had invalid length " + length2);
                    }
                    this.tenantPrefix = _readable.readString(length2);
                    continue block3;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.clusterLinkId);
        _stringBytes = _cache.getSerializedValue((Object)this.remoteClusterId);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
        }
        if (_version >= 1) {
            _stringBytes = _cache.getSerializedValue((Object)this.linkMode);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        } else if (!this.linkMode.equals("DESTINATION")) {
            throw new UnsupportedVersionException("Attempted to write a non-default linkMode at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.tenantPrefix != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.tenantPrefix);
            _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.clusterLinkName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = this.remoteClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'remoteClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.remoteClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.tenantPrefix.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantPrefix' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.tenantPrefix, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (_version >= 1) {
            _stringBytes = this.linkMode.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkMode' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.linkMode, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterLinkRecord)) {
            return false;
        }
        ClusterLinkRecord other = (ClusterLinkRecord)obj;
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.remoteClusterId == null ? other.remoteClusterId != null : !this.remoteClusterId.equals(other.remoteClusterId)) {
            return false;
        }
        if (this.tenantPrefix == null ? other.tenantPrefix != null : !this.tenantPrefix.equals(other.tenantPrefix)) {
            return false;
        }
        if (this.linkMode == null ? other.linkMode != null : !this.linkMode.equals(other.linkMode)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.remoteClusterId == null ? 0 : this.remoteClusterId.hashCode());
        hashCode = 31 * hashCode + (this.tenantPrefix == null ? 0 : this.tenantPrefix.hashCode());
        hashCode = 31 * hashCode + (this.linkMode == null ? 0 : this.linkMode.hashCode());
        return hashCode;
    }

    public ClusterLinkRecord duplicate() {
        ClusterLinkRecord _duplicate = new ClusterLinkRecord();
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.remoteClusterId = this.remoteClusterId;
        _duplicate.tenantPrefix = this.tenantPrefix == null ? null : this.tenantPrefix;
        _duplicate.linkMode = this.linkMode;
        return _duplicate;
    }

    public String toString() {
        return "ClusterLinkRecord(clusterLinkName=" + (this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", remoteClusterId=" + (this.remoteClusterId == null ? "null" : "'" + this.remoteClusterId.toString() + "'") + ", tenantPrefix=" + (this.tenantPrefix == null ? "null" : "'" + this.tenantPrefix.toString() + "'") + ", linkMode=" + (this.linkMode == null ? "null" : "'" + this.linkMode.toString() + "'") + ")";
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String tenantPrefix() {
        return this.tenantPrefix;
    }

    public String linkMode() {
        return this.linkMode;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ClusterLinkRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public ClusterLinkRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public ClusterLinkRecord setRemoteClusterId(String v) {
        this.remoteClusterId = v;
        return this;
    }

    public ClusterLinkRecord setTenantPrefix(String v) {
        this.tenantPrefix = v;
        return this;
    }

    public ClusterLinkRecord setLinkMode(String v) {
        this.linkMode = v;
        return this;
    }
}

