/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.image.node.BrokerReplicaExclusionsImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;

public class BrokerReplicaExclusionsImage {
    public static final BrokerReplicaExclusionsImage EMPTY = new BrokerReplicaExclusionsImage(Collections.emptyMap());
    private final Map<Integer, String> exclusionReasonsByBrokerId;

    public BrokerReplicaExclusionsImage(Map<Integer, String> exclusions) {
        this.exclusionReasonsByBrokerId = Collections.unmodifiableMap(exclusions);
    }

    public Map<Integer, String> activeBrokerReplicaExclusions() {
        return this.exclusionReasonsByBrokerId;
    }

    public boolean isEmpty() {
        return this.exclusionReasonsByBrokerId.isEmpty();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new BrokerReplicaExclusionRecord().setBrokerExclusions(this.exclusionReasonsByBrokerId.entrySet().stream().map(entry -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)entry.getKey()).setReason((String)entry.getValue())).collect(Collectors.toList())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerReplicaExclusionsImage that = (BrokerReplicaExclusionsImage)o;
        return Objects.equals(this.exclusionReasonsByBrokerId, that.exclusionReasonsByBrokerId);
    }

    public int hashCode() {
        return Objects.hash(this.exclusionReasonsByBrokerId);
    }

    public String toString() {
        return new BrokerReplicaExclusionsImageNode(this).stringify();
    }
}

