/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.EndConsumerHelper;
import io.confluent.shaded.org.reactivestreams.Subscription;

public abstract class DefaultSubscriber<T>
implements FlowableSubscriber<T> {
    Subscription upstream;

    @Override
    public final void onSubscribe(Subscription s) {
        if (EndConsumerHelper.validate(this.upstream, s, this.getClass())) {
            this.upstream = s;
            this.onStart();
        }
    }

    protected final void request(long n) {
        Subscription s = this.upstream;
        if (s != null) {
            s.request(n);
        }
    }

    protected final void cancel() {
        Subscription s = this.upstream;
        this.upstream = SubscriptionHelper.CANCELLED;
        s.cancel();
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }
}

