/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.kafka.multitenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellMetrics;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;

public class CellControllerMetrics
implements CellMetrics {
    private static final MetricName READY_CELL_COUNT = CellControllerMetrics.metricName("ReadyCellCount");
    private static final MetricName QUARANTINED_CELL_COUNT = CellControllerMetrics.metricName("QuarantinedCellCount");
    private static final MetricName EXCLUDED_CELL_COUNT = CellControllerMetrics.metricName("ExcludedCellCount");
    private static final MetricName CELL_LOAD_FRESH = CellControllerMetrics.metricName("CellLoadFresh");
    private static final MetricName NOT_READY_FOR_TENANT_ASSIGNMENT_COUNT = CellControllerMetrics.metricName("NotTenantAssignableCellCount");
    private static final MetricName STRAY_BROKER_COUNT = CellControllerMetrics.metricName("StrayBrokerCount");
    private static final String CELL_ID_TAG = "cellId";
    private final MetricsRegistry registry;
    private final CellMetricStats stats;
    private final Map<Integer, List<MetricName>> cellIdToMetrics;
    private final Map<Integer, List<MetricName>> cellIdToLoadMetrics;
    private final List<MetricName> clusterWideCellMetrics;
    private final Time time;
    private final Logger log;

    public CellControllerMetrics(MetricsRegistry registry, Time time, LogContext logContext) {
        this.registry = registry;
        this.stats = new CellMetricStats();
        this.cellIdToMetrics = new HashMap<Integer, List<MetricName>>();
        this.cellIdToLoadMetrics = new HashMap<Integer, List<MetricName>>();
        this.clusterWideCellMetrics = new ArrayList<MetricName>();
        this.time = time;
        this.log = logContext.logger(CellControllerMetrics.class);
    }

    @Override
    public void updateCell(Cell cell) {
        this.stats.updateCell(cell);
        this.ensureMetricsAreRegistered();
    }

    @Override
    public void deleteCell(int cellId) {
        this.stats.deleteCell(cellId);
        this.ensureMetricsAreRegistered();
    }

    @Override
    public void updateTenantIdToCell(String tenantId, int cellId) {
        this.stats.updateTenantIdToCell(tenantId, cellId);
    }

    @Override
    public void deleteTenant(String tenantId) {
        this.stats.deleteTenant(tenantId);
    }

    @Override
    public void updateReplicaCounts(String topicName, Map<Integer, List<Integer>> partitionIdToReplicasAdded, Map<Integer, List<Integer>> partitionIdToReplicasDeleted) {
        this.stats.updateReplicaCounts(topicName, partitionIdToReplicasAdded, partitionIdToReplicasDeleted);
    }

    @Override
    public void updateUnhealthyCellStats(int numCellsNotReadyForTenantAssignment, int numStrayBrokerCount) {
        this.stats.updateUnhealthyCellStats(numCellsNotReadyForTenantAssignment, numStrayBrokerCount);
    }

    @Override
    public void updateCellLoads(Set<CellLoad> cellLoads, long lastCellLoadUpdateTimeMs) {
        this.stats.updateCellLoads(cellLoads, lastCellLoadUpdateTimeMs);
        Set newCellIds = cellLoads.stream().map(CellLoad::cellId).collect(Collectors.toSet());
        HashSet<Integer> staleCellIds = new HashSet<Integer>(this.cellIdToLoadMetrics.keySet());
        staleCellIds.removeAll(newCellIds);
        newCellIds.removeAll(this.cellIdToLoadMetrics.keySet());
        for (Integer cellId : newCellIds) {
            this.createGauge(this.cellIdToLoadMetrics, CellControllerMetrics.metricName("Load", cellId), x$0 -> this.stats.cellLoad(x$0), cellId);
        }
        for (Integer cellId : staleCellIds) {
            this.removeMetrics(this.cellIdToLoadMetrics, cellId);
        }
    }

    @Override
    public Collection<Cell> cells() {
        return this.stats.cells();
    }

    @Override
    public void close() {
        Arrays.asList(this.cellIdToMetrics, this.cellIdToLoadMetrics).forEach(metricNames -> {
            metricNames.values().forEach(metrics -> metrics.forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0)));
            metricNames.clear();
        });
        this.clusterWideCellMetrics.forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        this.clusterWideCellMetrics.clear();
    }

    @Override
    public void clear() {
        this.stats.reinitialize();
    }

    private static Map<Integer, Integer> accumulateCounters(Map<Integer, Integer> destination, Map<Integer, Integer> source) {
        source.forEach((k, v) -> destination.put((Integer)k, destination.getOrDefault(k, 0) + v));
        return destination;
    }

    public int numCellTenants(int cellId) {
        return this.stats.numCellTenants(cellId);
    }

    public int numCellBrokers(int cellId) {
        return this.stats.numCellBrokers(cellId);
    }

    public int numCellReplicas(int cellId) {
        return this.stats.numCellReplicas(cellId);
    }

    public int numIncomingTenants(int cellId) {
        return this.stats.numIncomingTenants(cellId);
    }

    public int numOutgoingTenants(int cellId) {
        return this.stats.numOutgoingTenants(cellId);
    }

    public int numReadyCells() {
        return this.stats.numReadyCells();
    }

    public int numQuarantinedCells() {
        return this.stats.numQuarantinedCells();
    }

    public int numExcludedCells() {
        return this.stats.numExcludedCells();
    }

    public int numCellsNotReadyForTenantAssignment() {
        return this.stats.numCellsNotReadyForTenantAssignment();
    }

    public int numStrayBrokerCount() {
        return this.stats.numStrayBrokerCount();
    }

    private void ensureMetricsAreRegistered() {
        Set cellIds = this.stats.cells().stream().map(Cell::cellId).collect(Collectors.toSet());
        Set newCellIds = cellIds.stream().filter(c -> !this.cellIdToMetrics.containsKey(c)).collect(Collectors.toSet());
        Set staleCellIds = this.cellIdToMetrics.keySet().stream().filter(c -> !cellIds.contains(c)).collect(Collectors.toSet());
        for (Integer cellId : newCellIds) {
            this.createGauge(this.cellIdToMetrics, CellControllerMetrics.metricName("TenantCount", cellId), x$0 -> this.stats.numCellTenants(x$0), cellId);
            this.createGauge(this.cellIdToMetrics, CellControllerMetrics.metricName("ReplicaCount", cellId), x$0 -> this.stats.numCellReplicas(x$0), cellId);
            this.createGauge(this.cellIdToMetrics, CellControllerMetrics.metricName("IncomingTenantCount", cellId), x$0 -> this.stats.numIncomingTenants(x$0), cellId);
            this.createGauge(this.cellIdToMetrics, CellControllerMetrics.metricName("OutgoingTenantCount", cellId), x$0 -> this.stats.numOutgoingTenants(x$0), cellId);
            this.createGauge(this.cellIdToMetrics, CellControllerMetrics.metricName("BrokerCount", cellId), x$0 -> this.stats.numCellBrokers(x$0), cellId);
        }
        for (Integer cellId : staleCellIds) {
            this.removeMetrics(this.cellIdToMetrics, cellId);
        }
        if (!cellIds.isEmpty() && this.clusterWideCellMetrics.isEmpty()) {
            this.createGauge(this.clusterWideCellMetrics, READY_CELL_COUNT, () -> this.stats.numReadyCells());
            this.createGauge(this.clusterWideCellMetrics, QUARANTINED_CELL_COUNT, () -> this.stats.numQuarantinedCells());
            this.createGauge(this.clusterWideCellMetrics, EXCLUDED_CELL_COUNT, () -> this.stats.numExcludedCells());
            this.createGauge(this.clusterWideCellMetrics, CELL_LOAD_FRESH, () -> this.time.milliseconds() - this.stats.lastCellLoadUpdateTimeMs() <= CellAssignor.CELL_LOAD_FRESH_DURATION_MS ? 1 : 0);
            this.createGauge(this.clusterWideCellMetrics, NOT_READY_FOR_TENANT_ASSIGNMENT_COUNT, () -> this.stats.numCellsNotReadyForTenantAssignment());
            this.createGauge(this.clusterWideCellMetrics, STRAY_BROKER_COUNT, () -> this.stats.numStrayBrokerCount());
        }
    }

    private void removeMetrics(Map<Integer, List<MetricName>> cellIdToMetrics, int cellId) {
        cellIdToMetrics.getOrDefault(cellId, Collections.emptyList()).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        cellIdToMetrics.remove(cellId);
    }

    private <R> void createGauge(Map<Integer, List<MetricName>> cellIdToMetrics, MetricName metric, final Function<Integer, R> cellMetric, final int cellId) {
        cellIdToMetrics.computeIfAbsent(cellId, k -> new ArrayList()).add(metric);
        this.registry.newGauge(metric, new Gauge<R>(){

            public R value() {
                return cellMetric.apply(cellId);
            }
        });
    }

    private <R> void createGauge(List<MetricName> metrics, MetricName metric, final Supplier<R> cellMetric) {
        metrics.add(metric);
        this.registry.newGauge(metric, new Gauge<R>(){

            public R value() {
                return cellMetric.get();
            }
        });
    }

    private static MetricName metricName(String name, int cellId) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put(CELL_ID_TAG, String.valueOf(cellId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)name, tags);
    }

    private static MetricName metricName(String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)name);
    }

    private static class UnitCounter {
        private static final UnitCounter EMPTY_UNIT_COUNTER = new UnitCounter(Collections.emptyMap());
        private final Map<Integer, Integer> containerReplicaCounter;

        private UnitCounter() {
            this(new ConcurrentHashMap<Integer, Integer>());
        }

        private UnitCounter(Map<Integer, Integer> containerReplicaCounter) {
            this.containerReplicaCounter = containerReplicaCounter;
        }

        private Set<Map.Entry<Integer, Integer>> entries() {
            return this.containerReplicaCounter.entrySet();
        }

        private Set<Integer> keys() {
            return this.containerReplicaCounter.keySet();
        }

        private UnitCounter addAll(UnitCounter other) {
            for (Map.Entry<Integer, Integer> e : other.entries()) {
                this.increment(e.getKey(), e.getValue());
            }
            return this;
        }

        private static UnitCounter fromReplicas(Collection<Integer> replicas) {
            return new UnitCounter(replicas.stream().collect(Collectors.groupingByConcurrent(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum))));
        }

        private UnitCounter groupingByConcurrent(Function<Integer, Integer> classifier, Function<Integer, Integer> mapper, BinaryOperator<Integer> aggregator) {
            return new UnitCounter((Map<Integer, Integer>)this.containerReplicaCounter.entrySet().stream().collect(Collectors.groupingByConcurrent(e -> (Integer)classifier.apply((Integer)e.getKey()), Collectors.reducing(0, e -> (Integer)mapper.apply((Integer)e.getValue()), aggregator))));
        }

        private void increment(int containerId, int numReplicas) {
            int val = this.containerReplicaCounter.compute(containerId, (k, v) -> Math.max(0, v == null ? numReplicas : v + numReplicas));
            if (val == 0) {
                this.containerReplicaCounter.remove(containerId);
            }
        }

        private void decrement(int containerId, int numReplicas) {
            this.increment(containerId, -numReplicas);
        }

        private boolean contains(int containerId) {
            return this.containerReplicaCounter.containsKey(containerId);
        }

        private int get(int cellId) {
            return this.containerReplicaCounter.getOrDefault(cellId, 0);
        }
    }

    private static class CellMetricStats {
        private volatile Map<String, UnitCounter> tenantIdToReplicaCounts;
        private volatile Map<String, Integer> tenantIdToCell;
        private volatile Map<Integer, Double> cellIdToLoad;
        private volatile Map<Integer, Cell> cellIdToCell;
        private volatile Map<Integer, Integer> brokerIdToCell;
        private volatile UnitCounter cellReplicaCounter;
        private volatile UnitCounter cellTenantCounter;
        private volatile UnitCounter cellIncomingTenantCounter;
        private volatile UnitCounter cellOutgoingTenantCounter;
        private volatile int numCellsNotReadyForTenantAssignment;
        private volatile int numStrayBrokerCount;
        private volatile int numReadyCells;
        private volatile int numExcludedCells;
        private volatile int numQuarantinedCells;
        private volatile long lastCellLoadUpdateTimeMs;

        private CellMetricStats() {
            this.reinitialize();
        }

        private void reinitialize() {
            this.cellIdToCell = new ConcurrentHashMap<Integer, Cell>();
            this.tenantIdToReplicaCounts = new ConcurrentHashMap<String, UnitCounter>();
            this.tenantIdToCell = new ConcurrentHashMap<String, Integer>();
            this.cellIdToLoad = new ConcurrentHashMap<Integer, Double>();
            this.brokerIdToCell = new ConcurrentHashMap<Integer, Integer>();
            this.cellReplicaCounter = new UnitCounter();
            this.cellTenantCounter = new UnitCounter();
            this.cellIncomingTenantCounter = new UnitCounter();
            this.cellOutgoingTenantCounter = new UnitCounter();
            this.numCellsNotReadyForTenantAssignment = 0;
            this.numStrayBrokerCount = 0;
            this.numReadyCells = 0;
            this.numExcludedCells = 0;
            this.numQuarantinedCells = 0;
            this.lastCellLoadUpdateTimeMs = 0L;
        }

        private void updateTenantIdToCell(String tenantId, int cellId) {
            int prevCellId = this.tenantCellId(tenantId);
            if (this.isTenantMigratingToCell(tenantId, prevCellId)) {
                this.cellIncomingTenantCounter.decrement(prevCellId, 1);
            }
            for (Integer fromCellId : this.cellsTenantMigratingFrom(tenantId)) {
                this.cellOutgoingTenantCounter.decrement(fromCellId, 1);
            }
            this.tenantIdToCell.put(tenantId, cellId);
            if (this.isTenantMigratingToCell(tenantId, cellId)) {
                this.cellIncomingTenantCounter.increment(cellId, 1);
            }
            for (Integer fromCellId : this.cellsTenantMigratingFrom(tenantId)) {
                this.cellOutgoingTenantCounter.increment(fromCellId, 1);
            }
            if (prevCellId != -1) {
                this.cellTenantCounter.decrement(prevCellId, 1);
            }
            this.cellTenantCounter.increment(cellId, 1);
        }

        private void updateReplicaCounts(String topicName, Map<Integer, List<Integer>> partitionIdToReplicasAdded, Map<Integer, List<Integer>> partitionIdToReplicasDeleted) {
            String tenantId = TenantUtils.extractTenantPrefix((String)topicName, (boolean)false);
            if (tenantId == null) {
                return;
            }
            int cellId = this.tenantCellId(tenantId);
            if (this.isTenantMigratingToCell(tenantId, cellId)) {
                this.cellIncomingTenantCounter.decrement(cellId, 1);
            }
            for (Integer fromCellId : this.cellsTenantMigratingFrom(tenantId)) {
                this.cellOutgoingTenantCounter.decrement(fromCellId, 1);
            }
            UnitCounter tenantReplicaCounts = this.tenantIdToReplicaCounts.computeIfAbsent(tenantId, k -> new UnitCounter());
            Map replicaDeltas = CellControllerMetrics.accumulateCounters(CellMetricStats.groupItemsByNameAndSum(partitionIdToReplicasAdded.values(), e -> 1), CellMetricStats.groupItemsByNameAndSum(partitionIdToReplicasDeleted.values(), e -> -1));
            for (Map.Entry replicaDelta : replicaDeltas.entrySet()) {
                int replica = (Integer)replicaDelta.getKey();
                int replicaCellId = this.brokerCellId(replica);
                int delta = (Integer)replicaDelta.getValue();
                tenantReplicaCounts.increment(replica, delta);
                if (replicaCellId == -1) continue;
                this.cellReplicaCounter.increment(replicaCellId, delta);
            }
            if (this.isTenantMigratingToCell(tenantId, cellId)) {
                this.cellIncomingTenantCounter.increment(cellId, 1);
            }
            for (Integer fromCellId : this.cellsTenantMigratingFrom(tenantId)) {
                this.cellOutgoingTenantCounter.increment(fromCellId, 1);
            }
        }

        private void deleteTenant(String tenantId) {
            int cellId = this.tenantCellId(tenantId);
            this.tenantIdToCell.remove(tenantId);
            this.tenantIdToReplicaCounts.remove(tenantId);
            if (this.cellTenantCounter.contains(cellId)) {
                this.cellTenantCounter.decrement(cellId, 1);
            }
        }

        private Collection<Cell> cells() {
            return this.cellIdToCell.values();
        }

        private void updateCell(Cell cell) {
            boolean isUnassignment = !cell.brokers().containsAll(this.cellBrokers(cell.cellId()));
            this.cellIdToCell.put(cell.cellId(), cell);
            this.processUpdateCells(isUnassignment);
        }

        private void processUpdateCells(boolean isUnassignment) {
            this.brokerIdToCell = CellMetricStats.calculateBrokerToCellId(this.cellIdToCell.values());
            this.recalculateCellStateMetrics();
            if (isUnassignment) {
                this.recalculateCellMetrics();
            }
        }

        private void deleteCell(int cellId) {
            this.cellIdToCell.remove(cellId);
            this.brokerIdToCell = CellMetricStats.calculateBrokerToCellId(this.cellIdToCell.values());
            this.recalculateCellStateMetrics();
        }

        private void updateCellLoads(Set<CellLoad> cellLoads, long lastCellLoadUpdateTimeMs) {
            this.cellIdToLoad = cellLoads.stream().collect(Collectors.toConcurrentMap(CellLoad::cellId, CellLoad::load));
            this.lastCellLoadUpdateTimeMs = lastCellLoadUpdateTimeMs;
        }

        private void updateUnhealthyCellStats(int numCellsNotReadyForTenantAssignment, int numStrayBrokerCount) {
            this.numCellsNotReadyForTenantAssignment = numCellsNotReadyForTenantAssignment;
            this.numStrayBrokerCount = numStrayBrokerCount;
        }

        private int numCellTenants(int cellId) {
            return this.cellTenantCounter.get(cellId);
        }

        private int numCellBrokers(int cellId) {
            return this.cellBrokers(cellId).size();
        }

        private int numCellReplicas(int cellId) {
            return this.cellReplicaCounter.get(cellId);
        }

        private int numIncomingTenants(int cellId) {
            return this.cellIncomingTenantCounter.get(cellId);
        }

        private int numOutgoingTenants(int cellId) {
            return this.cellOutgoingTenantCounter.get(cellId);
        }

        private int numCellsNotReadyForTenantAssignment() {
            return this.numCellsNotReadyForTenantAssignment;
        }

        private int numStrayBrokerCount() {
            return this.numStrayBrokerCount;
        }

        private double cellLoad(int cellId) {
            return this.cellIdToLoad.getOrDefault(cellId, -1.0);
        }

        private int numReadyCells() {
            return this.numReadyCells;
        }

        private int numQuarantinedCells() {
            return this.numQuarantinedCells;
        }

        private int numExcludedCells() {
            return this.numExcludedCells;
        }

        private long lastCellLoadUpdateTimeMs() {
            return this.lastCellLoadUpdateTimeMs;
        }

        private void recalculateCellMetrics() {
            this.cellReplicaCounter = this.tenantIdToReplicaCounts.values().stream().reduce(new UnitCounter(), (rec$, x$0) -> ((UnitCounter)rec$).addAll((UnitCounter)x$0)).groupingByConcurrent(this::brokerCellId, Function.identity(), Integer::sum);
            this.cellTenantCounter = UnitCounter.fromReplicas(this.tenantIdToCell.values());
            this.cellIncomingTenantCounter = UnitCounter.fromReplicas(this.tenantIdToCell.entrySet().stream().filter(e -> this.isTenantMigratingToCell((String)e.getKey(), (Integer)e.getValue())).map(Map.Entry::getValue).collect(Collectors.toList()));
            this.cellOutgoingTenantCounter = UnitCounter.fromReplicas(this.tenantIdToCell.keySet().stream().flatMap(tenant -> this.cellsTenantMigratingFrom((String)tenant).stream()).collect(Collectors.toList()));
        }

        private void recalculateCellStateMetrics() {
            this.numReadyCells = (int)this.cellIdToCell.values().stream().filter(c -> c.state() == CellState.READY).count();
            this.numQuarantinedCells = (int)this.cellIdToCell.values().stream().filter(c -> c.state() == CellState.QUARANTINED).count();
            this.numExcludedCells = (int)this.cellIdToCell.values().stream().filter(c -> c.state() == CellState.EXCLUDED).count();
        }

        private boolean isTenantMigratingToCell(String tenantId, int cellId) {
            return cellId != -1 && !Collections.singleton(cellId).containsAll(this.cellIdsPresentInTenantReplicas(tenantId));
        }

        private Set<Integer> cellsTenantMigratingFrom(String tenantId) {
            int cellId = this.tenantCellId(tenantId);
            if (cellId == -1) {
                return Collections.emptySet();
            }
            Set<Integer> outgoing = this.cellIdsPresentInTenantReplicas(tenantId);
            outgoing.remove(cellId);
            return outgoing;
        }

        private static Map<Integer, Integer> calculateBrokerToCellId(Collection<Cell> cells) {
            ConcurrentHashMap<Integer, Integer> brokerIdToCell = new ConcurrentHashMap<Integer, Integer>();
            for (Cell cell : cells) {
                for (Integer brokerId : cell.brokers()) {
                    brokerIdToCell.put(brokerId, cell.cellId());
                }
            }
            return brokerIdToCell;
        }

        private int brokerCellId(int brokerId) {
            return this.brokerIdToCell.getOrDefault(brokerId, -1);
        }

        private Set<Integer> cellIdsPresentInTenantReplicas(String tenantId) {
            UnitCounter replicaCounts = this.tenantIdToReplicaCounts.getOrDefault(tenantId, UnitCounter.EMPTY_UNIT_COUNTER);
            return replicaCounts.keys().stream().map(this::brokerCellId).filter(c -> c != -1).collect(Collectors.toSet());
        }

        private int tenantCellId(String tenantId) {
            return this.tenantIdToCell.getOrDefault(tenantId, -1);
        }

        private Set<Integer> cellBrokers(int cellId) {
            Cell cell = this.cellIdToCell.get(cellId);
            return cell == null ? Collections.emptySet() : cell.brokers();
        }

        private static <E> Map<E, Integer> groupItemsByNameAndSum(Collection<List<E>> items, Function<E, Integer> mapper) {
            return items.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingByConcurrent(Function.identity(), Collectors.reducing(0, mapper, Integer::sum)));
        }
    }
}

