/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import kafka.catalog.CatalogTopicConfig;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;

public class BrokerDefaultConfigChangeEvent
extends MetadataCollectorEvent {
    private static final String LOG_RETENTION_MS_PROP = KafkaConfig.LogRetentionTimeMillisProp();
    private static final String LOG_RETENTION_BYTES_PROP = KafkaConfig.LogRetentionBytesProp();
    private static final String CLEANUP_POLICY_PROP = KafkaConfig.LogCleanupPolicyProp();
    private final KafkaConfig oldConfig;
    private final KafkaConfig newConfig;

    public BrokerDefaultConfigChangeEvent(ZKMetadataCollector collector, KafkaConfig oldConfig, KafkaConfig newConfig, Time time) {
        super(collector, time);
        this.oldConfig = oldConfig;
        this.newConfig = newConfig;
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        if (!BrokerDefaultConfigChangeEvent.hasCatalogInterestedChange(this.oldConfig, this.newConfig)) {
            LOG.debug("No catalog interested config to propagate.");
            return;
        }
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        for (String logicalCluster : context.localStore().logicalClusters()) {
            Set<String> topics = context.localStore().topics(logicalCluster);
            for (String topic : topics) {
                try {
                    TopicMetadata.Builder builder = TopicMetadata.newBuilder().mergeFrom(context.localStore().topicMetadataEvent(topic).getTopicMetadata()).setUpdateTime(eventTimestamp);
                    if (!BrokerDefaultConfigChangeEvent.propagateBrokerConfigChange(context, this.oldConfig, this.newConfig, topic, builder)) continue;
                    LOG.info("In BrokerDefaultConfigChangeEvent, propagating new KafkaConfig: {} for topic: '{}'", (Object)this.newConfig, (Object)topic);
                    MetadataEvent topicMetadataEvent = MetadataEvent.newBuilder().setTopicMetadata(builder.build()).build();
                    context.localStore().addTopicMetadataEvent(logicalCluster, topic, topicMetadataEvent);
                }
                catch (Exception e) {
                    LOG.error("Skip propagating new KafkaConfig: {} to topic '{}' due to", new Object[]{this.newConfig, topic, e});
                    context.catalogMetrics().collectorEventHandleErrorSensor.record();
                }
            }
        }
    }

    public static boolean propagateBrokerConfigChange(ZKMetadataCollectorContext context, KafkaConfig oldConfig, KafkaConfig newConfig, String topic, TopicMetadata.Builder builder) {
        Set<String> topicConfigOverrides = context.localStore().topicConfigOverrides(topic);
        KafkaConfig originConfig = context.originalConfig();
        LogConfig brokerDefault = new LogConfig(originConfig.extractLogConfigMap(), Collections.emptySet());
        boolean shouldPropagate = false;
        Object newConfigValue = newConfig.get(LOG_RETENTION_MS_PROP);
        if (!Objects.equals(oldConfig.get(LOG_RETENTION_MS_PROP), newConfigValue) && !topicConfigOverrides.contains("retention.ms")) {
            Long newRetentionMs = newConfigValue == null ? brokerDefault.retentionMs : (Long)newConfigValue;
            builder.setRetentionMs(newRetentionMs.longValue());
            shouldPropagate = true;
        }
        newConfigValue = newConfig.get(LOG_RETENTION_BYTES_PROP);
        if (!Objects.equals(oldConfig.get(LOG_RETENTION_BYTES_PROP), newConfigValue) && !topicConfigOverrides.contains("retention.bytes")) {
            Long newRetentionBytes = newConfigValue == null ? brokerDefault.retentionSize : (Long)newConfigValue;
            builder.setRetentionBytes(newRetentionBytes.longValue());
            shouldPropagate = true;
        }
        newConfigValue = newConfig.get(CLEANUP_POLICY_PROP);
        if (!Objects.equals(oldConfig.get(CLEANUP_POLICY_PROP), newConfigValue) && !topicConfigOverrides.contains("cleanup.policy")) {
            LogConfig newLogConfig = newConfigValue == null ? brokerDefault : new LogConfig(newConfig.extractLogConfigMap());
            builder.setCleanupPolicy(MetadataEventUtils.cleanupPolicyFromLogConfig(newLogConfig));
            shouldPropagate = true;
        }
        return shouldPropagate;
    }

    public static boolean hasCatalogInterestedChange(KafkaConfig oldConfig, KafkaConfig newConfig) {
        for (String config : CatalogTopicConfig.BROKER_DEFAULT_CONFIGS_TO_PROPAGATE) {
            Object newConfigValue = newConfig.get(config);
            if (Objects.equals(oldConfig.get(config), newConfigValue)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "BrokerDefaultConfigChangeEvent(oldConfig=" + this.oldConfig + ", newConfig=" + this.newConfig + ')';
    }
}

