/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005Q3Aa\u0002\u0005\u0001\u001f!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\r\u0003A\u0011\u0001#\t\u000b)\u0003A\u0011I&\u0003SQ\u0013\u0018M\\:bGRLwN\\'be.,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0015\tI!\"A\u0006ue\u0006t7/Y2uS>t'BA\u0006\r\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001!a\u0019\u0003CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005e\tS\"\u0001\u000e\u000b\u0005ma\u0012aB2mS\u0016tGo\u001d\u0006\u0003\u001buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!E\u0007\u0002\u0019%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\r\u0003\u0015)H/\u001b7t\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u00121!\u00138u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bC\u0001\u001a4\u001b\u0005A\u0011B\u0001\u001b\t\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/A\fuq:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011!gN\u0005\u0003q!\u0011q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003\t\u0002XM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8B]\u0012l\u0015M]6fe\u0016sGO]5fgB\u00191H\u0010!\u000e\u0003qR!!\u0010\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fq\u0012A\u0001T5tiB\u0011!'Q\u0005\u0003\u0005\"\u0011\u0001\u0005U3oI&twmQ8na2,G/\u001a+y]\u0006sG-T1sW\u0016\u0014XI\u001c;ss\u00061A(\u001b8jiz\"R!\u0012$H\u0011&\u0003\"A\r\u0001\t\u000b%*\u0001\u0019\u0001\u0016\t\u000bA*\u0001\u0019A\u0019\t\u000bU*\u0001\u0019\u0001\u001c\t\u000be*\u0001\u0019\u0001\u001e\u0002\u0015=t7i\\7qY\u0016$X\r\u0006\u0002M\u001fB\u00111&T\u0005\u0003\u001d2\u0012A!\u00168ji\")\u0001K\u0002a\u0001#\u0006A!/Z:q_:\u001cX\r\u0005\u0002\u001a%&\u00111K\u0007\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0001")
public class TransactionMarkerRequestCompletionHandler
implements RequestCompletionHandler,
Logging {
    private final TransactionStateManager txnStateManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkerEntries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void onComplete(ClientResponse response) {
        RequestHeader requestHeader = response.requestHeader();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Cancelled request with header ").append(requestHeader).append(" due to node ").append(response.destination()).append(" being disconnected").toString());
            CollectionConverters$.MODULE$.ListHasAsScala(this.pendingCompleteTxnAndMarkerEntries).asScala().foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$2(this, pendingCompleteTxnAndMarker);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Received WriteTxnMarker response ").append(response).append(" from node ").append(response.destination()).append(" with correlation id ").append(correlationId).toString());
        Map responseErrors = ((WriteTxnMarkersResponse)response.responseBody()).errorsByProducerId();
        CollectionConverters$.MODULE$.ListHasAsScala(this.pendingCompleteTxnAndMarkerEntries).asScala().foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$8(this, responseErrors, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onComplete$2(TransactionMarkerRequestCompletionHandler $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Option option;
        Errors errors;
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        String transactionalId = pendingCompleteTxn.transactionalId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = pendingCompleteTxnAndMarker.txnMarkerEntry();
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(158).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.txnStateManager.stateErrorSensor().record();
                throw new IllegalStateException(new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(108).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
            $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Re-enqueuing ").append(txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString());
            $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), pendingCompleteTxn, (scala.collection.immutable.Set<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(txnMarker.partitions()).asScala().toSet());
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$onComplete$13(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$onComplete$8(TransactionMarkerRequestCompletionHandler $this, Map responseErrors$1, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Option option;
        Errors errors;
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        String transactionalId = pendingCompleteTxn.transactionalId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = pendingCompleteTxnAndMarker.txnMarkerEntry();
        Map errors2 = (Map)responseErrors$1.get(BoxesRunTime.boxToLong((long)txnMarker.producerId()));
        if (errors2 == null) {
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(75).append("WriteTxnMarkerResponse does not contain expected error map for producer id ").append(txnMarker.producerId()).toString());
        }
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors3 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors3)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(158).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.txnStateManager.stateErrorSensor().record();
                throw new IllegalStateException(new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            Set retryPartitions = (Set)Set$.MODULE$.empty();
            BooleanRef abortSending = BooleanRef.create((boolean)false);
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(108).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                abortSending.elem = true;
            } else {
                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> CollectionConverters$.MODULE$.MapHasAsScala(errors2).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$13(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                    if (x$1 != null) {
                        TopicPartition topicPartition = (TopicPartition)x$1._1();
                        Errors error = (Errors)x$1._2();
                        if (Errors.NONE.equals(error)) {
                            txnMetadata.removePartition(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        if (Errors.CORRUPT_MESSAGE.equals(error) ? true : (Errors.MESSAGE_TOO_LARGE.equals(error) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(error) ? true : Errors.INVALID_REQUIRED_ACKS.equals(error)))) {
                            $this.txnStateManager.stateErrorSensor().record();
                            throw new IllegalStateException(new StringBuilder(51).append("Received fatal error ").append(error.exceptionName()).append(" while sending txn marker for ").append(transactionalId).toString());
                        }
                        if (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(error) ? true : (Errors.NOT_LEADER_OR_FOLLOWER.equals(error) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(error) ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(error) ? true : (Errors.REQUEST_TIMED_OUT.equals(error) ? true : Errors.KAFKA_STORAGE_ERROR.equals(error)))))) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("Sending ").append(transactionalId).append("'s transaction marker for partition ").append(topicPartition).append(" has failed with error ").append(error.exceptionName()).append(", retrying ").append("with current coordinator epoch ").append(epochAndMetadata.coordinatorEpoch()).toString());
                            return retryPartitions.$plus$eq((Object)topicPartition);
                        }
                        if (Errors.INVALID_PRODUCER_EPOCH.equals(error) ? true : Errors.TRANSACTION_COORDINATOR_FENCED.equals(error)) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(176).append("Sending ").append(transactionalId).append("'s transaction marker for partition ").append(topicPartition).append(" has permanently failed with error ").append(error.exceptionName()).append(" ").append("with the current coordinator epoch ").append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending any more transaction markers ").append(txnMarker).append(" to the brokers").toString());
                            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                            abortSending$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                        if (Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT.equals(error) ? true : Errors.UNSUPPORTED_VERSION.equals(error)) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(145).append("Sending ").append(transactionalId).append("'s transaction marker from partition ").append(topicPartition).append(" has failed with ").append(" ").append(error.name()).append(". This partition will be removed from the set of partitions").append(" waiting for completion").toString());
                            txnMetadata.removePartition(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        $this.txnStateManager.stateErrorSensor().record();
                        throw new IllegalStateException(new StringBuilder(47).append("Unexpected error ").append(error.exceptionName()).append(" while sending txn marker for ").append(transactionalId).toString());
                    }
                    throw new MatchError(null);
                }));
            }
            if (!abortSending.elem) {
                if (retryPartitions.nonEmpty()) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Re-enqueuing ").append(txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString());
                    $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), pendingCompleteTxn, (scala.collection.immutable.Set<TopicPartition>)retryPartitions.toSet());
                    return;
                }
                $this.txnMarkerChannelManager.maybeWriteTxnCompletion(transactionalId);
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public TransactionMarkerRequestCompletionHandler(int brokerId, TransactionStateManager txnStateManager, TransactionMarkerChannelManager txnMarkerChannelManager, List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkerEntries) {
        this.txnStateManager = txnStateManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.pendingCompleteTxnAndMarkerEntries = pendingCompleteTxnAndMarkerEntries;
        this.logIdent_$eq(new StringBuilder(50).append("[Transaction Marker Request Completion Handler ").append(brokerId).append("]: ").toString());
    }
}

