/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ThreadsCpuMeter;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\rEd\u0001B$I\u00015C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\t_\u0002\u0011)\u0019!C\u0001a\"Aq\u0010\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0006\u0002\u0002\u0001\u0011)\u0019!C\u0001\u0003\u0007A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\t\t\u0003\u0001BC\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002BCA%\u0001\t\u0007I\u0011\u0001%\u0002L!A\u00111\f\u0001!\u0002\u0013\ti\u0005C\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002`!I\u0011\u0011\r\u0001A\u0002\u0013%\u00111\r\u0005\b\u0003_\u0002\u0001\u0015)\u0003b\u0011%\tI\b\u0001b\u0001\n\u0003\tY\b\u0003\u0005\u0002\u0004\u0002\u0001\u000b\u0011BA?\u0011%\t)\t\u0001a\u0001\n\u0013\t9\tC\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"A\u00111\u0014\u0001!B\u0013\tI\tC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002 \"A\u0011q\u0015\u0001!\u0002\u0013\t\t\u000b\u0003\u0006\u0002*\u0002\u0011\r\u0011\"\u0001I\u0003WC\u0001\"a-\u0001A\u0003%\u0011Q\u0016\u0005\u000b\u0003k\u0003!\u0019!C\u0001\u0011\u0006]\u0006\u0002\u0003BI\u0001\u0001\u0006I!!/\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"A!q\u0015\u0001\u0005\u0002!\u0013I\u000bC\u0004\u0003,\u0002!\tAa\r\t\u000f\t5\u0006\u0001\"\u0001\u00034!9!q\u0016\u0001\u0005B\tE\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u000f\u0004A\u0011\tBe\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqAa6\u0001\t\u0003\u0011I\u000eC\u0005\u0003f\u0002\t\n\u0011\"\u0001\u0003h\"9!Q \u0001\u0005\u0002\t}\bbBB\u0006\u0001\u0011\u00051Q\u0002\u0005\b\u0007'\u0001A\u0011AB\u000b\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007CAqa!\n\u0001\t\u0003\u00199\u0003C\u0004\u00044\u0001!\ta!\u000e\t\u0013\r}\u0002!%A\u0005\u0002\r\u0005\u0003bBB#\u0001\u0011\u00051q\t\u0005\t\u0007#\u0002A\u0011\u0001&\u0002`!A11\u000b\u0001\u0005\u0002!\u0013IKB\u0004\u0002J\u0002\u0001\u0001*a3\t\u0015\u0005egF!A!\u0002\u0013\tY\u000eC\u0004\u0002:9\"\t!!9\t\u000f\u0005\u0015h\u0006\"\u0015\u0002h\"I\u0011Q\u001f\u0018C\u0002\u0013\u0005\u0011q\u001f\u0005\t\u0003\u007ft\u0003\u0015!\u0003\u0002z\"I!\u0011\u0001\u0018A\u0002\u0013\u0005!1\u0001\u0005\n\u0005\u0017q\u0003\u0019!C\u0001\u0005\u001bA\u0001B!\u0005/A\u0003&!Q\u0001\u0005\n\u0005+q\u0003\u0019!C\u0001\u0005/A\u0011Ba\b/\u0001\u0004%\tA!\t\t\u0011\t\u0015b\u0006)Q\u0005\u00053AqA!\u000b/\t\u0013\u0011Y\u0003C\u0004\u000329\"\tEa\r\t\u000f\tUb\u0006\"\u0003\u00038!9!q\b\u0018\u0005\n\t]\u0002b\u0002B)]\u0011%!1\u000b\u0005\b\u0005?rC\u0011\u0001B1\u000f\u001d\u0019)\u0006\u0013E\u0001\u0007/2aa\u0012%\t\u0002\re\u0003bBA\u001d\u0003\u0012\u000511\f\u0005\n\u0007;\n%\u0019!C\u0001\u0007?B\u0001ba\u0019BA\u0003%1\u0011\r\u0005\b\u0007K\nE\u0011AB4\u0011%\u0019Y'QI\u0001\n\u0003\u0019iG\u0001\u0006M_\u001e\u001cE.Z1oKJT!!\u0013&\u0002\u00071|wMC\u0001L\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001(U5B\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n1\u0011I\\=SK\u001a\u0004\"!\u0016-\u000e\u0003YS!a\u0016&\u0002\u000bU$\u0018\u000e\\:\n\u0005e3&a\u0002'pO\u001eLgn\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;*\u000baa]3sm\u0016\u0014\u0018BA0]\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u0006i\u0011N\\5uS\u0006d7i\u001c8gS\u001e\u0004\"AY7\u000e\u0003\rT!!\u00133\u000b\u0005\u00154\u0017!C5oi\u0016\u0014h.\u00197t\u0015\t9\u0007.A\u0004ti>\u0014\u0018mZ3\u000b\u0005-K'B\u00016l\u0003\u0019\t\u0007/Y2iK*\tA.A\u0002pe\u001eL!A\\2\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0003\u001dawn\u001a#jeN,\u0012!\u001d\t\u0004eV<X\"A:\u000b\u0005Q\u0004\u0016AC2pY2,7\r^5p]&\u0011ao\u001d\u0002\u0004'\u0016\f\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003\tIwNC\u0001}\u0003\u0011Q\u0017M^1\n\u0005yL(\u0001\u0002$jY\u0016\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0005Y><7/\u0006\u0002\u0002\u0006A9Q+a\u0002\u0002\f\u0005]\u0011bAA\u0005-\n!\u0001k\\8m!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tQ\u000611m\\7n_:LA!!\u0006\u0002\u0010\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\r\u00037i\u0011\u0001S\u0005\u0004\u0003;A%aC!cgR\u0014\u0018m\u0019;M_\u001e\fQ\u0001\\8hg\u0002\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dWCAA\u0013!\r\u0011\u0017qE\u0005\u0004\u0003S\u0019'\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\tQLW.\u001a\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0019q+a\u0004\n\t\u0005]\u00121\u0007\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\r\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013q\t\t\u0004\u00033\u0001\u0001\"\u00021\n\u0001\u0004\t\u0007\"B8\n\u0001\u0004\t\bbBA\u0001\u0013\u0001\u0007\u0011Q\u0001\u0005\b\u0003CI\u0001\u0019AA\u0013\u0011%\ti#\u0003I\u0001\u0002\u0004\ty#\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002NA!\u0011qJA,\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013aB7fiJL7m\u001d\u0006\u0003;\"LA!!\u0017\u0002R\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003\u0019\u0019wN\u001c4jOV\t\u0011-\u0001\u0006d_:4\u0017nZ0%KF$B!!\u001a\u0002lA\u0019q*a\u001a\n\u0007\u0005%\u0004K\u0001\u0003V]&$\b\u0002CA7\u001b\u0005\u0005\t\u0019A1\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011)\u00079\t\u0019\bE\u0002P\u0003kJ1!a\u001eQ\u0005!1x\u000e\\1uS2,\u0017AD2mK\u0006tWM]'b]\u0006<WM]\u000b\u0003\u0003{\u0002B!!\u0007\u0002\u0000%\u0019\u0011\u0011\u0011%\u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\bdY\u0016\fg.\u001a:NC:\fw-\u001a:!\u0003I\u0019w.\u001c9bGRLwN\\\"qk6+G/\u001a:\u0016\u0005\u0005%\u0005#B(\u0002\f\u0006=\u0015bAAG!\n1q\n\u001d;j_:\u00042!VAI\u0013\r\t\u0019J\u0016\u0002\u0010)\"\u0014X-\u00193t\u0007B,X*\u001a;fe\u000612m\\7qC\u000e$\u0018n\u001c8DaVlU\r^3s?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0005e\u0005\"CA7%\u0005\u0005\t\u0019AAE\u0003M\u0019w.\u001c9bGRLwN\\\"qk6+G/\u001a:!\u00039\u0019G.Z1oKJlU\r\u001e:jGN,\"!!)\u0011\t\u0005e\u00111U\u0005\u0004\u0003KC%!\u0005'pO\u000ecW-\u00198fe6+GO]5dg\u0006y1\r\\3b]\u0016\u0014X*\u001a;sS\u000e\u001c\b%A\u0005uQJ|G\u000f\u001e7feV\u0011\u0011Q\u0016\t\u0004+\u0006=\u0016bAAY-\nIA\u000b\u001b:piRdWM]\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0013\u0001C2mK\u0006tWM]:\u0016\u0005\u0005e\u0006CBA^\u0003\u0003\f)-\u0004\u0002\u0002>*\u0019\u0011qX:\u0002\u000f5,H/\u00192mK&!\u00111YA_\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u0005\u001dg&D\u0001\u0001\u00055\u0019E.Z1oKJ$\u0006N]3bIN!a&!4U!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u0003+\nA!\u001e;jY&!\u0011q[Ai\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0011QD'/Z1e\u0013\u0012\u00042aTAo\u0013\r\ty\u000e\u0015\u0002\u0004\u0013:$H\u0003BAc\u0003GDq!!71\u0001\u0004\tY.\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!;\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<|\u0003\u0011a\u0017M\\4\n\t\u0005M\u0018Q\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f\rdW-\u00198feV\u0011\u0011\u0011 \t\u0005\u00033\tY0C\u0002\u0002~\"\u0013qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0003\u0006A!\u0011\u0011\u0004B\u0004\u0013\r\u0011I\u0001\u0013\u0002\r\u00072,\u0017M\\3s'R\fGo]\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005\u0015$q\u0002\u0005\n\u0003[*\u0014\u0011!a\u0001\u0005\u000b\t!\u0002\\1tiN#\u0018\r^:!Q\r1\u00141O\u0001\u0012Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cXC\u0001B\r!\u0011\tIBa\u0007\n\u0007\tu\u0001JA\u0007Qe\u0016\u001cE.Z1o'R\fGo]\u0001\u0016Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cx\fJ3r)\u0011\t)Ga\t\t\u0013\u00055\u0004(!AA\u0002\te\u0011A\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ug\u0002B3!OA:\u0003%\u0019\u0007.Z2l\t>tW\r\u0006\u0003\u0002f\t5\u0002b\u0002B\u0018u\u0001\u0007\u00111B\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019!wnV8sWR\u0011\u0011QM\u0001\u0015iJL8\t\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4\u0015\u0005\te\u0002cA(\u0003<%\u0019!Q\b)\u0003\u000f\t{w\u000e\\3b]\u0006\t2\r\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4)\u000bu\u0012\u0019Ea\u0014\u0011\u000b=\u0013)E!\u0013\n\u0007\t\u001d\u0003K\u0001\u0004uQJ|wo\u001d\t\u0005\u00033\u0011Y%C\u0002\u0003N!\u0013A\u0003T8h\u00072,\u0017M\\5oO\u0016C8-\u001a9uS>t7E\u0001B%\u0003!\u0019G.Z1o\u0019><G\u0003BA3\u0005+BqAa\u0016?\u0001\u0004\u0011I&A\u0005dY\u0016\fg.\u00192mKB!\u0011\u0011\u0004B.\u0013\r\u0011i\u0006\u0013\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u0003:fG>\u0014Hm\u0015;biN$B\"!\u001a\u0003d\t\u001d$q\u0010BE\u0005\u001bCqA!\u001a@\u0001\u0004\tY.\u0001\u0002jI\"9!\u0011N A\u0002\t-\u0014\u0001\u00028b[\u0016\u0004BA!\u001c\u0003|9!!q\u000eB<!\r\u0011\t\bU\u0007\u0003\u0005gR1A!\u001eM\u0003\u0019a$o\\8u}%\u0019!\u0011\u0010)\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019P! \u000b\u0007\te\u0004\u000bC\u0004\u0003\u0002~\u0002\rAa!\u0002\t\u0019\u0014x.\u001c\t\u0004\u001f\n\u0015\u0015b\u0001BD!\n!Aj\u001c8h\u0011\u001d\u0011Yi\u0010a\u0001\u0005\u0007\u000b!\u0001^8\t\u000f\t=u\b1\u0001\u0003\u0006\u0005)1\u000f^1ug\u0006I1\r\\3b]\u0016\u00148\u000fI\u0001\u0016[\u0006DxJ^3s\u00072,\u0017M\\3s)\"\u0014X-\u00193t)\u0011\tYNa&\t\u000f\te%\u00041\u0001\u0003\u001c\u0006\ta\rE\u0004P\u0005;\u000b)M!)\n\u0007\t}\u0005KA\u0005Gk:\u001cG/[8ocA\u0019qJa)\n\u0007\t\u0015\u0006K\u0001\u0004E_V\u0014G.Z\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\u0011\u00111\\\u0001\bgR\f'\u000f^;q\u0003!\u0019\b.\u001e;e_^t\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005g\u0003RA\u001dB[\u0005WJ1Aa.t\u0005\r\u0019V\r^\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!!\u001a\u0003>\"9!qX\u0010A\u0002\t\u0005\u0017!\u00038fo\u000e{gNZ5h!\rY&1Y\u0005\u0004\u0005\u000bd&aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u0011Q\rBf\u0005\u001fDqA!4!\u0001\u0004\u0011\t-A\u0005pY\u0012\u001cuN\u001c4jO\"9!q\u0018\u0011A\u0002\t\u0005\u0017!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002f\tU\u0007b\u0002B\u0018C\u0001\u0007\u00111B\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cHCBA3\u00057\u0014y\u000e\u0003\u0004\u0003^\n\u0002\ra^\u0001\bI\u0006$\u0018\rR5s\u0011%\u0011\tO\tI\u0001\u0002\u0004\u0011\u0019/A\tqCJ$\u0018\u000e^5p]R{'+Z7pm\u0016\u0004RaTAF\u0003\u0017\t1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TC\u0001BuU\u0011\u0011\u0019Oa;,\u0005\t5\b\u0003\u0002Bx\u0005sl!A!=\u000b\t\tM(Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa>Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005w\u0014\tPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u0011QMB\u0001\u0007\u0007\u00199\u0001C\u0004\u00030\u0011\u0002\r!a\u0003\t\r\r\u0015A\u00051\u0001x\u00031\u0019x.\u001e:dK2{w\rR5s\u0011\u0019\u0019I\u0001\na\u0001o\u0006QA-Z:u\u0019><G)\u001b:\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\t\u0005\u00154q\u0002\u0005\b\u0007#)\u0003\u0019\u0001B6\u0003\r!\u0017N]\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"!\u001a\u0004\u0018\re11\u0004\u0005\u0007\u0005;4\u0003\u0019A<\t\u000f\t=b\u00051\u0001\u0002\f!91Q\u0004\u0014A\u0002\t\r\u0015AB8gMN,G/A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005\u001541\u0005\u0005\b\u0005_9\u0003\u0019AA\u0006\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!!\u001a\u0004*!911\u0006\u0015A\u0002\r5\u0012a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u000bI\u001cy#a\u0003\n\u0007\rE2O\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00031\tw/Y5u\u00072,\u0017M\\3e)!\u0011Ida\u000e\u0004:\rm\u0002b\u0002B\u0018S\u0001\u0007\u00111\u0002\u0005\b\u0007;I\u0003\u0019\u0001BB\u0011%\u0019i$\u000bI\u0001\u0002\u0004\u0011\u0019)A\u0005nCb<\u0016-\u001b;Ng\u00061\u0012m^1ji\u000ecW-\u00198fI\u0012\"WMZ1vYR$3'\u0006\u0002\u0004D)\"!1\u0011Bv\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0007\u0013\u0002RA]B\u0018\u0007\u0017\u0002raTB'\u0003\u0017\t9\"C\u0002\u0004PA\u0013a\u0001V;qY\u0016\u0014\u0014!D2veJ,g\u000e^\"p]\u001aLw-\u0001\u0007dY\u0016\fg.\u001a:D_VtG/\u0001\u0006M_\u001e\u001cE.Z1oKJ\u00042!!\u0007B'\t\te\n\u0006\u0002\u0004X\u0005)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXCAB1!\u0015\u0011(QWAu\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!D2mK\u0006tWM]\"p]\u001aLw\rF\u0002b\u0007SBq!!\u0018F\u0001\u0004\u0011\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007_RC!a\f\u0003l\u0002")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private Option<ThreadsCpuMeter> compactionCpuMeter;
    private final LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    private Option<ThreadsCpuMeter> compactionCpuMeter() {
        return this.compactionCpuMeter;
    }

    private void compactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.compactionCpuMeter = x$1;
    }

    public LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics() {
        return this.kafka$log$LogCleaner$$cleanerMetrics;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
        this.compactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((scala.collection.immutable.Seq<Object>)((IterableOnceOps)this.cleaners().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getId()))).toSeq())));
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (long)((int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))))) / 1000L;
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$3() {
        return this.cleanerManager().cleanBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$4() {
        return this.cleanerManager().cleanableBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$5() {
        return this.cleanerManager().uncleanableBytesLast().get();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$6() {
        return (int)((double)100 * this.cleanerManager().dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$2) {
        return x$2.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$2));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ double kafka$log$LogCleaner$$$anonfun$new$9() {
        return BoxesRunTime.unboxToDouble((Object)this.compactionCpuMeter().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * (double)100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$12() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$4 -> x$4.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$17(CleanerThread x$7) {
        return x$7.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$16() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$17(x$7));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$18() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$8 -> x$8.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$23(CleanerThread x$11) {
        return x$11.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$22() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$23(x$11));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$25(CleanerThread x$12) {
        return x$12.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$24() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$25(x$12));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$26() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$16 -> x$16 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.compactionCpuMeter = None$.MODULE$;
        this.kafka$log$LogCleaner$$cleanerMetrics = new LogCleanerMetrics((Option<String>)None$.MODULE$);
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxCompactionDelayGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsUncleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxDirtyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxBufferUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final double value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanerRecopyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge("max-buffer-utilization-percent", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("cleaner-recopy-percent", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$18();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("max-clean-time-secs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$22();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("max-compaction-delay-secs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$24();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("DeadThreadCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$17 -> (TopicPartition)x$17._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tOffset Map is Full: %b"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stats.offsetMapFull())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            }, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastStats = new CleanerStats(LogCleaner.this.kafka$log$LogCleaner$$time, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

