/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005w!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%I!\u0015\u0005\u0007+\u0006\u0001\u000b\u0011\u0002*\t\u000bY\u000bA\u0011A,\t\u0013\t]\u0014!%A\u0005\u0002\te\u0004\"\u0003BJ\u0003E\u0005I\u0011\u0001BK\u0011%\u0011I*AI\u0001\n\u0003\u0011Y\nC\u0005\u0003$\u0006\t\n\u0011\"\u0001\u0003&\"I!\u0011V\u0001\u0012\u0002\u0013\u0005!1\u0016\u0005\n\u0005_\u000b\u0011\u0013!C\u0001\u0005cC\u0011B!.\u0002#\u0003%\tAa.\t\u0013\tm\u0016!%A\u0005\u0002\tuf\u0001\u0002$@\u0005iC\u0001B\u0019\b\u0003\u0002\u0003\u0006Ia\u0019\u0005\t]:\u0011\t\u0011)A\u0005_\"AQO\u0004B\u0001B\u0003%!\u000b\u0003\u0005w\u001d\t\u0005\t\u0015!\u0003S\u0011!9hB!A!\u0002\u0013A\b\u0002C>\u000f\u0005\u0003\u0005\u000b\u0011\u0002=\t\u000b9sA\u0011\u0001?\t\u0013\u0005}aB1A\u0005\n\u0005\u0005\u0002\u0002CA\u001e\u001d\u0001\u0006I!a\t\u0007\r\u0005ub\u0002BA \u0011\u0019q\u0005\u0004\"\u0001\u0002B!I\u0011q\t\rC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003[C\u0002\u0015!\u0003\u0002L!I\u0011q\u0016\rC\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003\u007fC\u0002\u0015!\u0003\u00024\"9\u0011\u0011\u0019\r\u0005\u0002\u0005\r\u0007\"CAf\u001d\t\u0007I\u0011BAg\u0011!\t)N\u0004Q\u0001\n\u0005=\u0007bBAl\u001d\u0011%\u0011\u0011\u001c\u0005\t\u0003;t\u0001\u0015!\u0003\u0002`\"I\u00111\u001e\bC\u0002\u0013%\u0011Q\u001e\u0005\t\u0005\u000bq\u0001\u0015!\u0003\u0002p\"I!q\u0001\bC\u0002\u0013%!\u0011\u0002\u0005\t\u0005;q\u0001\u0015!\u0003\u0003\f!9!q\u0004\b\u0005\u0002\t\u0005\u0002b\u0002B\u001c\u001d\u0011\u0005!\u0011\b\u0005\u0007\u0005{qA\u0011A)\t\r\t}b\u0002\"\u0001R\u0011\u001d\u0011\tE\u0004C\u0001\u0005\u0007BqAa\u0012\u000f\t\u0013\u0011I\u0005C\u0004\u0003P9!IA!\u0015\t\u000f\tec\u0002\"\u0001\u0003\u0004\u00191\u0011\u0011\f\b\u0005\u00037B!\"!\u00180\u0005\u000b\u0007I\u0011AA0\u0011)\t\tg\fB\u0001B\u0003%\u0011\u0011\u000b\u0005\u0007\u001d>\"\t!a\u0019\t\u0011\u0005\u001dt\u0006)A\u0005\u0003SBa!! 0\t\u0003\t\u0006bBA@_\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0007{C\u0011AAC\u0011\u001d\t\tj\fC\u0001\u0003'Cq!!&0\t\u0003\t9\nC\u0004\u0002,>\"\t!a%\t\u000f\tmc\u0002\"\u0001\u0003^\u00191\u0011\u0011\u001f\b\u0005\u0003gDaAT\u001e\u0005\u0002\u0005}\bb\u0002B\u0001w\u0011\u0005#1A\u0001\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018P\u0003\u0002A\u0003\u000611/\u001a:wKJT\u0011AQ\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0015!D\u0001@\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0014\u0005\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\t\u000611\u000b[1sIN,\u0012A\u0015\t\u0003\u0013NK!\u0001\u0016&\u0003\u0007%sG/A\u0004TQ\u0006\u0014Hm\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0007a\u0013Y\u0007F\u0006Z\u0005[\u0012yG!\u001d\u0003t\tU\u0004\u0003B#\u000f\u0005S*2aWA\u0001'\rq\u0001\n\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0006\u000bQ!\u001e;jYNL!!\u00190\u0003\u000f1{wmZ5oO\u0006i\u0001/\u001e:hCR|'/\u001f(b[\u0016\u0004\"\u0001Z6\u000f\u0005\u0015L\u0007C\u00014K\u001b\u00059'B\u00015D\u0003\u0019a$o\\8u}%\u0011!NS\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002k\u0015\u0006aA/[7f_V$H+[7feB\u0011\u0001o]\u0007\u0002c*\u0011!OX\u0001\u0006i&lWM]\u0005\u0003iF\u0014Q\u0001V5nKJ\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u000eaV\u0014x-Z%oi\u0016\u0014h/\u00197\u0002\u001bI,\u0017\r]3s\u000b:\f'\r\\3e!\tI\u00150\u0003\u0002{\u0015\n9!i\\8mK\u0006t\u0017\u0001\u0004;j[\u0016\u0014XI\\1cY\u0016$G#D?\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\u0002E\u0002F\u001dy\u00042a`A\u0001\u0019\u0001!q!a\u0001\u000f\u0005\u0004\t)AA\u0001U#\u0011\t9!!\u0004\u0011\u0007%\u000bI!C\u0002\u0002\f)\u0013qAT8uQ&tw\rE\u0002F\u0003\u001fI1!!\u0005@\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eC\u0003c+\u0001\u00071\rC\u0003o+\u0001\u0007q\u000eC\u0004v+A\u0005\t\u0019\u0001*\t\u000fY,\u0002\u0013!a\u0001%\"9q/\u0006I\u0001\u0002\u0004A\bbB>\u0016!\u0003\u0005\r\u0001_\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003G\u0001B!!\n\u000285\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0001\u000biCC\u0002C\u0003_QA!!\r\u00024\u00051\u0011\r]1dQ\u0016T!!!\u000e\u0002\u0007=\u0014x-\u0003\u0003\u0002:\u0005\u001d\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\u00121bV1uG\",'\u000fT5tiN\u0011\u0001\u0004\u0013\u000b\u0003\u0003\u0007\u00022!!\u0012\u0019\u001b\u0005q\u0011!D<bi\u000eDWM]:Cs.+\u00170\u0006\u0002\u0002LA9Q,!\u0014\u0002R\u0005]\u0013bAA(=\n!\u0001k\\8m!\rI\u00151K\u0005\u0004\u0003+R%aA!osB\u0019\u0011QI\u0018\u0003\u0011]\u000bGo\u00195feN\u001c\"a\f%\u0002\u0007-,\u00170\u0006\u0002\u0002R\u0005!1.Z=!)\u0011\t9&!\u001a\t\u000f\u0005u#\u00071\u0001\u0002R\u0005Qq\u000e]3sCRLwN\\:\u0011\u000b\u0005-\u0014\u0011\u0010@\u000e\u0005\u00055$\u0002BA8\u0003c\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\u0019(!\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003o\nAA[1wC&!\u00111PA7\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\fAbY8v]R<\u0016\r^2iK\u0012\fq![:F[B$\u00180F\u0001y\u0003\u00159\u0018\r^2i)\u0011\t9)!$\u0011\u0007%\u000bI)C\u0002\u0002\f*\u0013A!\u00168ji\"1\u0011q\u0012\u001cA\u0002y\f\u0011\u0001^\u0001\u0013iJL8i\\7qY\u0016$XmV1uG\",G\rF\u0001S\u0003\u0019\u0019\u0017M\\2fYR\u0011\u0011\u0011\u0014\t\u0006\u00037\u000b)K \b\u0005\u0003;\u000b\tKD\u0002g\u0003?K\u0011aS\u0005\u0004\u0003GS\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003O\u000bIK\u0001\u0003MSN$(bAAR\u0015\u0006q\u0001/\u001e:hK\u000e{W\u000e\u001d7fi\u0016$\u0017AD<bi\u000eDWM]:Cs.+\u0017\u0010I\u0001\ro\u0006$8\r[3sg2{7m[\u000b\u0003\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bi'A\u0003m_\u000e\\7/\u0003\u0003\u0002>\u0006]&!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0007xCR\u001c\u0007.\u001a:t\u0019>\u001c7\u000eI\u0001\fC2dw+\u0019;dQ\u0016\u00148/\u0006\u0002\u0002FB1\u00111TAd\u0003/JA!!3\u0002*\nA\u0011\n^3sC\ndW-\u0001\u0007xCR\u001c\u0007.\u001a:MSN$8/\u0006\u0002\u0002PB)\u0011*!5\u0002D%\u0019\u00111\u001b&\u0003\u000b\u0005\u0013(/Y=\u0002\u001b]\fGo\u00195fe2K7\u000f^:!\u0003-9\u0018\r^2iKJd\u0015n\u001d;\u0015\t\u0005\r\u00131\u001c\u0005\b\u0003;\n\u0003\u0019AA)\u0003a)7\u000f^5nCR,G\rV8uC2|\u0005/\u001a:bi&|gn\u001d\t\u0005\u0003C\f9/\u0004\u0002\u0002d*!\u0011Q]A7\u0003\u0019\tGo\\7jG&!\u0011\u0011^Ar\u00055\tEo\\7jG&sG/Z4fe\u0006\u0001R\r\u001f9je\u0006$\u0018n\u001c8SK\u0006\u0004XM]\u000b\u0003\u0003_\u00042!!\u0012<\u0005Y)\u0005\u0010]5sK\u0012|\u0005/\u001a:bi&|gNU3ba\u0016\u00148cA\u001e\u0002vB!\u0011q_A~\u001b\t\tIP\u0003\u0003\u0002t\u0005-\u0012\u0002BA\u007f\u0003s\u0014!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIR\u0011\u0011q^\u0001\u0007I><vN]6\u0015\u0005\u0005\u001d\u0015!E3ya&\u0014\u0018\r^5p]J+\u0017\r]3sA\u0005YQ.\u001a;sS\u000e\u001cH+Y4t+\t\u0011Y\u0001E\u0004\u0003\u000e\t=!1C2\u000e\u0005\u0005E\u0014\u0002\u0002B\t\u0003c\u00121!T1q!\u0011\u0011)Ba\u0007\u000e\u0005\t]!\u0002\u0002B\r\u0003k\nA\u0001\\1oO&\u0019ANa\u0006\u0002\u00195,GO]5dgR\u000bwm\u001d\u0011\u0002)Q\u0014\u0018pQ8na2,G/Z#mg\u0016<\u0016\r^2i)\u0015A(1\u0005B\u0014\u0011\u0019\u0011)c\na\u0001}\u0006Iq\u000e]3sCRLwN\u001c\u0005\b\u0005S9\u0003\u0019\u0001B\u0016\u0003%9\u0018\r^2i\u0017\u0016L8\u000f\u0005\u0004\u0003.\tM\u0012\u0011K\u0007\u0003\u0005_Q1A!\rK\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0011yCA\u0002TKF\f\u0001c\u00195fG.\fe\u000eZ\"p[BdW\r^3\u0015\u0007I\u0013Y\u0004C\u0004\u0002^!\u0002\r!!\u0015\u0002\u000f]\fGo\u00195fI\u0006Qa.^7EK2\f\u00170\u001a3\u0002\u0019\r\fgnY3m\r>\u00148*Z=\u0015\t\u0005e%Q\t\u0005\b\u0003;Z\u0003\u0019AA)\u0003E9\u0018\r^2i\r>\u0014x\n]3sCRLwN\u001c\u000b\u0007\u0003\u000f\u0013YE!\u0014\t\u000f\u0005uC\u00061\u0001\u0002R!1!Q\u0005\u0017A\u0002y\f\u0001C]3n_Z,7*Z=JM\u0016k\u0007\u000f^=\u0015\r\u0005\u001d%1\u000bB+\u0011\u001d\ti&\fa\u0001\u0003#BqAa\u0016.\u0001\u0004\t9&\u0001\u0005xCR\u001c\u0007.\u001a:t\u0003!\u0019\b.\u001e;e_^t\u0017\u0001D1em\u0006t7-Z\"m_\u000e\\G\u0003BAD\u0005?BqA!\u0019;\u0001\u0004\u0011\u0019'A\u0005uS6,w.\u001e;NgB\u0019\u0011J!\u001a\n\u0007\t\u001d$J\u0001\u0003M_:<\u0007cA@\u0003l\u00119\u00111A\u0003C\u0002\u0005\u0015\u0001\"\u00022\u0006\u0001\u0004\u0019\u0007bB;\u0006!\u0003\u0005\rA\u0015\u0005\bm\u0016\u0001\n\u00111\u0001S\u0011\u001d9X\u0001%AA\u0002aDqa_\u0003\u0011\u0002\u0003\u0007\u00010A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011YH!%\u0016\u0005\tu$f\u0001*\u0003\u0000-\u0012!\u0011\u0011\t\u0005\u0005\u0007\u0013i)\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003%)hn\u00195fG.,GMC\u0002\u0003\f*\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yI!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0002\u0004\u0019\u0011\r!!\u0002\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*BAa\u001f\u0003\u0018\u00129\u00111A\u0004C\u0002\u0005\u0015\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\t\tu%\u0011U\u000b\u0003\u0005?S3\u0001\u001fB@\t\u001d\t\u0019\u0001\u0003b\u0001\u0003\u000b\tq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0005\u0005;\u00139\u000bB\u0004\u0002\u0004%\u0011\r!!\u0002\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011YH!,\u0005\u000f\u0005\r!B1\u0001\u0002\u0006\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*BAa\u001f\u00034\u00129\u00111A\u0006C\u0002\u0005\u0015\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0003\u001e\neFaBA\u0002\u0019\t\u0007\u0011QA\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\tu%q\u0018\u0003\b\u0003\u0007i!\u0019AA\u0003\u0001")
public final class DelayedOperationPurgatory<T extends DelayedOperation>
implements Logging {
    public final String kafka$server$DelayedOperationPurgatory$$purgatoryName;
    private final Timer timeoutTimer;
    public final int kafka$server$DelayedOperationPurgatory$$brokerId;
    private final int purgeInterval;
    private final boolean reaperEnabled;
    private final boolean timerEnabled;
    private final KafkaMetricsGroup metricsGroup;
    private final WatcherList[] watcherLists;
    private final AtomicInteger estimatedTotalOperations;
    private final ExpiredOperationReaper expirationReaper;
    private final java.util.Map<String, String> metricsTags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends DelayedOperation> boolean $lessinit$greater$default$6() {
        return true;
    }

    public static <T extends DelayedOperation> boolean $lessinit$greater$default$5() {
        return true;
    }

    public static <T extends DelayedOperation> int $lessinit$greater$default$4() {
        return 1000;
    }

    public static <T extends DelayedOperation> int $lessinit$greater$default$3() {
        return 0;
    }

    public static <T extends DelayedOperation> boolean apply$default$5() {
        return true;
    }

    public static <T extends DelayedOperation> boolean apply$default$4() {
        return true;
    }

    public static <T extends DelayedOperation> int apply$default$3() {
        return 1000;
    }

    public static <T extends DelayedOperation> int apply$default$2() {
        return 0;
    }

    public static <T extends DelayedOperation> DelayedOperationPurgatory<T> apply(String purgatoryName, int brokerId, int purgeInterval, boolean reaperEnabled, boolean timerEnabled) {
        return DelayedOperationPurgatory$.MODULE$.apply(purgatoryName, brokerId, purgeInterval, reaperEnabled, timerEnabled);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private WatcherList[] watcherLists() {
        return this.watcherLists;
    }

    private WatcherList watcherList(Object key) {
        return this.watcherLists()[Math.abs(key.hashCode() % this.watcherLists().length)];
    }

    private ExpiredOperationReaper expirationReaper() {
        return this.expirationReaper;
    }

    private java.util.Map<String, String> metricsTags() {
        return this.metricsTags;
    }

    public boolean tryCompleteElseWatch(T operation, Seq<Object> watchKeys) {
        Predef$.MODULE$.assert(watchKeys.nonEmpty(), (Function0 & Serializable)() -> "The watch key list can't be empty");
        if (((DelayedOperation)operation).safeTryCompleteOrElse((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            watchKeys.foreach((Function1 & Serializable)key -> {
                this.watchForOperation(key, operation);
                return BoxedUnit.UNIT;
            });
            if (watchKeys.nonEmpty()) {
                $this.estimatedTotalOperations.incrementAndGet();
                return;
            }
        })) {
            return true;
        }
        if (!((DelayedOperation)operation).isCompleted()) {
            if (this.timerEnabled) {
                this.timeoutTimer.add((TimerTask)operation);
            }
            if (((DelayedOperation)operation).isCompleted()) {
                ((DelayedOperation)operation).cancel();
            }
        }
        return false;
    }

    public int checkAndComplete(Object key) {
        int numCompleted;
        WatcherList wl = this.watcherList(key);
        Watchers watchers = (Watchers)CoreUtils$.MODULE$.inLock(wl.watchersLock(), (Function0 & Serializable)() -> wl.watchersByKey().get(key));
        int n = numCompleted = watchers == null ? 0 : watchers.tryCompleteWatched();
        if (numCompleted > 0 && this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = DelayedOperationPurgatory.$anonfun$checkAndComplete$2(this, key, numCompleted);
            Object var5_5 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return numCompleted;
    }

    public int watched() {
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])this.watcherLists()), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedOperationPurgatory.$anonfun$watched$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
    }

    public int numDelayed() {
        return this.timeoutTimer.size();
    }

    public List<T> cancelForKey(Object key) {
        WatcherList wl = this.watcherList(key);
        return (List)CoreUtils$.MODULE$.inLock(wl.watchersLock(), (Function0 & Serializable)() -> {
            Watchers watchers = wl.watchersByKey().remove(key);
            if (watchers != null) {
                return watchers.cancel();
            }
            return Nil$.MODULE$;
        });
    }

    private void watchForOperation(Object key, T operation) {
        WatcherList wl = this.watcherList(key);
        CoreUtils$.MODULE$.inLock(wl.watchersLock(), (JFunction0.mcV.sp & Serializable)() -> wl.watchersByKey().getAndMaybePut(key).watch(operation));
    }

    public void kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(Object key, Watchers watchers) {
        Object object = new Object();
        try {
            WatcherList wl = this.watcherList(key);
            CoreUtils$.MODULE$.inLock(wl.watchersLock(), (Function0 & Serializable)() -> {
                Watchers watchers = wl.watchersByKey().get(key);
                if (watchers == null ? watchers != null : !watchers.equals(watchers)) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                if (watchers != null && watchers.isEmpty()) {
                    return wl.watchersByKey().remove(key);
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void shutdown() {
        if (this.reaperEnabled) {
            this.expirationReaper().initiateShutdown();
            this.timeoutTimer.add(new TimerTask(null){
                private final long delayMs;
                private TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry;

                public void cancel() {
                    TimerTask.cancel$(this);
                }

                public void setTimerTaskEntry(TimerTaskEntry entry) {
                    TimerTask.setTimerTaskEntry$(this, entry);
                }

                public TimerTaskEntry getTimerTaskEntry() {
                    return TimerTask.getTimerTaskEntry$(this);
                }

                public TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry() {
                    return this.kafka$utils$timer$TimerTask$$timerTaskEntry;
                }

                public void kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(TimerTaskEntry x$1) {
                    this.kafka$utils$timer$TimerTask$$timerTaskEntry = x$1;
                }

                public long delayMs() {
                    return this.delayMs;
                }

                public void run() {
                }
                {
                    this.delayMs = 0L;
                }
            });
            this.expirationReaper().awaitShutdown();
        }
        this.timeoutTimer.shutdown();
        this.metricsGroup().removeMetric("PurgatorySize", this.metricsTags());
        this.metricsGroup().removeMetric("NumDelayedOperations", this.metricsTags());
    }

    public void advanceClock(long timeoutMs) {
        this.timeoutTimer.advanceClock(timeoutMs);
        if (this.estimatedTotalOperations.get() - this.numDelayed() > this.purgeInterval) {
            this.estimatedTotalOperations.getAndSet(this.numDelayed());
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = "Begin purging watch lists";
                Object var4_2 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            int purged = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])this.watcherLists()), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedOperationPurgatory.$anonfun$advanceClock$2(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Purged %d elements from watch lists."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)purged)}));
                Object var5_4 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
    }

    public final /* synthetic */ int kafka$server$DelayedOperationPurgatory$$$anonfun$new$1() {
        return this.watched();
    }

    public final /* synthetic */ int kafka$server$DelayedOperationPurgatory$$$anonfun$new$2() {
        return this.numDelayed();
    }

    public static final /* synthetic */ String $anonfun$checkAndComplete$2(DelayedOperationPurgatory $this, Object key$1, int numCompleted$1) {
        return new StringBuilder(35).append("Request key ").append(key$1).append(" unblocked ").append(numCompleted$1).append(" ").append($this.kafka$server$DelayedOperationPurgatory$$purgatoryName).append(" operations").toString();
    }

    public static final /* synthetic */ int $anonfun$watched$1(int x0$1, WatcherList x1$1) {
        return x0$1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x1$1.allWatchers().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.countWatched()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$advanceClock$1() {
        return "Begin purging watch lists";
    }

    public static final /* synthetic */ int $anonfun$advanceClock$2(int x0$1, WatcherList x1$1) {
        return x0$1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x1$1.allWatchers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.purgeCompleted()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public DelayedOperationPurgatory(String purgatoryName, Timer timeoutTimer, int brokerId, int purgeInterval, boolean reaperEnabled, boolean timerEnabled) {
        this.kafka$server$DelayedOperationPurgatory$$purgatoryName = purgatoryName;
        this.timeoutTimer = timeoutTimer;
        this.kafka$server$DelayedOperationPurgatory$$brokerId = brokerId;
        this.purgeInterval = purgeInterval;
        this.reaperEnabled = reaperEnabled;
        this.timerEnabled = timerEnabled;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.watcherLists = (WatcherList[])Array$.MODULE$.fill(DelayedOperationPurgatory$.MODULE$.kafka$server$DelayedOperationPurgatory$$Shards(), (Function0 & Serializable)() -> new WatcherList(), ClassTag$.MODULE$.apply(WatcherList.class));
        this.estimatedTotalOperations = new AtomicInteger(0);
        this.expirationReaper = new ExpiredOperationReaper();
        this.metricsTags = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delayedOperation"), (Object)purgatoryName)}))).asJava();
        this.metricsGroup().newGauge("PurgatorySize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ DelayedOperationPurgatory $outer;

            public final int value() {
                DelayedOperationPurgatory delayedOperationPurgatory = this.$outer;
                if (delayedOperationPurgatory == null) {
                    throw null;
                }
                return delayedOperationPurgatory.watched();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.metricsTags());
        this.metricsGroup().newGauge("NumDelayedOperations", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ DelayedOperationPurgatory $outer;

            public final int value() {
                DelayedOperationPurgatory delayedOperationPurgatory = this.$outer;
                if (delayedOperationPurgatory == null) {
                    throw null;
                }
                return delayedOperationPurgatory.numDelayed();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.metricsTags());
        if (reaperEnabled) {
            this.expirationReaper().start();
        }
    }

    private class ExpiredOperationReaper
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$server$DelayedOperationPurgatory$ExpiredOperationReaper$$$outer().advanceClock(200L);
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$ExpiredOperationReaper$$$outer() {
            return DelayedOperationPurgatory.this;
        }

        public ExpiredOperationReaper() {
            if (DelayedOperationPurgatory.this == null) {
                throw null;
            }
            super(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("ExpirationReaper-%d-%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DelayedOperationPurgatory.this.kafka$server$DelayedOperationPurgatory$$brokerId), DelayedOperationPurgatory.this.kafka$server$DelayedOperationPurgatory$$purgatoryName})), false);
        }
    }

    private class WatcherList {
        private final Pool<Object, Watchers> watchersByKey;
        private final ReentrantLock watchersLock;

        public Pool<Object, Watchers> watchersByKey() {
            return this.watchersByKey;
        }

        public ReentrantLock watchersLock() {
            return this.watchersLock;
        }

        public Iterable<Watchers> allWatchers() {
            return this.watchersByKey().values();
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$WatcherList$$$outer() {
            return DelayedOperationPurgatory.this;
        }

        public WatcherList() {
            if (DelayedOperationPurgatory.this == null) {
                throw null;
            }
            this.watchersByKey = new Pool(new Some((Function1 & Serializable)key -> new Watchers(this.kafka$server$DelayedOperationPurgatory$WatcherList$$$outer(), key)));
            this.watchersLock = new ReentrantLock();
        }
    }

    private class Watchers {
        private final Object key;
        private final ConcurrentLinkedQueue<T> operations;
        public final /* synthetic */ DelayedOperationPurgatory $outer;

        public Object key() {
            return this.key;
        }

        public int countWatched() {
            return this.operations.size();
        }

        public boolean isEmpty() {
            return this.operations.isEmpty();
        }

        public void watch(T t) {
            this.operations.add(t);
        }

        public int tryCompleteWatched() {
            int completed = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                if (curr.isCompleted()) {
                    iter.remove();
                    continue;
                }
                if (!curr.safeTryComplete()) continue;
                iter.remove();
                ++completed;
            }
            if (this.operations.isEmpty()) {
                this.kafka$server$DelayedOperationPurgatory$Watchers$$$outer().kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(this.key(), this);
            }
            return completed;
        }

        public List<T> cancel() {
            Iterator iter = this.operations.iterator();
            ListBuffer cancelled = new ListBuffer();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                curr.cancel();
                iter.remove();
                cancelled.$plus$eq((Object)curr);
            }
            return cancelled.toList();
        }

        public int purgeCompleted() {
            int purged = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                if (!((DelayedOperation)iter.next()).isCompleted()) continue;
                iter.remove();
                ++purged;
            }
            if (this.operations.isEmpty()) {
                this.kafka$server$DelayedOperationPurgatory$Watchers$$$outer().kafka$server$DelayedOperationPurgatory$$removeKeyIfEmpty(this.key(), this);
            }
            return purged;
        }

        public /* synthetic */ DelayedOperationPurgatory kafka$server$DelayedOperationPurgatory$Watchers$$$outer() {
            return this.$outer;
        }

        public Watchers(DelayedOperationPurgatory $outer, Object key) {
            this.key = key;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.operations = new ConcurrentLinkedQueue();
        }
    }
}

