/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.controller.ClusterBalanceManager;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tue\u0001B A\u0001\u0015C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t5\u0002\u0011\t\u0011)A\u00057\")q\r\u0001C\u0001Q\"QA\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B7\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001bBA\u000f\u0001\u0001\u0006I\u0001\u001d\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CAq!a\t\u0001A\u0003%1\u000fC\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!9\u0011\u0011\u0006\u0001!\u0002\u0013Y\b\"CA\u0016\u0001\t\u0007I\u0011BA\u0017\u0011!\tI\u0004\u0001Q\u0001\n\u0005=\u0002\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005}\u0002\"CA+\u0001\t\u0007I\u0011BA,\u0011!\t)\n\u0001Q\u0001\n\u0005e\u0003\"CAL\u0001\t\u0007I\u0011BAM\u0011!\t\t\u000b\u0001Q\u0001\n\u0005m\u0005\"CAR\u0001\t\u0007I\u0011BAS\u0011!\ty\u000b\u0001Q\u0001\n\u0005\u001d\u0006\"CAY\u0001\t\u0007I\u0011AAZ\u0011!\t\u0019\r\u0001Q\u0001\n\u0005U\u0006\"CA_\u0001\t\u0007I\u0011BAc\u0011!\ty\r\u0001Q\u0001\n\u0005\u001d\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u00037\u0004A\u0011IAj\u0011\u001d\ti\u000e\u0001C!\u0003'<q!a8A\u0011\u0003\t\tO\u0002\u0004@\u0001\"\u0005\u00111\u001d\u0005\u0007Ov!\t!!:\t\u0013\u0005\u001dXD1A\u0005\u0002\u0005%\b\u0002CAx;\u0001\u0006I!a;\t\u0013\u0005EXD1A\u0005\u0002\u0005M\b\u0002CA\u007f;\u0001\u0006I!!>\t\u0013\u0005}XD1A\u0005\u0002\t\u0005\u0001\u0002\u0003B\u0005;\u0001\u0006IAa\u0001\u0007\u0013\t-Q\u0004%A\u0012\"\t5qa\u0002BC;!\u0005%1\u0007\u0004\b\u0005#i\u0002\u0012\u0011B\n\u0011\u00199w\u0005\"\u0001\u00032!9!QG\u0014\u0005B\t]\u0002\"\u0003B\u001dO\u0005\u0005I\u0011IAu\u0011%\u0011YdJA\u0001\n\u0003\u0011i\u0004C\u0005\u0003F\u001d\n\t\u0011\"\u0001\u0003H!I!\u0011K\u0014\u0002\u0002\u0013\u0005#1\u000b\u0005\n\u00057:\u0013\u0011!C\u0001\u0005;B\u0011Ba\u001a(\u0003\u0003%\tE!\u001b\t\u0013\t-t%!A\u0005\n\t5ta\u0002BD;!\u0005%1\u0010\u0004\b\u0005kj\u0002\u0012\u0011B<\u0011\u00199'\u0007\"\u0001\u0003z!9!Q\u0007\u001a\u0005B\t]\u0002\"\u0003B\u001de\u0005\u0005I\u0011IAu\u0011%\u0011YDMA\u0001\n\u0003\u0011i\u0004C\u0005\u0003FI\n\t\u0011\"\u0001\u0003~!I!\u0011\u000b\u001a\u0002\u0002\u0013\u0005#1\u000b\u0005\n\u00057\u0012\u0014\u0011!C\u0001\u0005\u0003C\u0011Ba\u001a3\u0003\u0003%\tE!\u001b\t\u0013\t-$'!A\u0005\n\t5\u0004b\u0002BE;\u0011\u0005!1\u0012\u0005\n\u0005\u001fk\"\u0019!C\u0001\u0005#C\u0001Ba'\u001eA\u0003%!1\u0013\u0002\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<fe*\u0011\u0011IQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\r2\u0003\u0006CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g\r\u0005\u0002N\u001d6\t\u0001)\u0003\u0002P\u0001\n11+\u001a:wKJ\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0013&a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u00055C\u0016BA-A\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u00039\u0016l\u0011!\u0018\u0006\u0003'zS!a\u00181\u0002\r\r|W.\\8o\u0015\t\u0019\u0015M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\rI'n\u001b\t\u0003\u001b\u0002AQAV\u0002A\u0002]CQAW\u0002A\u0002m\u000b1\u0001\u001f\u00132!\u00159e\u000e]:|\u0013\ty\u0007J\u0001\u0004UkBdWm\r\t\u0003\u001bFL!A\u001d!\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\nE>|Go\u001d;sCBT!\u0001\u001f1\u0002\u00115,G/\u00193bi\u0006L!A_;\u0003#\t{w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\r\u0005\u0003}\u007f\u0006\rQ\"A?\u000b\u0005yD\u0015AC2pY2,7\r^5p]&\u0019\u0011\u0011A?\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0006\u0005Ma\u0002BA\u0004\u0003\u001f\u00012!!\u0003I\u001b\t\tYAC\u0002\u0002\u000e\u0011\u000ba\u0001\u0010:p_Rt\u0014bAA\t\u0011\u00061\u0001K]3eK\u001aLA!!\u0006\u0002\u0018\t11\u000b\u001e:j]\u001eT1!!\u0005I\u0003%iW\r^1Qe>\u00048/F\u0001q\u0003)iW\r^1Qe>\u00048\u000fI\u0001\u0012E>|Go\u001d;sCBlU\r^1eCR\fW#A:\u0002%\t|w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\rI\u0001\f_\u001a4G.\u001b8f\t&\u00148/F\u0001|\u00031ygM\u001a7j]\u0016$\u0015N]:!\u0003\u001diW\r\u001e:jGN,\"!a\f\u0011\t\u0005E\u0012QG\u0007\u0003\u0003gQ1!a\u000b_\u0013\u0011\t9$a\r\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\nnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002@A)q)!\u0011\u0002F%\u0019\u00111\t%\u0003\r=\u0003H/[8o!\u0011\t9%a\u0014\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n1\"\\;mi&$XM\\1oi*\u0011\u0011\tY\u0005\u0005\u0003#\nIEA\nNk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0001\u000bnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018\rI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\tI\u0006\u0005\u0004\u0002\\\u0005%\u0014QN\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0014QM\u0001\u0005kRLGN\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\u0011\tY'!\u0018\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002p\u0005E\u0014QOAA\u001b\t\t\t'\u0003\u0003\u0002t\u0005\u0005$aA'baB!\u0011qOA?\u001b\t\tIH\u0003\u0003\u0002|\u0005\u0015\u0014\u0001\u00027b]\u001eLA!a \u0002z\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BAB\u0003\u001fsA!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u0003\u0017\u0001\u0002:bMRLA!!$\u0002\b\u0006Q!+\u00194u\u0007>tg-[4\n\t\u0005E\u00151\u0013\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002\u000e\u0006\u001d\u0015!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002\u0019MD\u0017M]3e'\u0016\u0014h/\u001a:\u0016\u0005\u0005m\u0005cA'\u0002\u001e&\u0019\u0011q\u0014!\u0003\u0019MC\u0017M]3e'\u0016\u0014h/\u001a:\u0002\u001bMD\u0017M]3e'\u0016\u0014h/\u001a:!\u0003\u0019\u0011'o\\6feV\u0011\u0011q\u0015\t\u0006\u000f\u0006\u0005\u0013\u0011\u0016\t\u0004\u001b\u0006-\u0016bAAW\u0001\na!I]8lKJ\u001cVM\u001d<fe\u00069!M]8lKJ\u0004\u0013!F2mkN$XM\u001d\"bY\u0006t7-Z'b]\u0006<WM]\u000b\u0003\u0003k\u0003RaRA!\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{\u0013\u0015AC2p]R\u0014x\u000e\u001c7fe&!\u0011\u0011YA^\u0005U\u0019E.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\fac\u00197vgR,'OQ1mC:\u001cW-T1oC\u001e,'\u000fI\u000b\u0003\u0003\u000f\u0004RaRA!\u0003\u0013\u00042!TAf\u0013\r\ti\r\u0011\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f1bY8oiJ|G\u000e\\3sA\u000591\u000f^1siV\u0004HCAAk!\r9\u0015q[\u0005\u0004\u00033D%\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJ\u0004\"!T\u000f\u0014\u0005u1ECAAq\u00035iU\r^1eCR\fGk\u001c9jGV\u0011\u00111\u001e\t\u0005\u0003o\ni/\u0003\u0003\u0002\u0016\u0005e\u0014AD'fi\u0006$\u0017\r^1U_BL7\rI\u0001\u0012\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tWCAA{!\u0011\t90!?\u000e\u0003yK1!a?_\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!#T3uC\u0012\fG/\u0019)beRLG/[8oA\u0005yQ*\u001a;bI\u0006$\u0018\rV8qS\u000eLE-\u0006\u0002\u0003\u0004A!\u0011q\u001fB\u0003\u0013\r\u00119A\u0018\u0002\u0005+VLG-\u0001\tNKR\fG-\u0019;b)>\u0004\u0018nY%eA\tY\u0001K]8dKN\u001c(k\u001c7f'\t)c)K\u0002&OI\u0012!B\u0011:pW\u0016\u0014(k\u001c7f'!9cI!\u0006\u0003\u001a\t}\u0001c\u0001B\fK5\tQ\u0004E\u0002H\u00057I1A!\bI\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\t\u0003,9!!1\u0005B\u0014\u001d\u0011\tIA!\n\n\u0003%K1A!\u000bI\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\f\u00030\ta1+\u001a:jC2L'0\u00192mK*\u0019!\u0011\u0006%\u0015\u0005\tM\u0002c\u0001B\fO\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0004\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0010\u0011\u0007\u001d\u0013\t%C\u0002\u0003D!\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0013\u0003PA\u0019qIa\u0013\n\u0007\t5\u0003JA\u0002B]fD\u0001\u0002\u001c\u0017\u0002\u0002\u0003\u0007!qH\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u000b\t\u0006y\n]#\u0011J\u0005\u0004\u00053j(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0018\u0003fA\u0019qI!\u0019\n\u0007\t\r\u0004JA\u0004C_>dW-\u00198\t\u00111t\u0013\u0011!a\u0001\u0005\u0013\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u007f\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u001c\u0011\t\u0005]$\u0011O\u0005\u0005\u0005g\nIH\u0001\u0004PE*,7\r\u001e\u0002\u000f\u0007>tGO]8mY\u0016\u0014(k\u001c7f'!\u0011dI!\u0006\u0003\u001a\t}AC\u0001B>!\r\u00119B\r\u000b\u0005\u0005\u0013\u0012y\b\u0003\u0005mo\u0005\u0005\t\u0019\u0001B )\u0011\u0011yFa!\t\u00111L\u0014\u0011!a\u0001\u0005\u0013\n!B\u0011:pW\u0016\u0014(k\u001c7f\u00039\u0019uN\u001c;s_2dWM\u001d*pY\u0016\f\u0011#\u001b8ji&\fG.\u001b>f\u0019><G)\u001b:t)\ri'Q\u0012\u0005\u0006-r\u0002\raV\u0001\rG>tg-[4TG\",W.Y\u000b\u0003\u0005'\u0003BA!&\u0003\u00186\tq/C\u0002\u0003\u001a^\u0014\u0011cS1gW\u0006\u001cuN\u001c4jON\u001b\u0007.Z7b\u00035\u0019wN\u001c4jON\u001b\u0007.Z7bA\u0001")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ClusterBalanceManager> clusterBalanceManager;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
        this.multiTenantMetadata().foreach((Function1 & Serializable)x$6 -> {
            x$6.close(this.config.brokerSessionUuid());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$8 -> {
            x$8.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        this.x$1 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.multiTenantMetadata = Option$.MODULE$.apply((Object)ConfluentConfigs.buildMultitenantMetadata(config.values(), (Metrics)this.metrics()));
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.sharedServer = new SharedServer(config, this.metaProps(), time, this.metrics(), this.controllerQuorumVotersFuture(), new StandardFaultHandlerFactory(), this.multiTenantMetadata(), KafkaRaftServer$.MODULE$.configSchema());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(this.sharedServer(), this.offlineDirs())) : None$.MODULE$;
        this.clusterBalanceManager = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)ClusterBalanceManager.clusterBalanceManager(config)) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata(), this.clusterBalanceManager())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

