/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\u0015*\u0001AB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Ia\b\u0001B\u0001B\u0003%q(\u0012\u0005\n\r\u0002\u0011\t\u0011)A\u0005\u000f*C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t?\u0002\u0011\t\u0011)A\u0005A\")q\r\u0001C\u0001Q\")\u0001\u000f\u0001C!c\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\b\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u0013\u0001\t\u0003\n\t\u0006C\u0004\u0002L\u0001!\t%!\u0016\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011q\u000b\u0001\u0005B\u0005u\u0003bBA,\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002~\u0001!\t%a \t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0011\u0001\u0005\u0002\u0005]\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\tI\f\u0001C!\u0003wCq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005-\b\u0001\"\u0011\u0002n\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\b\"\u0003B\u0004\u0001E\u0005I\u0011\u0001B\u0005\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003B\u0001!IAa\u0011\t\u000f\tu\u0004\u0001\"\u0011\u0003\u0000!9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002B^\u0001\u0011\u0005#Q\u0018\u0005\b\u0005\u001b\u0004A\u0011\tBh\u00115\u0011\t\u000e\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002Bj\u000b\nQ3\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe^KG\u000f[&SC\u001a$8+\u001e9q_J$(B\u0001\u0016,\u0003\u0011a\u0017N\\6\u000b\u00051j\u0013AB:feZ,'OC\u0001/\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0019\u0011\u0005I\u001aT\"A\u0015\n\u0005QJ#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA\u001c9\u001b\u0005Y\u0013BA\u001d,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u001a=\u0013\ti\u0014F\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t[\u0013\u0001C7fi\u0006$\u0017\r^1\n\u0005\u0011\u000b%AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016L!AP\u001a\u00021\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u00028\u0011&\u0011\u0011j\u000b\u0002!\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0003\u0002Gg\u0005\tBn\\2bY\u0006#W.\u001b8GC\u000e$xN]=\u0011\u00075\u0003&+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002T;6\tAK\u0003\u0002V-\u0006)\u0011\rZ7j]*\u0011q\u000bW\u0001\bG2LWM\u001c;t\u0015\tq\u0013L\u0003\u0002[7\u00061\u0011\r]1dQ\u0016T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010U\u0005\u0015\tE-\\5o\u0003)\u0019XM\u001d<fe&sgm\u001c\t\u0003C\u0016l\u0011A\u0019\u0006\u0003G\u0012\f!\"Y;uQ>\u0014\u0018N_3s\u0015\ta\u0003,\u0003\u0002gE\n!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\fa\u0001P5oSRtDcB5kW2lgn\u001c\t\u0003e\u0001AQ!N\u0004A\u0002YBQAO\u0004A\u0002mBQAP\u0004A\u0002}BQAR\u0004A\u0002\u001dCQaS\u0004A\u00021CQaX\u0004A\u0002\u0001\f1\"\\5se>\u0014Hk\u001c9jGR\u0011!O\u001f\t\u0004\u001bN,\u0018B\u0001;O\u0005\u0019y\u0005\u000f^5p]B\u0011a\u000f_\u0007\u0002o*\u0011!\tW\u0005\u0003s^\u00141\"T5se>\u0014Hk\u001c9jG\")1\u0010\u0003a\u0001y\u0006)Ao\u001c9jGB\u0019Q0!\u0003\u000f\u0007y\f)\u0001\u0005\u0002\u0000\u001d6\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0013A\u0002\u001fs_>$h(C\u0002\u0002\b9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004\u001d\u0006\tR.\u001b:s_J$v\u000e]5d'R\fG/Z:\u0015\t\u0005M\u0011Q\u0005\t\b\u0003+\tY\u0002`A\u0010\u001b\t\t9BC\u0002\u0002\u001a9\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0006\u0003\u00075\u000b\u0007\u000fE\u00023\u0003CI1!a\t*\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dq!a\n\n\u0001\u0004\tI#A\u0005u_BL7m](qiB!Qj]A\u0016!\u0011i\u0018Q\u0006?\n\t\u0005=\u0012Q\u0002\u0002\u0004'\u0016$H\u0003BA\n\u0003gAq!!\u000e\u000b\u0001\u0004\t9$\u0001\u0004mS:\\\u0017\n\u001a\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b-\u0002\r\r|W.\\8o\u0013\u0011\t\t%a\u000f\u0003\tU+\u0018\u000eZ\u0001#[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3\u0015\t\u0005M\u0011q\t\u0005\b\u0003\u0013Z\u0001\u0019AA\u0016\u0003\u0019!x\u000e]5dg\u0006\u0011S.\u001b:s_J$v\u000e]5d'R\fG/Z:Ge>lW*\u001a;bI\u0006$\u0018mQ1dQ\u0016$B!a\u0005\u0002P!9\u0011Q\u0007\u0007A\u0002\u0005]B\u0003BA\n\u0003'Bq!!\u0013\u000e\u0001\u0004\tY\u0003\u0006\u0002\u0002\u0014\u00051S.\u001b:s_J$v\u000e]5d'R\fG/Z:Ge>l7i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0015\t\u0005M\u00111\f\u0005\b\u0003ky\u0001\u0019AA\u001c)\u0011\t\u0019\"a\u0018\t\u000f\u0005%\u0003\u00031\u0001\u0002,\u0005)r-\u001a;BY2$v\u000e]5dg&s7\t\\;ti\u0016\u0014HCAA\u0016\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\tI'a\u001c\u0011\u00075\u000bY'C\u0002\u0002n9\u0013qAQ8pY\u0016\fg\u000eC\u0003|'\u0001\u0007A0A\ff]N,(/Z\"mkN$XM\u001d'j].,\u00050[:ugR!\u0011QOA>!\ri\u0015qO\u0005\u0004\u0003sr%\u0001B+oSRDq!!\u000e\u0015\u0001\u0004\t9$A\tdYV\u001cH/\u001a:MS:\\W\t_5tiN$B!!\u001b\u0002\u0002\"9\u0011QG\u000bA\u0002\u0005]\u0012AE4fi\u000ecWo\u001d;fe2Kgn\u001b#bi\u0006$B!a\"\u0002\u0016B!Qj]AE!\u0011\tY)!%\u000e\u0005\u00055%bAAH[\u0005\u0011!p[\u0005\u0005\u0003'\u000biIA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u001d\t)D\u0006a\u0001\u0003o!B!a\"\u0002\u001a\"1\u00111T\fA\u0002q\f\u0001\u0002\\5oW:\u000bW.Z\u0001\u001aO\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4Qe>\u00048\u000f\u0006\u0003\u0002\"\u0006E\u0006\u0003BAR\u0003[k!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\u0005kRLGN\u0003\u0002\u0002,\u0006!!.\u0019<b\u0013\u0011\ty+!*\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u00026a\u0001\r!a\u000e\u0002\u001d\u001d,G\u000fV8qS\u000e\u001cuN\u001c4jOR!\u0011\u0011UA\\\u0011\u0015Y\u0018\u00041\u0001}\u0003m\tG\u000e^3s\u00072,8\u000f^3s\u0019&t7nQ8oM&<'LT8eKRQ\u0011QOA_\u0003\u007f\u000b\t-!2\t\u000f\u0005U\"\u00041\u0001\u00028!1\u00111\u0014\u000eA\u0002qDq!a1\u001b\u0001\u0004\t\t+A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t\u0011\u001d\t9M\u0007a\u0001\u0003\u0013\f!\u0002\\5oW\u000e{gNZ5h!\r\u0011\u00141Z\u0005\u0004\u0003\u001bL#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u0001S.Y=cKJ+WM\\2ssB$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4t)\u0011\t)(a5\t\u000f\u0005U7\u00041\u0001\u0002X\u0006\t2m\u001c8gS\u001e$&/\u00198tM>\u0014X.\u001a:\u0011\u000f5\u000bI.!)\u0002^&\u0019\u00111\u001c(\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003B't\u0003C\u000bac\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0007\u0003k\n\u0019/a:\t\u000f\u0005\u0015H\u00041\u0001\u0002\n\u0006y1\r\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018\rC\u0004\u0002jr\u0001\r!!)\u0002\u000bA\u0014x\u000e]:\u0002'M,Go\u00117vgR,'\u000fT5oWjsu\u000eZ3\u0015\t\u0005U\u0014q\u001e\u0005\b\u0003Kl\u0002\u0019AAE\u0003U\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$\"\"!\u001e\u0002v\u0006]\u0018q B\u0002\u0011\u0015Yh\u00041\u0001}\u0011\u001d\tIP\ba\u0001\u0003w\fAb\u001d;bi\u0016,\u0006\u000fZ1uKJ\u0004r!TAm\u0003?\ti\u0010\u0005\u0003Ng\u0006}\u0001b\u0002B\u0001=\u0001\u0007\u0011\u0011N\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\n\u0005\u000bq\u0002\u0013!a\u0001\u0003S\nqBZ1jY&3gj\u001c;NSJ\u0014xN]\u0001 C2$XM]'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\"TC\u0001B\u0006U\u0011\tIG!\u0004,\u0005\t=\u0001\u0003\u0002B\t\u00057i!Aa\u0005\u000b\t\tU!qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0007O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0011\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0003Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003k\u0012\u0019\u0003C\u0004\u00026\u0001\u0002\r!a\u000e\u0002!\u0005dG/\u001a:NSJ\u0014xN\u001d+pa&\u001cGC\u0002B\u0015\u0005w\u0011i\u0004\u0005\u0004\u0002:\t-\"qF\u0005\u0005\u0005[\tYDA\u0006LC\u001a\\\u0017MR;ukJ,\u0007\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\t\tU\u0012\u0011V\u0001\u0005Y\u0006tw-\u0003\u0003\u0003:\tM\"\u0001\u0002,pS\u0012DQa_\u0011A\u0002qDqAa\u0010\"\u0001\u0004\ty\"\u0001\tnSJ\u0014xN\u001d+pa&\u001c7\u000b^1uK\u0006Y2/\u001a8e\u00032$XM]'jeJ|'\u000fV8qS\u000e\u0014V-];fgR$b!!\u001e\u0003F\t5\u0004b\u0002B\u0013E\u0001\u0007!q\t\t\u0005\u0005\u0013\u00129G\u0004\u0003\u0003L\t\u0005d\u0002\u0002B'\u0005;rAAa\u0014\u0003\\9!!\u0011\u000bB-\u001d\u0011\u0011\u0019Fa\u0016\u000f\u0007}\u0014)&C\u0001]\u0013\tQ6,\u0003\u0002/3&\u0019\u0011Q\b-\n\t\t}\u00131H\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011\u0019G!\u001a\u00029\u0005cG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC*!!qLA\u001e\u0013\u0011\u0011IGa\u001b\u0003!\u0005cG/\u001a:NSJ\u0014xN\u001d+pa&\u001c'\u0002\u0002B2\u0005KBqAa\u001c#\u0001\u0004\u0011\t(\u0001\u0004sKN,H\u000e\u001e\t\u0007\u0005g\u0012IHa\f\u000e\u0005\tU$\u0002\u0002B<\u0003w\t\u0011\"\u001b8uKJt\u0017\r\\:\n\t\tm$Q\u000f\u0002\u0010\u0017\u000647.\u0019$viV\u0014X-S7qY\u0006\u00112M]3bi\u0016\u001cE.^:uKJd\u0015N\\6t)\u0011\u0011\tI!'\u0011\r\t\r%\u0011\u0012BG\u001b\t\u0011)I\u0003\u0003\u0003\b\u0006\u0015\u0016AC2p]\u000e,(O]3oi&!!1\u0012BC\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0005\u001f\u0013)*\u0004\u0002\u0003\u0012*!!1SA\u001e\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002BL\u0005#\u0013!d\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+7\u000f]8og\u0016DqAa'$\u0001\u0004\u0011i*A\u000fde\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b!\u0011\u0011yJ!)\u000e\u0005\t\u0015\u0014\u0002\u0002BR\u0005K\u0012Qd\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u0018O\u0016$\u0018\t\u001c7MS:\\7O\u0012:p[6+G/\u00193bi\u0006$\"A!+\u0011\r\t-&QWAE\u001d\u0011\u0011iK!-\u000f\u0007}\u0014y+C\u0001P\u0013\r\u0011\u0019LT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119L!/\u0003\u0007M+\u0017OC\u0002\u00034:\u000bqb\u001d;pa6K'O]8s)>\u0004\u0018n\u0019\u000b\u0007\u0005S\u0011yL!1\t\u000bm,\u0003\u0019\u0001?\t\u000f\t\rW\u00051\u0001\u0003F\u0006iAn\\4F]\u0012|eMZ:fiN\u0004bAa+\u00036\n\u001d\u0007cA'\u0003J&\u0019!1\u001a(\u0003\t1{gnZ\u0001\u0019SNd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$WCAA5\u0003M\u0019X\u000f]3sI5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\u0011)\u000eE\u00028\u0005/L1A!7,\u00055iU\r^1eCR\f7)Y2iK\u0002")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        if (topicsOpt instanceof Some) {
            set = (Set)((Set)((Some)topicsOpt).value()).map((Function1 & Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic()))));
        } else if (None$.MODULE$.equals(topicsOpt)) {
            set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().values().map((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic())))).toSet();
        } else {
            throw new MatchError(topicsOpt);
        }
        return ((IterableOnceOps)((IterableOps)set.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        ImmutableMap mirrorTopics = ((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByLinkId(linkId);
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)mirrorTopics).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1 & Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2((Object)((TopicImage)entry._2()).name(), (Object)state);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Uuid linkId = (Uuid)x0$1._1();
                ClusterLink clusterLink = (ClusterLink)x0$1._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                if (newEncodedProps instanceof Some) {
                    Properties props = (Properties)((Some)newEncodedProps).value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(newEncodedProps)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)newEncodedProps);
            }
            throw new MatchError(null);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.destAdmin() == null) {
                this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.destAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (currentState.isEmpty() && failIfNotMirror) {
            throw new InvalidRequestException(new StringBuilder(28).append("Topic ").append(topic).append(" is not a mirror topic").toString());
        }
        currentState.foreach((Function1 & Serializable)state -> {
            ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$1(this, stateUpdater, validateOnly, topic, state);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        if (mirrorTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.logEndOffsets().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava());
        } else {
            if (mirrorTopicState instanceof ClusterLinkTopicState.PendingMirror) {
                throw new UnsupportedVersionException("Cannot convert to a PendingMirror");
            }
            if (mirrorTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
                throw new UnsupportedVersionException("Cannot convert to a PendingSynchronizeMirror");
            }
            throw new MatchError((Object)mirrorTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1 & Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$2(BoxesRunTime.unboxToLong((Object)x)))).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorTopicRequest"));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrorTopic request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
    }

    @Override
    public CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData createClusterLinksRequestData) {
        CompletableFuture<CreateClusterLinksResponse> result = new CompletableFuture<CreateClusterLinksResponse>();
        CreateClusterLinksRequest.Builder requestBuilder = new CreateClusterLinksRequest.Builder(createClusterLinksRequestData);
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, result){
            private final CompletableFuture result$2;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for createClusterLinksRequest"));
                }
                this.result$2.complete((CreateClusterLinksResponse)response);
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("createClusterLinksRequest failed with exception"), ex);
                }
                this.result$2.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$2() {
                return "Received response for createClusterLinksRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$3() {
                return "createClusterLinksRequest failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$4(Throwable ex$2) {
                return ex$2;
            }
            {
                this.result$2 = result$2;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder, requestHandler);
        return result;
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1 & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false))).toSeq();
    }

    @Override
    public KafkaFuture<Void> stopMirrorTopic(String topic, scala.collection.immutable.Seq<Object> logEndOffsets) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic).setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)logEndOffsets.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava());
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ void $anonfun$alterMirrorTopicState$1(ClusterLinkMetadataManagerWithKRaftSupport $this, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, ClusterLinkTopicState state) {
        ((Option)stateUpdater$1.apply((Object)state)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
            if (!validateOnly$1) {
                try {
                    return $this.alterMirrorTopic(topic$1, (ClusterLinkTopicState)newState).get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$2(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

