/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u0010 \u0005!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011m\u0003!\u0011!Q\u0001\n]C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tS\u0002\u0011\t\u0011)A\u0006U\")\u0001\u000f\u0001C\u0001c\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u0007\u0001\u0001\u0006Ia \u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"!\u000b\u0001A\u0003%\u00111\u0003\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003#A\u0001\"!\f\u0001A\u0003%\u00111\u0003\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003#A\u0001\"!\r\u0001A\u0003%\u00111\u0003\u0005\u000b\u0003g\u0001!\u0019!C\u0001C\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u0013\u0005}\u0002A1A\u0005\n\u0005\u0005\u0003\u0002CA(\u0001\u0001\u0006I!a\u0011\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA?\u0001\u0011%\u0011qP\u0004\n\u0003\u0017{\u0012\u0011!E\u0001\u0003\u001b3\u0001BH\u0010\u0002\u0002#\u0005\u0011q\u0012\u0005\u0007an!\t!!%\t\u0013\u0005M5$%A\u0005\u0002\u0005U%a\u0007+jKJlU\r^1eCR\f7K\\1qg\"|G/T1oC\u001e,'O\u0003\u0002!C\u0005A1O\\1qg\"|GO\u0003\u0002#G\u0005)A/Y:lg*\u0011A%J\u0001\u0005i&,'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gM\u0007\u0002c)\u0011!'J\u0001\u0006kRLGn]\u0005\u0003iE\u0012q\u0001T8hO&tw-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e*\u0013AB:feZ,'/\u0003\u0002<q\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!\u0005;jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iI\u0001\u0006i>\u0004\u0018nY\u0005\u0003\u0005~\u0012\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s\u0003=!\u0018.\u001a:PE*,7\r^*u_J,\u0007CA#I\u001b\u00051%BA$$\u0003\u0015\u0019Ho\u001c:f\u0013\tIeIA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003\r\u0019G\u000f\u001f\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u000e\nqAZ3uG\",'/\u0003\u0002Q\u001b\n\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006AQ.\u0019=UCN\\7\u000f\u0005\u0002+'&\u0011Ak\u000b\u0002\u0004\u0013:$\u0018AB2p]\u001aLw-F\u0001X!\tA\u0016,D\u0001\"\u0013\tQ\u0016EA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKB\u0011alZ\u0007\u0002?*\u0011!\u0007\u0019\u0006\u0003C\n\faaY8n[>t'B\u0001\u0014d\u0015\t!W-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0006\u0019qN]4\n\u0005!|&\u0001\u0002+j[\u0016\f!!Z2\u0011\u0005-tW\"\u00017\u000b\u00055\\\u0013AC2p]\u000e,(O]3oi&\u0011q\u000e\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003\u0003:wobL(p\u001f?\u0015\u0005M,\bC\u0001;\u0001\u001b\u0005y\u0002\"B5\u000b\u0001\bQ\u0007\"B\u001b\u000b\u0001\u00041\u0004\"\u0002\u001f\u000b\u0001\u0004i\u0004\"B\"\u000b\u0001\u0004!\u0005\"\u0002&\u000b\u0001\u0004Y\u0005\"B)\u000b\u0001\u0004\u0011\u0006\"B+\u000b\u0001\u00049\u0006b\u0002/\u000b!\u0003\u0005\r!X\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0002\u007fB!\u0011\u0011AA\u0005\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011aB7fiJL7m\u001d\u0006\u0003s\tLA!a\u0003\u0002\u0004\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003!\u0011\u0017\u0010^3SCR,WCAA\n!\u0011\t)\"!\n\u000e\u0005\u0005]!\u0002BA\r\u00037\tAaY8sK*!\u0011QAA\u000f\u0015\u0011\ty\"!\t\u0002\re\fW.\\3s\u0015\t\t\u0019#A\u0002d_6LA!a\n\u0002\u0018\t)Q*\u001a;fe\u0006I!-\u001f;f%\u0006$X\rI\u0001\ne\u0016$(/\u001f*bi\u0016\f!B]3uef\u0014\u0016\r^3!\u00039)\u0007pY3qi&|gn\u001d*bi\u0016\fq\"\u001a=dKB$\u0018n\u001c8t%\u0006$X\rI\u0001\ni\u0006\u001c8.U;fk\u0016,\"!a\u000e\u0011\u0007Q\fI$C\u0002\u0002<}\u0011\u0011$T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;UCN\\\u0017+^3vK\u0006QA/Y:l#V,W/\u001a\u0011\u0002\u0015]|'o[5oON+G/\u0006\u0002\u0002DA)\u0001,!\u0012\u0002J%\u0019\u0011qI\u0011\u0003%QKWM\u001d+bg.<vN]6j]\u001e\u001cV\r\u001e\t\u0004i\u0006-\u0013bAA'?\t!R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e+bg.\f1b^8sW&twmU3uA\u00051Am\\,pe.$\"!!\u0016\u0011\r\u0005]\u0013qMA7\u001d\u0011\tI&a\u0019\u000f\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018(\u0003\u0019a$o\\8u}%\tA&C\u0002\u0002f-\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$\u0001\u0002'jgRT1!!\u001a,!\u0015Y\u0017qNA%\u0013\r\t\t\b\u001c\u0002\u0007\rV$XO]3\u0002\u0011MDW\u000f\u001e3po:$\"!a\u001e\u0011\u0007)\nI(C\u0002\u0002|-\u0012A!\u00168ji\u0006i1o\u00195fIVd\u0017N\\4MC\u001e$B!!!\u0002\bB\u0019!&a!\n\u0007\u0005\u00155F\u0001\u0003M_:<\u0007bBAE3\u0001\u0007\u0011\u0011J\u0001\u0005i\u0006\u001c8.A\u000eUS\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'b]\u0006<WM\u001d\t\u0003in\u0019\"aG\u0015\u0015\u0005\u00055\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0002\u0018*\u001aQ,!',\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!*,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\u000byJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public final class TierMetadataSnapshotManager
implements Logging {
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final TierTasksConfig config;
    private final KafkaMetricsGroup metricsGroup;
    private final Meter byteRate;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private final MetadataSnapshotTaskQueue taskQueue;
    private final TierTaskWorkingSet<MetadataSnapshotTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Meter byteRate() {
        return this.byteRate;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    public MetadataSnapshotTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<MetadataSnapshotTask> workingSet() {
        return this.workingSet;
    }

    public List<Future<MetadataSnapshotTask>> doWork() {
        return this.workingSet().doWork(this.config(), (Option<Throttler>)None$.MODULE$);
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    private long schedulingLag(MetadataSnapshotTask task) {
        MetadataSnapshotTask.MetadataSnapshotTaskState metadataSnapshotTaskState = task.state();
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeLeaderSnapshotState) {
            return -1L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeMetadataSnapshotState) {
            return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLog(task.topicPartition()).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)TierMetadataSnapshotManager.$anonfun$schedulingLag$1(log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotState) {
            return -2L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.AfterMetadataSnapshotState) {
            return -3L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState) {
            return -4L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.FailedMetadataSnapshotState) {
            return -5L;
        }
        throw new MatchError((Object)metadataSnapshotTaskState);
    }

    public static final /* synthetic */ long $anonfun$schedulingLag$1(AbstractLog log) {
        return log.tierPartitionState().lastSnapshotTimestampMs();
    }

    public TierMetadataSnapshotManager(ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, TierTasksConfig config, Time time, ExecutionContext ec) {
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.config = config;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().removeMetric("BytesPerSec");
        this.byteRate = this.metricsGroup().newMeter("BytesPerSec", "bytes per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.taskQueue = new MetadataSnapshotTaskQueue(ctx.subContext(), maxTasks, time, (Function1<MetadataSnapshotTask, Object>)(Function1 & Serializable)task -> BoxesRunTime.boxToLong((long)this.schedulingLag(task)), new MetadataSnapshotMetrics((Option<Meter>)new Some((Object)this.byteRate()), (Option<Meter>)new Some((Object)this.retryRate()), (Option<Meter>)new Some((Object)this.exceptionsRate())), config.brokerId());
        this.workingSet = new TierTaskWorkingSet<MetadataSnapshotTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

