/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication;

import io.confluent.security.authentication.AuthenticationErrorInfo;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Claims;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.util.SecurityContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class AdmissionController {
    public static final String OAUTH_AUTHORIZED_PARTY = "azp";
    private final Authenticator<?, ?> authenticator;
    private final Supplier<TrustCache> trustCacheSupplier;
    private final PolicyEngine<String> policyEngine;

    public AdmissionController(Authenticator<?, ?> authenticator, Supplier<TrustCache> trustCacheSupplier, PolicyEngine<String> policyEngine) {
        this.authenticator = authenticator;
        this.trustCacheSupplier = trustCacheSupplier;
        this.policyEngine = policyEngine;
    }

    public Claims authenticate(BearerCredential credential, SecurityContext context) throws AuthenticationException {
        if (this.authenticator instanceof JwtAuthenticator) {
            JwtAuthenticator auth = (JwtAuthenticator)this.authenticator;
            return auth.authenticate(credential, context);
        }
        throw new AuthenticationException("Unable to process credential", "INCORRECT_AUTHENTICATOR_TYPE");
    }

    public Claims authenticate(BearerCredential credential) throws AuthenticationException {
        if (this.authenticator instanceof JwtAuthenticator) {
            return ((JwtAuthenticator)this.authenticator).authenticate(credential);
        }
        throw new AuthenticationException("Unable to process credential", "INCORRECT_AUTHENTICATOR_TYPE");
    }

    public Map<String, Object> assumePrincipal(Map<String, Object> claims, String poolId, String orgId) throws AuthenticationException, IllegalArgumentException {
        IdentityPool identityPool = this.trustCacheSupplier.get().identityPool(poolId);
        HashMap<String, Object> identityPoolClaims = new HashMap<String, Object>();
        if (identityPool == null) {
            throw this.getAuthExWithClaimsInfo(String.format("Unknown Identity Pool %s.", poolId), "IDENTITY_POOL_NOT_FOUND", claims);
        }
        if (!AdmissionController.validateIssuer(claims, identityPool.issuer())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided claim issuer %s do not match Identity Pool %s Pool Filter issuer %s.", AdmissionController.claimValue(claims, "iss", String.class), poolId, identityPool.issuer()), "CLAIM_ISSUER_POOL_FILTER_MISMATCH", claims);
        }
        if (!this.policyEngine.evaluatePolicy(identityPool.policy(), claims)) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided claims do not match Identity Pool %s Pool Filter.", poolId), "CLAIMS_POOL_FILTER_MISMATCH", claims);
        }
        if (!orgId.equals(identityPool.orgId())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided orgId %s do not match Identity Pool orgId %s Pool Filter.", orgId, identityPool.orgId()), "ORG_ID_POOL_FILTER_MISMATCH", claims);
        }
        if (!claims.containsKey(identityPool.subjectClaim())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided token does not contain claim %s in Identity Pool.", identityPool.subjectClaim()), "IDENTITY_POOL_IDENTITY_CLAIM_ABSENT_IN_CLAIMS", claims);
        }
        identityPoolClaims.put(OAUTH_AUTHORIZED_PARTY, claims.get(identityPool.subjectClaim()));
        claims.put(OAUTH_AUTHORIZED_PARTY, claims.get(identityPool.subjectClaim()));
        identityPoolClaims.put("sub", identityPool.serviceAccount());
        claims.put("sub", identityPool.serviceAccount());
        return identityPoolClaims;
    }

    private static boolean validateIssuer(Map<String, Object> claims, String issuer) {
        return issuer.equals(AdmissionController.claimValue(claims, "iss", String.class));
    }

    private static <T> T claimValue(Map<String, Object> claims, String claim, Class<T> valueType) {
        try {
            return valueType.cast(claims.get(claim));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to read claim - " + claim, t);
        }
    }

    private AuthenticationException getAuthExWithClaimsInfo(String msg, String code, Map<String, Object> claims) {
        AuthenticationException exe = new AuthenticationException(msg, code);
        AuthenticationErrorInfo.JwtClaimsInfo errInfo = new AuthenticationErrorInfo.JwtClaimsInfo();
        errInfo.claims(claims);
        exe.errorInfo(errInfo);
        return exe;
    }
}

