/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.credentials;

import io.confluent.auditlogapi.credentials.ExtractedCredentials;
import io.confluent.common.security.auth.JwtPrincipal;
import java.security.Principal;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialExtractor {
    private static final Logger log = LoggerFactory.getLogger(CredentialExtractor.class);
    private final String metadataServerUrl;

    public CredentialExtractor(String metadataServerUrl) {
        this.metadataServerUrl = Objects.requireNonNull(metadataServerUrl);
    }

    public ExtractedCredentials extractCredentials(HttpServletRequest request) {
        try {
            UserIdentity userIdentity;
            Principal principal;
            Authentication authn;
            if (request instanceof Request && (authn = ((Request)request).getAuthentication()) instanceof UserAuthentication && ((UserAuthentication)authn).getAuthMethod().equals("BEARER") && (principal = (userIdentity = ((UserAuthentication)authn).getUserIdentity()).getUserPrincipal()) instanceof JwtPrincipal) {
                return new ExtractedCredentials.JwtCredentials((JwtPrincipal)principal, this.metadataServerUrl, request.getRemoteHost());
            }
            return new ExtractedCredentials.NoCredentials(request.getRemoteHost());
        }
        catch (RuntimeException e) {
            log.debug("Exception while extracting credentials: " + e.getMessage(), (Throwable)e);
            return new ExtractedCredentials.NoCredentials(request.getRemoteHost());
        }
    }
}

