/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.collect.ImmutableSortedMap;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategoryTopics;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"other"}, alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(converter=Canonicalizer.class)
@JsonDeserialize(converter=Canonicalizer.class)
public class AuditLogConfigRouteCategories {
    final ImmutableSortedMap<String, AuditLogConfigRouteCategoryTopics> byCategoryName;

    @JsonCreator
    public AuditLogConfigRouteCategories(Map<String, AuditLogConfigRouteCategoryTopics> byCategoryName) {
        this.byCategoryName = ImmutableSortedMap.copyOf(byCategoryName);
    }

    @JsonValue
    public Map<String, AuditLogConfigRouteCategoryTopics> asMap() {
        return this.byCategoryName;
    }

    public AuditLogConfigRouteCategoryTopics get(String category) {
        return (AuditLogConfigRouteCategoryTopics)this.byCategoryName.get((Object)category);
    }

    public boolean has(String category) {
        return this.byCategoryName.containsKey((Object)category);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogConfigRouteCategories that = (AuditLogConfigRouteCategories)o;
        return this.byCategoryName.equals(that.byCategoryName);
    }

    public int hashCode() {
        return Objects.hash(this.byCategoryName);
    }

    public void forEach(BiConsumer<String, AuditLogConfigRouteCategoryTopics> visitor) {
        this.byCategoryName.forEach(visitor);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder((Map)this.byCategoryName);
    }

    public static class Canonicalizer
    extends StdConverter<AuditLogConfigRouteCategories, AuditLogConfigRouteCategories> {
        public AuditLogConfigRouteCategories convert(AuditLogConfigRouteCategories value) {
            if (value == null) {
                return null;
            }
            if (AuditLogRouterUtils.CATEGORIES.contains("management") && !AuditLogRouterUtils.CATEGORIES.contains("other")) {
                AuditLogConfigRouteCategoryTopics other = value.get("other");
                if (other == null) {
                    return value;
                }
                Builder builder = value.toBuilder().remove("other");
                AuditLogConfigRouteCategoryTopics mgmt = value.get("management");
                if (mgmt == null || mgmt.getAllowed() == null && mgmt.getDenied() == null) {
                    builder.put("management", other);
                }
                return builder.build();
            }
            return value;
        }
    }

    public static class Builder {
        private final Map<String, AuditLogConfigRouteCategoryTopics> map;

        private Builder() {
            this.map = new HashMap<String, AuditLogConfigRouteCategoryTopics>();
        }

        private Builder(Map<String, AuditLogConfigRouteCategoryTopics> map) {
            this.map = new HashMap<String, AuditLogConfigRouteCategoryTopics>(map);
        }

        public Builder put(String category, AuditLogConfigRouteCategoryTopics categoryTopics) {
            this.map.put(category, categoryTopics);
            return this;
        }

        public Builder remove(String category) {
            this.map.remove(category);
            return this;
        }

        public AuditLogConfigRouteCategories build() {
            return new AuditLogConfigRouteCategories(this.map);
        }
    }
}

