/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.confluent.auditlogapi.entities.AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinations;
import io.confluent.auditlogapi.entities.AuditLogConfigMetadata;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategories;
import io.confluent.auditlogapi.entities.AutoValue_AuditLogConfigSpec;
import io.confluent.auditlogapi.entities.Validations;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnPatternMatcher;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.rbacapi.jackson.MdsObjectMapperProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"destinations", "excluded_principals", "default_topics", "routes", "metadata"})
@JsonSerialize(as=AuditLogConfigSpec.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuditLogConfigSpec {
    private static final ObjectMapper JACKSON = MdsObjectMapperProvider.getObjectMapper();
    private static final BaseEncoding BASE64 = BaseEncoding.base64Url().omitPadding();
    private static final HashFunction MURMUR3_128 = Hashing.murmur3_128();
    private static final Logger log = LoggerFactory.getLogger(AuditLogConfigSpec.class);
    @JsonIgnore
    private volatile transient String calculatedChecksum = null;
    @JsonIgnore
    private volatile transient CrnPatternMatcher<AuditLogConfigRouteCategories> calculatedRoutesMatcher = null;

    @JsonProperty(value="destinations")
    public abstract AuditLogConfigDestinations getDestinations();

    @JsonProperty(value="excluded_principals")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableSortedSet<String> getExcludedPrincipals();

    @JsonProperty(value="default_topics")
    public abstract AuditLogConfigDefaultTopics getDefaultTopics();

    @JsonProperty(value="routes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableSortedMap<String, AuditLogConfigRouteCategories> getRoutes();

    @Nullable
    @JsonProperty(value="metadata")
    public abstract AuditLogConfigMetadata getMetadata();

    @Nonnull
    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public String toJson() throws JsonProcessingException {
        return JACKSON.writeValueAsString((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public String getCalculatedChecksum() {
        String result = this.calculatedChecksum;
        if (result == null) {
            AuditLogConfigSpec auditLogConfigSpec = this;
            synchronized (auditLogConfigSpec) {
                result = this.calculatedChecksum;
                if (result == null) {
                    this.calculatedChecksum = result = this.calculateChecksum(new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public CrnPatternMatcher<AuditLogConfigRouteCategories> getCalculatedRoutesMatcher() {
        CrnPatternMatcher<AuditLogConfigRouteCategories> result = this.calculatedRoutesMatcher;
        if (result == null) {
            AuditLogConfigSpec auditLogConfigSpec = this;
            synchronized (auditLogConfigSpec) {
                result = this.calculatedRoutesMatcher;
                if (result == null) {
                    this.calculatedRoutesMatcher = result = this.calculateRoutesMatcher();
                }
            }
        }
        return result;
    }

    public AuditLogConfigSpec withCalculatedMetadataResourceVersion() {
        if (this.getCalculatedChecksum().equals(this.getMetadata().getResourceVersion())) {
            return this;
        }
        return this.toBuilder().metadata(this.getMetadata().toBuilder().resourceVersion(this.getCalculatedChecksum()).build()).build();
    }

    private void validateExcludedPrincipals() {
        this.getExcludedPrincipals().forEach(principal -> Validations.requireValidUserPrincipal(principal, "excluded_principals"));
    }

    private void validateTopicDeclarations() {
        HashSet declaredTopicNames = new HashSet(this.getDestinations().getTopics().keySet());
        HashSet<String> usedTopicNames = new HashSet<String>();
        usedTopicNames.add(this.getDefaultTopics().getAllowed());
        usedTopicNames.add(this.getDefaultTopics().getDenied());
        for (AuditLogConfigRouteCategories routeCategories : this.getRoutes().values()) {
            routeCategories.forEach((category, topics) -> {
                usedTopicNames.add(topics.getAllowed());
                usedTopicNames.add(topics.getDenied());
            });
        }
        HashSet undeclaredTopicNames = new HashSet(usedTopicNames);
        undeclaredTopicNames.removeAll(declaredTopicNames);
        undeclaredTopicNames.remove(null);
        undeclaredTopicNames.remove("");
        if (!undeclaredTopicNames.isEmpty()) {
            throw new IllegalArgumentException("topics must be declared in destinations.topics: " + String.join((CharSequence)", ", undeclaredTopicNames));
        }
        HashSet unusedTopicNames = new HashSet(declaredTopicNames);
        unusedTopicNames.removeAll(usedTopicNames);
        if (!unusedTopicNames.isEmpty()) {
            throw new IllegalArgumentException("topics declared in destinations.topics must be used in routes or defaults: " + String.join((CharSequence)", ", unusedTopicNames));
        }
    }

    private void validateRouteCrnPatterns() {
        for (String routeCrnPattern : this.getRoutes().keySet()) {
            Validations.requireValidCrnPattern(routeCrnPattern, "routes");
        }
    }

    private CrnPatternMatcher<AuditLogConfigRouteCategories> calculateRoutesMatcher() {
        CrnPatternMatcher.Builder builder = CrnPatternMatcher.builder();
        for (Map.Entry entry : this.getRoutes().entrySet()) {
            try {
                ConfluentResourceName routeCrn = ConfluentResourceName.fromString((String)((String)entry.getKey()));
                builder.setPattern(routeCrn, entry.getValue());
            }
            catch (CrnSyntaxException e) {
                log.warn("cannot parse route CRN: " + (String)entry.getKey());
                return null;
            }
        }
        return builder.build();
    }

    public String calculateChecksum(Object ... supplementalData) {
        Hasher hasher = MURMUR3_128.newHasher();
        try (HasherOutputStream out = new HasherOutputStream(hasher);){
            JACKSON.writeValue((OutputStream)out, (Object)this.toBuilder().metadata(null).build());
            if (supplementalData != null) {
                for (Object datum : supplementalData) {
                    JACKSON.writeValue((OutputStream)out, datum);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return BASE64.encode(hasher.hash().asBytes());
    }

    private static class HasherOutputStream
    extends OutputStream {
        private final Hasher hasher;

        public HasherOutputStream(Hasher hasher) {
            this.hasher = hasher;
        }

        @Override
        public void write(int b) {
            this.hasher.putByte((byte)b);
        }

        @Override
        public void write(byte[] b) {
            this.hasher.putBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.hasher.putBytes(b, off, len);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuditLogConfigSpec.Builder();
        }

        @JsonProperty(value="destinations")
        public abstract Builder destinations(AuditLogConfigDestinations var1);

        @JsonProperty(value="excluded_principals")
        public abstract Builder excludedPrincipals(Collection<String> var1);

        abstract ImmutableSortedSet.Builder<String> excludedPrincipalsBuilder();

        public Builder excludedPrincipal(String excludedPrincipal) {
            this.excludedPrincipalsBuilder().add((Object)excludedPrincipal);
            return this;
        }

        @JsonProperty(value="default_topics")
        public abstract Builder defaultTopics(AuditLogConfigDefaultTopics var1);

        @JsonProperty(value="routes")
        public abstract Builder routes(Map<String, AuditLogConfigRouteCategories> var1);

        abstract ImmutableSortedMap.Builder<String, AuditLogConfigRouteCategories> routesBuilder();

        public Builder route(String crn, AuditLogConfigRouteCategories routeCategories) {
            this.routesBuilder().put((Object)crn, (Object)routeCategories);
            return this;
        }

        @JsonProperty(value="metadata")
        public abstract Builder metadata(AuditLogConfigMetadata var1);

        abstract Optional<AuditLogConfigMetadata> getMetadata();

        abstract AuditLogConfigSpec autoBuild();

        public AuditLogConfigSpec build() {
            if (!this.getMetadata().isPresent()) {
                this.metadata(AuditLogConfigMetadata.builder().resourceVersion("unknown").build());
            }
            AuditLogConfigSpec built = this.autoBuild();
            built.calculatedChecksum = null;
            built.calculatedRoutesMatcher = null;
            built.validateExcludedPrincipals();
            built.validateTopicDeclarations();
            built.validateRouteCrnPatterns();
            return built;
        }
    }
}

