/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.kafka;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.kafka.DestinationTopicManagerConfig;
import io.confluent.rbacapi.utils.ConfluentAdminClientFactory;
import io.confluent.security.audit.telemetry.exporter.TopicSpec;
import io.confluent.security.authorizer.utils.ThreadUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationTopicManager
implements AutoCloseable,
Reconfigurable {
    private static final int MAX_TOPIC_RETENTION_CACHE_SIZE = 1000000;
    private static final int MIN_AGE_BEFORE_TOPIC_METADATA_REFRESH_MS = 1000;
    private static final int MAX_AGE_FOR_CACHED_TOPIC_METADATA_MS = 10000;
    private static final int MAX_CLIENT_IDLE_MS = 60000;
    private static final Logger log = LoggerFactory.getLogger(DestinationTopicManager.class);
    private final Admin internalAdminClient;
    private final LoadingCache<String, OptionalLong> topicRetentionMillisCache;
    private final ThreadPoolExecutor readExecutor;
    private final ThreadPoolExecutor writeExecutor;
    private boolean shutDown = false;
    private boolean enabled = false;
    private ImmutableMap<String, Long> fileConfiguredTopicRetentionMillis = null;
    private ImmutableMap<String, Long> apiConfiguredTopicRetentionMillis = null;
    private DestinationTopicManagerConfig destinationConfig = null;
    private Admin adminClient = null;
    private AdminClientConfig adminClientConfig = null;
    private short replicationFactor = Short.parseShort("3");
    private int partitionCount = 12;

    public DestinationTopicManager(ConfluentAdmin internalAdminClient) {
        this.internalAdminClient = internalAdminClient;
        this.adminClient = internalAdminClient;
        this.readExecutor = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000), ThreadUtils.createThreadFactory((String)"audit-log-destination-topic-config-cache-%d", (boolean)true), new ThreadPoolExecutor.AbortPolicy());
        this.writeExecutor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), ThreadUtils.createThreadFactory((String)"audit-log-destination-topic-config-manager-%d", (boolean)true), new ThreadPoolExecutor.DiscardPolicy());
        this.writeExecutor.allowCoreThreadTimeOut(true);
        this.topicRetentionMillisCache = CacheBuilder.newBuilder().maximumSize(1000000L).refreshAfterWrite(1000L, TimeUnit.MILLISECONDS).expireAfterWrite(10000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, OptionalLong>(){

            public OptionalLong load(String topic) {
                return this.loadAll((Iterable<? extends String>)ImmutableList.of((Object)topic)).get(topic);
            }

            public ListenableFuture<OptionalLong> reload(String topic, OptionalLong oldValue) {
                Set<String> toLookup = Collections.singleton(topic);
                ListenableFutureTask task = ListenableFutureTask.create(() -> (OptionalLong)DestinationTopicManager.this.readTopicRetentionMillis(toLookup).get(topic));
                DestinationTopicManager.this.readExecutor.submit((Runnable)task);
                return task;
            }

            public Map<String, OptionalLong> loadAll(Iterable<? extends String> keys) {
                return DestinationTopicManager.this.readTopicRetentionMillis((Collection)ImmutableList.copyOf(keys));
            }
        });
    }

    public Map<String, Long> getTopicRetentionMillis(Collection<String> topicNames) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            this.topicRetentionMillisCache.getAll(topicNames).forEach((topicName, optionalRetention) -> {
                if (optionalRetention.isPresent()) {
                    result.put((String)topicName, optionalRetention.getAsLong());
                } else {
                    result.put((String)topicName, (Long)null);
                }
            });
            return result;
        }
        catch (ExecutionException e) {
            log.warn("Failure while getting topic retention times.");
            return ImmutableMap.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, OptionalLong> readTopicRetentionMillis(Collection<String> topicNames) {
        int requestTimeoutMillis;
        Admin adminClient;
        DestinationTopicManager destinationTopicManager = this;
        synchronized (destinationTopicManager) {
            if (this.shutDown || !this.enabled) {
                return Collections.emptyMap();
            }
            adminClient = this.adminClient;
            requestTimeoutMillis = DestinationTopicManagerConfig.requestTimeoutMillis((DestinationTopicManagerConfig)this.destinationConfig);
        }
        ConcurrentHashMap<String, OptionalLong> result = new ConcurrentHashMap<String, OptionalLong>();
        topicNames.forEach(n -> result.put((String)n, OptionalLong.empty()));
        List toDescribe = topicNames.stream().map(name -> new ConfigResource(ConfigResource.Type.TOPIC, name)).collect(Collectors.toList());
        DescribeConfigsResult describeResult = adminClient.describeConfigs(toDescribe);
        long due = System.currentTimeMillis() + (long)requestTimeoutMillis;
        for (Map.Entry entry : describeResult.values().entrySet()) {
            ConfigResource resource = (ConfigResource)entry.getKey();
            KafkaFuture futureConfig = (KafkaFuture)entry.getValue();
            long now = System.currentTimeMillis();
            if (now > due) {
                log.warn("Timed out looking up topic configurations");
                break;
            }
            try {
                Config config = (Config)futureConfig.get(due - now, TimeUnit.MILLISECONDS);
                result.put(resource.name(), DestinationTopicManager.retentionMillisOf(config));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while looking up topic retention times.");
                break;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                    result.put(resource.name(), OptionalLong.empty());
                    continue;
                }
                log.warn("Failure while looking up topic retention times.", (Throwable)e);
                break;
            }
            catch (TimeoutException e) {
                log.warn("Timed out while looking up topic retention times.", (Throwable)e);
                break;
            }
        }
        return result;
    }

    @Override
    public synchronized void close() {
        this.shutDown = true;
        this.setAdminClient(this.internalAdminClient);
        this.readExecutor.shutdown();
        this.writeExecutor.shutdown();
    }

    public CompletionStage<AuditLogConfigSpec> update(AuditLogConfigSpec spec) {
        CompletableFuture<AuditLogConfigSpec> future = new CompletableFuture<AuditLogConfigSpec>();
        this.configure(spec);
        CompletableFuture.runAsync(() -> this.updateDestinationTopics(future, spec), this.writeExecutor);
        return future;
    }

    private synchronized void configure(AuditLogConfigSpec spec) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        spec.getDestinations().getTopics().forEach((topicName, topicSpec) -> builder.put(topicName, (Object)topicSpec.getRetentionMs()));
        this.apiConfiguredTopicRetentionMillis = builder.build();
    }

    public synchronized void configure(Map<String, ?> map) {
        CompletableFuture future = new CompletableFuture();
        if (DestinationTopicManager.isAuditLogEnabledConfig(map)) {
            if (map.containsKey("confluent.security.event.logger.exporter.kafka.topic.replicas")) {
                this.replicationFactor = Short.parseShort((String)map.get("confluent.security.event.logger.exporter.kafka.topic.replicas"));
            }
            if (map.containsKey("confluent.security.event.logger.exporter.kafka.topic.partitions")) {
                this.partitionCount = Integer.parseInt((String)map.get("confluent.security.event.logger.exporter.kafka.topic.partitions"));
            }
            this.destinationConfig = DestinationTopicManagerConfig.build(map);
            AdminClientConfig cfg = this.destinationConfig.adminClientConfig();
            if (cfg != null) {
                if (this.isAdminClientConfigChanged(cfg)) {
                    this.setAdminClient((Admin)ConfluentAdminClientFactory.createAdmin(cfg));
                    this.adminClientConfig = cfg;
                }
            } else {
                this.setAdminClient(this.internalAdminClient);
            }
            this.fileConfiguredTopicRetentionMillis = this.destinationConfig.topicRetentionMillis();
            this.enabled = true;
            CompletableFuture.runAsync(() -> this.updateDestinationTopics(future, null), this.writeExecutor);
        } else {
            this.enabled = false;
            this.adminClient = this.internalAdminClient;
            this.fileConfiguredTopicRetentionMillis = null;
        }
    }

    public Set<String> reconfigurableConfigs() {
        return DestinationTopicManagerConfig.acceptedConfigNames();
    }

    public void validateReconfiguration(Map<String, ?> map) throws ConfigException {
        if (DestinationTopicManager.isAuditLogEnabledConfig(map)) {
            DestinationTopicManagerConfig config = DestinationTopicManagerConfig.build(map);
            config.adminClientConfig();
            config.buildTopicSpecFor("validation-test", 999999999L);
        }
    }

    public synchronized void reconfigure(Map<String, ?> map) {
        this.configure(map);
    }

    private synchronized void setAdminClient(Admin newClient) {
        if (this.adminClient != newClient) {
            if (this.adminClient != null && this.adminClient != this.internalAdminClient) {
                Utils.closeQuietly((AutoCloseable)this.adminClient, (String)"DestinationTopicManager.adminClient");
            }
            this.adminClient = newClient;
        }
    }

    private static boolean isAuditLogEnabledConfig(Map<String, ?> map) {
        Object value = map.get("confluent.security.event.logger.enable");
        if (value == null) {
            return "true".equals("true");
        }
        return "true".equals(value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDestinationTopics(CompletableFuture<AuditLogConfigSpec> future, AuditLogConfigSpec spec) {
        ImmutableMap<String, Long> topicRetentionMillis;
        Admin adminClient;
        DestinationTopicManagerConfig destinationConfig;
        DestinationTopicManager destinationTopicManager = this;
        synchronized (destinationTopicManager) {
            if (this.shutDown || !this.enabled || this.destinationConfig == null) {
                future.cancel(true);
                return;
            }
            destinationConfig = this.destinationConfig;
            adminClient = this.adminClient;
            topicRetentionMillis = this.apiConfiguredTopicRetentionMillis == null || this.apiConfiguredTopicRetentionMillis.isEmpty() ? this.fileConfiguredTopicRetentionMillis : this.apiConfiguredTopicRetentionMillis;
        }
        try {
            String topicName2;
            HashMap desired = new HashMap();
            if (topicRetentionMillis != null) {
                topicRetentionMillis.forEach((topicName, retentionMillis) -> desired.put(topicName, destinationConfig.buildTopicSpecFor(topicName, retentionMillis.longValue())));
            }
            if (desired.isEmpty()) {
                log.warn("No destination topics configured!");
            }
            int requestTimeoutMillis = DestinationTopicManagerConfig.requestTimeoutMillis((DestinationTopicManagerConfig)destinationConfig);
            List toDescribe = desired.keySet().stream().map(topicName -> new ConfigResource(ConfigResource.Type.TOPIC, topicName)).collect(Collectors.toList());
            DescribeConfigsResult describeResult = adminClient.describeConfigs(toDescribe);
            HashMap toCreate = new HashMap();
            HashMap toUpdate = new HashMap();
            long due = System.currentTimeMillis() + (long)requestTimeoutMillis;
            for (Map.Entry entry2 : describeResult.values().entrySet()) {
                String topicName3 = ((ConfigResource)entry2.getKey()).name();
                KafkaFuture futureConfig = (KafkaFuture)entry2.getValue();
                long now = System.currentTimeMillis();
                if (now > due) {
                    throw new TimeoutException("Timed out while looking up topic configurations.");
                }
                try {
                    Config config = (Config)futureConfig.get(due - now, TimeUnit.MILLISECONDS);
                    HashMap topicConfigToUpdate = new HashMap(((TopicSpec)desired.get(topicName3)).config());
                    for (ConfigEntry configEntry : config.entries()) {
                        if (configEntry.isReadOnly()) {
                            topicConfigToUpdate.remove(configEntry.name());
                            continue;
                        }
                        if (!Objects.equals(configEntry.value(), topicConfigToUpdate.get(configEntry.name()))) continue;
                        topicConfigToUpdate.remove(configEntry.name());
                    }
                    if (!topicConfigToUpdate.isEmpty()) {
                        toUpdate.put(topicName3, topicConfigToUpdate);
                    }
                    this.topicRetentionMillisCache.put((Object)topicName3, (Object)DestinationTopicManager.retentionMillisOf(config));
                }
                catch (ExecutionException e2) {
                    if (!(e2.getCause() instanceof UnknownTopicOrPartitionException)) {
                        log.error("Failure while checking on status of destination topics.", (Throwable)e2);
                        future.completeExceptionally(e2);
                        return;
                    }
                    toCreate.put(topicName3, desired.get(topicName3));
                    this.topicRetentionMillisCache.put((Object)topicName3, (Object)OptionalLong.empty());
                }
            }
            if (!toCreate.isEmpty()) {
                log.debug("{} event log topics need to be created: {}", (Object)toCreate.size(), toCreate.keySet());
                CreateTopicsResult createResult = adminClient.createTopics((Collection)toCreate.entrySet().stream().map(entry -> {
                    TopicSpec topicSpec = (TopicSpec)entry.getValue();
                    return new NewTopic((String)entry.getKey(), this.partitionCount, this.replicationFactor).configs(topicSpec.config());
                }).collect(Collectors.toList()), new CreateTopicsOptions().timeoutMs(Integer.valueOf(requestTimeoutMillis)));
                for (Map.Entry entry3 : createResult.values().entrySet()) {
                    try {
                        ((KafkaFuture)entry3.getValue()).get();
                        topicName2 = (String)entry3.getKey();
                        String topicRetentionMs = (String)((TopicSpec)toCreate.get(topicName2)).config().get("retention.ms");
                        if (topicRetentionMs == null) {
                            this.topicRetentionMillisCache.put((Object)topicName2, (Object)OptionalLong.empty());
                            continue;
                        }
                        this.topicRetentionMillisCache.put((Object)topicName2, (Object)OptionalLong.of(Long.parseLong(topicRetentionMs)));
                    }
                    catch (ExecutionException e3) {
                        if (!(e3.getCause() instanceof TopicExistsException)) {
                            log.error("Unexpected exception creating destination topic {}", entry3.getKey(), (Object)e3);
                            future.completeExceptionally(e3);
                            return;
                        }
                        CompletableFuture.runAsync(() -> this.updateDestinationTopics(future, spec), this.writeExecutor);
                    }
                }
            }
            if (!toUpdate.isEmpty()) {
                AlterConfigsResult alterResult = adminClient.incrementalAlterConfigs(toUpdate.entrySet().stream().collect(Collectors.toMap(e -> new ConfigResource(ConfigResource.Type.TOPIC, (String)e.getKey()), e -> ((Map)e.getValue()).entrySet().stream().map(entry -> new AlterConfigOp(new ConfigEntry((String)entry.getKey(), (String)entry.getValue()), AlterConfigOp.OpType.SET)).collect(Collectors.toList()))), new AlterConfigsOptions().timeoutMs(Integer.valueOf(requestTimeoutMillis)));
                for (Map.Entry entry3 : alterResult.values().entrySet()) {
                    topicName2 = ((ConfigResource)entry3.getKey()).name();
                    try {
                        ((KafkaFuture)entry3.getValue()).get();
                        String topicRetentionMs = (String)((Map)toUpdate.get(topicName2)).get("retention.ms");
                        if (topicRetentionMillis != null) {
                            this.topicRetentionMillisCache.put((Object)topicName2, (Object)OptionalLong.of(Long.parseLong(topicRetentionMs)));
                            continue;
                        }
                        this.topicRetentionMillisCache.put((Object)topicName2, (Object)OptionalLong.empty());
                    }
                    catch (ExecutionException e4) {
                        log.error("Unexpected exception updating destination topic {}", (Object)topicName2, (Object)e4);
                        future.completeExceptionally(e4);
                        return;
                    }
                }
            }
        }
        catch (InterruptedException e5) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while updating destination topics.");
            future.completeExceptionally(e5);
            return;
        }
        catch (TimeoutException e6) {
            log.warn("Timed out while updating destination topics.", (Throwable)e6);
            CompletableFuture.runAsync(() -> this.updateDestinationTopics(future, spec), this.writeExecutor);
        }
        catch (RuntimeException e7) {
            log.error("Unexpected error while updating destination topics.", (Object)e7.getMessage());
            future.completeExceptionally(e7);
            return;
        }
        future.complete(spec);
    }

    private boolean isAdminClientConfigChanged(AdminClientConfig that) {
        if (this.adminClientConfig == null) {
            return true;
        }
        return !this.adminClientConfig.originals().equals(that.originals());
    }

    @Nonnull
    private static OptionalLong retentionMillisOf(Config config) {
        ConfigEntry entry = config.get("retention.ms");
        if (entry == null || entry.value() == null || entry.value().isEmpty()) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Math.max(-1L, Long.parseLong(entry.value())));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }
}

