/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metadataapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Scope;
import java.util.Map;

public class ClusterId {
    private final String clusterId;
    private final Scope scope;

    @JsonCreator
    public ClusterId(@JsonProperty(value="id") String clusterId, @JsonProperty(value="scope") Scope scope) {
        if (clusterId.isEmpty()) {
            throw new IllegalArgumentException("Invalid scope for cluster-id: " + scope);
        }
        Map clusters = scope.clusters();
        if (clusters.size() != 1 || !clusters.containsKey("kafka-cluster")) {
            throw new IllegalArgumentException("Invalid scope for cluster-id: " + scope);
        }
        if (!clusterId.equals(clusters.get("kafka-cluster"))) {
            throw new IllegalArgumentException("Invalid cluster-id specified in scope");
        }
        this.clusterId = clusterId;
        this.scope = scope;
    }

    public ClusterId(String clusterId) {
        this(clusterId, Scope.kafkaClusterScope((String)clusterId));
    }

    @JsonProperty(value="id")
    public String id() {
        return this.clusterId;
    }

    @JsonProperty(value="scope")
    public Scope scope() {
        return this.scope;
    }
}

