/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.converters.V1MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.services.RoleBindingProcessing;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class OperationsResource {
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final RoleBindingProcessing roleBindingProcessing;
    private final ClusterRegistryService clusterRegistryService;
    private final MdsScopeConverter mdsScopeConverter;
    private final ValidationUtil validationUtil;

    public OperationsResource(RoleBindingProcessing roleBindingProcessing, SecurityMetadataAuthorizer metadataAuthorizer, ClusterRegistryService clusterRegistryService, ValidationUtil validationUtil) {
        this.roleBindingProcessing = roleBindingProcessing;
        this.metadataAuthorizer = metadataAuthorizer;
        this.clusterRegistryService = clusterRegistryService;
        this.validationUtil = validationUtil;
        this.mdsScopeConverter = new V1MdsScopeConverter(this.clusterRegistryService, this.validationUtil);
    }

    public RoleBindingProcessing.OperationGuidelines lookupPrincipalsWithRoleOnResource(SecurityContext context, String resourceType, String principal, String operation, MdsScope mdsScope) {
        KafkaPrincipal targetPrincipal = this.getTargetPrincipal(context, principal);
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, scope, targetPrincipal, SecurityMetadataAuthorizer.DESCRIBE);
        if (resourceType.equalsIgnoreCase(ResourceType.ALL.name())) {
            throw new RuntimeException("Invalid resource type: " + resourceType);
        }
        ResourceType rt = new ResourceType(resourceType);
        return this.roleBindingProcessing.guidelines(targetPrincipal, rt, scope, new Operation(operation));
    }

    private KafkaPrincipal getTargetPrincipal(SecurityContext context, String principalStr) {
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        if (this.metadataAuthorizer.isCallingPrincipalSameAsTargetPrincipal(context.getUserPrincipal(), principal)) {
            return this.metadataAuthorizer.userPrincipal(context);
        }
        return principal;
    }
}

