/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.resources.base.AclResource;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.auth.client.rest.entities.AclFilter;
import io.confluent.security.auth.client.rest.entities.CreateAclRequest;
import io.confluent.security.auth.client.rest.entities.CreateAclsRequest;
import io.confluent.security.auth.client.rest.entities.CreateAclsResult;
import io.confluent.security.auth.client.rest.entities.DeleteAclsRequest;
import io.confluent.security.auth.client.rest.entities.DeleteAclsResult;
import io.confluent.security.auth.metadata.AuthStore;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.acl.AclBinding;

@Path(value="/1.0")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class V1AclResource {
    private final AclResource delegate;

    public V1AclResource(AuthStore authStore, SecurityMetadataAuthorizer metadataAuthorizer, long backendTimeoutNanos) {
        this.delegate = new AclResource(authStore, metadataAuthorizer, backendTimeoutNanos);
    }

    @POST
    @Path(value="/acls")
    @PerformanceMetric(value="v1.create.acl")
    public void createAcl(@Context SecurityContext context, CreateAclRequest createAclRequest) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.createAcl(context, createAclRequest);
    }

    @POST
    @Path(value="/acls/create")
    @PerformanceMetric(value="v1.create.acls")
    public CreateAclsResult createAcls(@Context SecurityContext context, CreateAclsRequest createAclRequest) {
        return this.delegate.createAcls(context, createAclRequest);
    }

    @DELETE
    @Path(value="/acls")
    @PerformanceMetric(value="v1.delete.acl")
    public Collection<AclBinding> deleteAcls(@Context SecurityContext context, AclFilter deleteAclRequest) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.deleteAcls(context, deleteAclRequest);
    }

    @DELETE
    @Path(value="/acls/delete")
    @PerformanceMetric(value="v1.delete.acls")
    public DeleteAclsResult deleteAcls(@Context SecurityContext context, DeleteAclsRequest deleteAclRequest) {
        return this.delegate.deleteAcls(context, deleteAclRequest);
    }

    @POST
    @Path(value="/acls:search")
    @PerformanceMetric(value="v1.describe.acls")
    public Collection<AclBinding> describeAcls(@Context SecurityContext context, AclFilter describeAclRequest) {
        return this.delegate.describeAcls(context, describeAclRequest);
    }
}

