/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import io.confluent.rbacapi.rest.LeaderAwareApplication;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsWritesFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MdsWritesFilter.class);
    private final Pattern pathsToForward = Pattern.compile("^/((\\d+\\.\\d+|v2alpha1)/(principals|acls|registry|oidc/authorization-code/callback|oidc/logout)).*");
    private LeaderAwareApplication application;

    public MdsWritesFilter(LeaderAwareApplication application) {
        this.application = application;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.shouldForward(httpRequest.getPathInfo())) {
            request.getRequestDispatcher("/leader" + httpRequest.getRequestURI()).forward(request, response);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean shouldForward(String path) {
        return path != null && this.pathsToForward.matcher(path).matches() && !this.application.isLeader();
    }
}

