/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import io.confluent.rbacapi.entities.ClusterAccessInfo;
import io.confluent.rbacapi.entities.ClusterAccessInfoBuilder;
import io.confluent.rbacapi.entities.ResourceTypes;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.utils.RoleAccessUtils;
import io.confluent.rbacapi.utils.V1RoleAdminCheatUtil;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ClusterAccessProcessor {
    private final AuthCache authCache;
    private final Set<String> managementRoleNames;
    private final Set<String> clusterRoleNames;
    private final Map<String, Set<String>> clusterRoleAccessDefinitions;
    private final Map<String, Set<String>> resourceRoleAccessDefinitions;

    public ClusterAccessProcessor(AuthCache authCache) {
        this.authCache = authCache;
        this.managementRoleNames = authCache.rbacRoles().roles().stream().filter(RoleAccessUtils.filterByDescribeOrAlterAccess()).map(Role::name).collect(Collectors.toSet());
        this.clusterRoleNames = authCache.rbacRoles().roles().stream().filter(role -> !role.bindWithResource()).map(Role::name).collect(Collectors.toSet());
        this.clusterRoleAccessDefinitions = V1RoleAdminCheatUtil.CLUSTER_ROLE_ACCESS;
        this.resourceRoleAccessDefinitions = V1RoleAdminCheatUtil.RESOURCE_ROLE_ACCESS;
    }

    public ClusterAccessInfo process(KafkaPrincipal principal, Scope scope) {
        ClusterType clusterType = ClusterType.of((Scope)scope);
        Set resourceTypesForThisScope = ResourceTypes.getResourceTypes((ClusterType)clusterType);
        ClusterAccessInfoBuilder cliBuilder = new ClusterAccessInfoBuilder(resourceTypesForThisScope);
        Set roleBindings = this.authCache.rbacRoleBindings(principal, Collections.singleton(scope));
        if (roleBindings.isEmpty()) {
            return cliBuilder.build();
        }
        roleBindings.stream().filter(roleBinding -> this.managementRoleNames.contains(roleBinding.role())).forEach(roleBinding -> {
            String roleName = roleBinding.role();
            if (this.clusterRoleNames.contains(roleName)) {
                cliBuilder.addClusterAccess(this.clusterRoleAccessDefinitions.getOrDefault(roleName, Collections.emptySet()));
            } else {
                roleBinding.resources().stream().map(resourcePattern -> resourcePattern.resourceType().toString()).filter(resourceTypesForThisScope::contains).forEach(resourceType -> cliBuilder.addResourceAccess(resourceType, this.resourceRoleAccessDefinitions.getOrDefault(roleName + "-" + resourceType, Collections.emptySet())));
            }
        });
        return cliBuilder.build();
    }
}

