/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.exceptions.IncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryInitializationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaTooLargeException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaVersionNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.SubjectNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.id.IncrementalIdGenerator;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.KafkaGroupLeaderElector;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rest.handlers.CompositeUpdateRequestHandler;
import io.confluent.kafka.schemaregistry.rest.handlers.UpdateRequestHandler;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectKey;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectValue;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.CompositeSchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.ContextKey;
import io.confluent.kafka.schemaregistry.storage.ContextValue;
import io.confluent.kafka.schemaregistry.storage.DelegatingIterator;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.FilteredIterator;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.LazyParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.storage.LeaderAwareSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LeaderElector;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.ModeKey;
import io.confluent.kafka.schemaregistry.storage.ModeValue;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.TransformedIterator;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import io.confluent.kafka.schemaregistry.storage.exceptions.EntryTooLargeException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreTimeoutException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.NamedURI;
import io.confluent.rest.exceptions.RestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import org.apache.avro.reflect.Nullable;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSchemaRegistry
implements SchemaRegistry,
LeaderAwareSchemaRegistry {
    public static final int MIN_VERSION = 1;
    public static final int MAX_VERSION = Integer.MAX_VALUE;
    public static final String CONFLUENT_VERSION = "confluent:version";
    private static final Logger log = LoggerFactory.getLogger(KafkaSchemaRegistry.class);
    private static final String RESERVED_FIELD_REMOVED = "The new schema has reserved field %s removed from its metadata which is present in the old schema's metadata.";
    private static final String FIELD_CONFLICTS_WITH_RESERVED_FIELD = "The new schema has field that conflicts with the reserved field %s.";
    private final SchemaRegistryConfig config;
    private final List<SchemaRegistryResourceExtension> resourceExtensions;
    private final Map<String, Object> props;
    private final LoadingCache<RawSchema, ParsedSchema> newSchemaCache;
    private final LoadingCache<RawSchema, ParsedSchema> oldSchemaCache;
    private final LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache;
    final KafkaStore<SchemaRegistryKey, SchemaRegistryValue> kafkaStore;
    private final MetadataEncoderService metadataEncoder;
    private RuleSetHandler ruleSetHandler;
    private final List<UpdateRequestHandler> updateRequestHandlers = new CopyOnWriteArrayList<UpdateRequestHandler>();
    private final Serializer<SchemaRegistryKey, SchemaRegistryValue> serializer;
    private final SchemaRegistryIdentity myIdentity;
    private final CompatibilityLevel defaultCompatibilityLevel;
    private final boolean defaultValidateFields;
    private final Mode defaultMode;
    private final int kafkaStoreTimeoutMs;
    private final int initTimeout;
    private final int kafkaStoreMaxRetries;
    private final int searchDefaultLimit;
    private final int searchMaxLimit;
    private final boolean delayLeaderElection;
    private final boolean allowModeChanges;
    private SchemaRegistryIdentity leaderIdentity;
    private RestService leaderRestService;
    private final SslFactory sslFactory;
    private final int leaderConnectTimeoutMs;
    private final int leaderReadTimeoutMs;
    private final IdGenerator idGenerator;
    private LeaderElector leaderElector = null;
    private final MetricsContainer metricsContainer;
    private final Map<String, SchemaProvider> providers;
    private final String kafkaClusterId;
    private final String groupId;
    private final List<Consumer<Boolean>> leaderChangeListeners = new CopyOnWriteArrayList<Consumer<Boolean>>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Time time;

    public KafkaSchemaRegistry(SchemaRegistryConfig config, Serializer<SchemaRegistryKey, SchemaRegistryValue> serializer) throws SchemaRegistryException {
        if (config == null) {
            throw new SchemaRegistryException("Schema registry configuration is null");
        }
        this.config = config;
        this.resourceExtensions = config.getConfiguredInstances(config.definedResourceExtensionConfigName(), SchemaRegistryResourceExtension.class);
        this.props = new ConcurrentHashMap<String, Object>();
        Boolean leaderEligibility = config.getBoolean("master.eligibility");
        if (leaderEligibility == null) {
            leaderEligibility = config.getBoolean("leader.eligibility");
        }
        this.delayLeaderElection = config.getBoolean("leader.election.delay");
        this.allowModeChanges = config.getBoolean("mode.mutability");
        String interInstanceListenerNameConfig = config.interInstanceListenerName();
        NamedURI internalListener = KafkaSchemaRegistry.getInterInstanceListener(config.getListeners(), interInstanceListenerNameConfig, config.interInstanceProtocol());
        log.info("Found internal listener: {}", (Object)internalListener);
        boolean isEligibleForLeaderElector = leaderEligibility;
        this.myIdentity = KafkaSchemaRegistry.getMyIdentity(internalListener, isEligibleForLeaderElector, config);
        log.info("Setting my identity to {}", (Object)this.myIdentity);
        Map<String, Object> sslConfig = config.getOverriddenSslConfigs(internalListener);
        this.sslFactory = new SslFactory(ConfigDef.convertToStringMapWithPasswordValues(sslConfig));
        this.leaderConnectTimeoutMs = config.getInt("leader.connect.timeout.ms");
        this.leaderReadTimeoutMs = config.getInt("leader.read.timeout.ms");
        this.kafkaStoreTimeoutMs = config.getInt("kafkastore.timeout.ms");
        this.initTimeout = config.getInt("kafkastore.init.timeout.ms");
        this.kafkaStoreMaxRetries = config.getInt("kafkastore.write.max.retries");
        this.serializer = serializer;
        this.defaultCompatibilityLevel = config.compatibilityType();
        this.defaultValidateFields = config.getBoolean("schema.validate.fields");
        this.defaultMode = Mode.READWRITE;
        this.kafkaClusterId = this.kafkaClusterId(config);
        this.groupId = config.getString("schema.registry.group.id");
        this.metricsContainer = new MetricsContainer(config, this.kafkaClusterId);
        this.providers = this.initProviders(config);
        this.newSchemaCache = Caffeine.newBuilder().maximumSize((long)(config.getInt("schema.cache.size") / 2)).expireAfterAccess((long)config.getInt("schema.cache.expiry.secs").intValue(), TimeUnit.SECONDS).build(s -> this.loadSchema(s.getSchema(), s.isNew(), s.isNormalize()));
        this.oldSchemaCache = Caffeine.newBuilder().maximumSize((long)(config.getInt("schema.cache.size") / 2)).expireAfterAccess((long)config.getInt("schema.cache.expiry.secs").intValue(), TimeUnit.SECONDS).build(s -> this.loadSchema(s.getSchema(), s.isNew(), s.isNormalize()));
        this.searchDefaultLimit = config.getInt("schema.search.default.limit");
        this.searchMaxLimit = config.getInt("schema.search.max.limit");
        this.lookupCache = this.lookupCache();
        this.idGenerator = this.identityGenerator(config);
        this.kafkaStore = this.kafkaStore(config);
        this.metadataEncoder = new MetadataEncoderService(this);
        this.ruleSetHandler = new RuleSetHandler();
        this.time = config.getTime();
    }

    @VisibleForTesting
    static SchemaRegistryIdentity getMyIdentity(NamedURI internalListener, boolean isEligibleForLeaderElector, SchemaRegistryConfig config) {
        SchemeAndPort schemeAndPort = new SchemeAndPort(internalListener.getUri().getScheme(), config.originals().containsKey("host.port") ? config.getInt("host.port").intValue() : internalListener.getUri().getPort());
        String host = config.getString("host.name");
        return new SchemaRegistryIdentity(host, schemeAndPort.port, isEligibleForLeaderElector, schemeAndPort.scheme);
    }

    private Map<String, SchemaProvider> initProviders(SchemaRegistryConfig config) {
        Map schemaProviderConfigs = config.originalsWithPrefix("schema.providers.");
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        List<SchemaProvider> defaultSchemaProviders = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
        for (SchemaProvider provider : defaultSchemaProviders) {
            provider.configure(schemaProviderConfigs);
        }
        HashMap<String, SchemaProvider> providerMap = new HashMap<String, SchemaProvider>();
        this.registerProviders(providerMap, defaultSchemaProviders);
        List customSchemaProviders = config.getConfiguredInstances("schema.providers", SchemaProvider.class, schemaProviderConfigs);
        this.registerProviders(providerMap, customSchemaProviders);
        this.metricsContainer.getCustomSchemaProviderCount().record(customSchemaProviders.size());
        return providerMap;
    }

    private void registerProviders(Map<String, SchemaProvider> providerMap, List<SchemaProvider> schemaProviders) {
        for (SchemaProvider schemaProvider : schemaProviders) {
            log.info("Registering schema provider for {}: {}", (Object)schemaProvider.schemaType(), (Object)schemaProvider.getClass().getName());
            providerMap.put(schemaProvider.schemaType(), schemaProvider);
        }
    }

    protected KafkaStore<SchemaRegistryKey, SchemaRegistryValue> kafkaStore(SchemaRegistryConfig config) throws SchemaRegistryException {
        return new KafkaStore<SchemaRegistryKey, SchemaRegistryValue>(config, this.getSchemaUpdateHandler(config), this.serializer, this.lookupCache, new NoopKey());
    }

    protected SchemaUpdateHandler getSchemaUpdateHandler(SchemaRegistryConfig config) {
        Map handlerConfigs = config.originalsWithPrefix("kafkastore.update.handlers.");
        handlerConfigs.put("schemaRegistry", this);
        List customSchemaHandlers = config.getConfiguredInstances("kafkastore.update.handlers", SchemaUpdateHandler.class, handlerConfigs);
        KafkaStoreMessageHandler storeHandler = new KafkaStoreMessageHandler(this, this.getLookupCache(), this.getIdentityGenerator());
        for (SchemaUpdateHandler customSchemaHandler : customSchemaHandlers) {
            log.info("Registering custom schema handler: {}", (Object)customSchemaHandler.getClass().getName());
        }
        customSchemaHandlers.add(storeHandler);
        return new CompositeSchemaUpdateHandler(customSchemaHandlers);
    }

    public List<SchemaRegistryResourceExtension> getResourceExtensions() {
        return this.resourceExtensions;
    }

    protected LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache() {
        return new InMemoryCache<SchemaRegistryKey, SchemaRegistryValue>(this.serializer);
    }

    public LookupCache<SchemaRegistryKey, SchemaRegistryValue> getLookupCache() {
        return this.lookupCache;
    }

    public Serializer<SchemaRegistryKey, SchemaRegistryValue> getSerializer() {
        return this.serializer;
    }

    public MetadataEncoderService getMetadataEncoder() {
        return this.metadataEncoder;
    }

    public RuleSetHandler getRuleSetHandler() {
        return this.ruleSetHandler;
    }

    public void setRuleSetHandler(RuleSetHandler ruleSetHandler) {
        this.ruleSetHandler = ruleSetHandler;
    }

    public UpdateRequestHandler getCompositeUpdateRequestHandler() {
        ArrayList<UpdateRequestHandler> handlers = new ArrayList<UpdateRequestHandler>();
        handlers.add(this.ruleSetHandler);
        handlers.addAll(this.updateRequestHandlers);
        return new CompositeUpdateRequestHandler(handlers);
    }

    public void addUpdateRequestHandler(UpdateRequestHandler updateRequestHandler) {
        this.updateRequestHandlers.add(updateRequestHandler);
    }

    protected IdGenerator identityGenerator(SchemaRegistryConfig config) {
        config.checkBootstrapServers();
        IncrementalIdGenerator idGenerator = new IncrementalIdGenerator(this);
        idGenerator.configure(config);
        return idGenerator;
    }

    public IdGenerator getIdentityGenerator() {
        return this.idGenerator;
    }

    public MetricsContainer getMetricsContainer() {
        return this.metricsContainer;
    }

    public static NamedURI getInterInstanceListener(List<NamedURI> listeners, String interInstanceListenerName, String requestedScheme) throws SchemaRegistryException {
        if (requestedScheme.isEmpty()) {
            requestedScheme = "http";
        }
        NamedURI internalListener = null;
        for (NamedURI listener : listeners) {
            if (listener.getName() != null && listener.getName().equalsIgnoreCase(interInstanceListenerName)) {
                internalListener = listener;
                break;
            }
            if (!listener.getUri().getScheme().equalsIgnoreCase(requestedScheme)) continue;
            internalListener = listener;
        }
        if (internalListener == null) {
            throw new SchemaRegistryException(" No listener configured with requested scheme " + requestedScheme);
        }
        return internalListener;
    }

    @Override
    public void init() throws SchemaRegistryException {
        try {
            this.kafkaStore.init();
        }
        catch (StoreInitializationException e) {
            throw new SchemaRegistryInitializationException("Error initializing kafka store while initializing schema registry", e);
        }
        try {
            this.metadataEncoder.init();
        }
        catch (Exception e) {
            throw new SchemaRegistryInitializationException("Error initializing metadata encoder while initializing schema registry", e);
        }
        this.config.checkBootstrapServers();
        if (!this.delayLeaderElection) {
            this.electLeader();
        }
    }

    public void postInit() throws SchemaRegistryException {
        if (this.delayLeaderElection) {
            this.electLeader();
        }
        this.initialized.set(true);
    }

    private void electLeader() throws SchemaRegistryException {
        log.info("Joining schema registry with Kafka-based coordination");
        this.leaderElector = new KafkaGroupLeaderElector(this.config, this.myIdentity, this);
        try {
            this.leaderElector.init();
        }
        catch (SchemaRegistryStoreException e) {
            throw new SchemaRegistryInitializationException("Error electing leader while initializing schema registry", e);
        }
        catch (SchemaRegistryTimeoutException e) {
            throw new SchemaRegistryInitializationException(e);
        }
    }

    public void waitForInit() throws InterruptedException {
        this.kafkaStore.waitForInit();
    }

    public boolean initialized() {
        return this.kafkaStore.initialized() && this.initialized.get();
    }

    public boolean healthy() {
        return this.initialized() && this.getResourceExtensions().stream().allMatch(SchemaRegistryResourceExtension::healthy);
    }

    public void addLeaderChangeListener(Consumer<Boolean> listener) {
        this.leaderChangeListeners.add(listener);
    }

    public boolean isLeader() {
        this.kafkaStore.leaderLock().lock();
        try {
            boolean bl = this.leaderIdentity != null && this.leaderIdentity.equals(this.myIdentity);
            return bl;
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeader(@Nullable SchemaRegistryIdentity newLeader) throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, IdGenerationException {
        boolean leaderChanged;
        boolean isLeader;
        long started = this.time.hiResClockMs();
        log.info("Setting the leader to {}", (Object)newLeader);
        if (newLeader != null && !newLeader.getLeaderEligibility()) {
            throw new IllegalStateException("Tried to set an ineligible node to leader: " + newLeader);
        }
        this.kafkaStore.leaderLock().lock();
        try {
            SchemaRegistryIdentity previousLeader = this.leaderIdentity;
            this.leaderIdentity = newLeader;
            if (this.leaderIdentity == null) {
                this.leaderRestService = null;
            } else {
                this.leaderRestService = new RestService(this.leaderIdentity.getUrl(), this.config.whitelistHeaders().contains("X-Forward"));
                this.leaderRestService.setHttpConnectTimeoutMs(this.leaderConnectTimeoutMs);
                this.leaderRestService.setHttpReadTimeoutMs(this.leaderReadTimeoutMs);
                if (this.sslFactory != null && this.sslFactory.sslContext() != null) {
                    this.leaderRestService.setSslSocketFactory(this.sslFactory.sslContext().getSocketFactory());
                    this.leaderRestService.setHostnameVerifier(this.getHostnameVerifier());
                }
            }
            isLeader = this.isLeader();
            boolean bl = leaderChanged = this.leaderIdentity != null && !this.leaderIdentity.equals(previousLeader);
            if (leaderChanged) {
                log.info("Leader changed from {} to {}", (Object)previousLeader, (Object)this.leaderIdentity);
                if (isLeader) {
                    this.kafkaStore.markLastWrittenOffsetInvalid();
                    try {
                        this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.initTimeout);
                    }
                    catch (StoreException storeException) {
                        throw new SchemaRegistryStoreException("Exception getting latest offset ", storeException);
                    }
                    this.idGenerator.init();
                }
            }
            this.metricsContainer.getLeaderNode().record(this.isLeader() ? 1.0 : 0.0);
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
        if (leaderChanged) {
            for (Consumer consumer : this.leaderChangeListeners) {
                try {
                    consumer.accept(isLeader);
                }
                catch (Exception e) {
                    log.error("Could not invoke leader change listener", (Throwable)e);
                }
            }
        }
        long elapsed = this.time.hiResClockMs() - started;
        this.metricsContainer.getLeaderInitializationLatencyMetric().record(elapsed);
    }

    public SchemaRegistryIdentity myIdentity() {
        return this.myIdentity;
    }

    public SchemaRegistryIdentity leaderIdentity() {
        this.kafkaStore.leaderLock().lock();
        try {
            SchemaRegistryIdentity schemaRegistryIdentity = this.leaderIdentity;
            return schemaRegistryIdentity;
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
    }

    public RestService leaderRestService() {
        return this.leaderRestService;
    }

    @Override
    public Set<String> schemaTypes() {
        return this.providers.keySet();
    }

    public SchemaProvider schemaProvider(String schemaType) {
        return this.providers.get(schemaType);
    }

    public int normalizeLimit(int suppliedLimit) {
        int limit = this.searchDefaultLimit;
        if (suppliedLimit > 0 && suppliedLimit <= this.searchMaxLimit) {
            limit = suppliedLimit;
        }
        return limit;
    }

    @Override
    public Schema register(String subject, Schema schema, boolean normalize) throws SchemaRegistryException {
        try {
            Object schemaIdAndSubjects;
            int schemaId;
            ParsedSchema parsedSchema;
            this.checkRegisterMode(subject, schema);
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            List<SchemaKey> allVersions = this.getAllSchemaKeys(subject);
            Collections.reverse(allVersions);
            ArrayList<Schema> deletedVersions = new ArrayList<Schema>();
            ArrayList<ParsedSchemaHolder> undeletedVersions = new ArrayList<ParsedSchemaHolder>();
            int newVersion = 1;
            for (SchemaKey schemaKey : allVersions) {
                LazyParsedSchemaHolder schemaHolder = new LazyParsedSchemaHolder(this, schemaKey);
                SchemaValue schemaValue = schemaHolder.schemaValue();
                newVersion = Math.max(newVersion, schemaValue.getVersion() + 1);
                if (schemaValue.isDeleted()) {
                    deletedVersions.add(new Schema(schemaValue.getSubject(), schemaValue.getVersion(), schemaValue.getId()));
                    continue;
                }
                if (!undeletedVersions.isEmpty()) {
                    schemaHolder.clear();
                }
                undeletedVersions.add(schemaHolder);
            }
            Config config = this.getConfigInScope(subject);
            Mode mode = this.getModeInScope(subject);
            boolean modifiedSchema = false;
            if (mode != Mode.IMPORT) {
                modifiedSchema = this.maybePopulateFromPrevious(config, schema, undeletedVersions, newVersion);
            }
            if ((parsedSchema = this.canonicalizeSchema(schema, config, (schemaId = schema.getId().intValue()) < 0, normalize)) != null && (schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(schema)) != null && (schemaId < 0 || schemaId == ((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId())) {
                if (((SchemaIdAndSubjects)schemaIdAndSubjects).hasSubject(subject) && !this.isSubjectVersionDeleted(subject, ((SchemaIdAndSubjects)schemaIdAndSubjects).getVersion(subject))) {
                    return modifiedSchema ? schema.copy(Integer.valueOf(((SchemaIdAndSubjects)schemaIdAndSubjects).getVersion(subject)), Integer.valueOf(((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId())) : new Schema(subject, Integer.valueOf(((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId()));
                }
                schemaId = ((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId();
            }
            for (ParsedSchemaHolder schemaHolder : undeletedVersions) {
                SchemaValue schemaValue = ((LazyParsedSchemaHolder)schemaHolder).schemaValue();
                ParsedSchema undeletedSchema = schemaHolder.schema();
                if (parsedSchema == null || !parsedSchema.references().isEmpty() || undeletedSchema.references().isEmpty() || !parsedSchema.deepEquals(undeletedSchema) || schemaId >= 0 && schemaId != schemaValue.getId()) continue;
                return modifiedSchema ? schema.copy(schemaValue.getVersion(), schemaValue.getId()) : new Schema(subject, schemaValue.getId());
            }
            boolean isCompatible = true;
            ArrayList<String> compatibilityErrorLogs = new ArrayList<String>();
            if (mode != Mode.IMPORT) {
                Collections.reverse(undeletedVersions);
                compatibilityErrorLogs.addAll(this.isCompatibleWithPrevious(config, parsedSchema, undeletedVersions));
                isCompatible = compatibilityErrorLogs.isEmpty();
            }
            if (isCompatible) {
                ContextKey contextKey;
                QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
                if (qs != null && !".".equals(qs.getContext()) && this.kafkaStore.get(contextKey = new ContextKey(qs.getTenant(), qs.getContext())) == null) {
                    ContextValue contextValue = new ContextValue(qs.getTenant(), qs.getContext());
                    this.kafkaStore.put(contextKey, contextValue);
                }
                if (schema.getVersion() <= 0) {
                    schema.setVersion(Integer.valueOf(newVersion));
                } else if (newVersion != schema.getVersion() && mode != Mode.IMPORT) {
                    throw new InvalidSchemaException("Version is not one more than previous version");
                }
                SchemaKey schemaKey = new SchemaKey(subject, schema.getVersion());
                SchemaValue schemaValue = new SchemaValue(schema, this.ruleSetHandler);
                this.metadataEncoder.encodeMetadata(schemaValue);
                if (schemaId >= 0) {
                    this.checkIfSchemaWithIdExist(schemaId, schema);
                    schema.setId(Integer.valueOf(schemaId));
                    schemaValue.setId(schemaId);
                    this.kafkaStore.put(schemaKey, schemaValue);
                } else {
                    String qctx = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
                    int retries = 0;
                    while (retries++ < this.kafkaStoreMaxRetries) {
                        int newId = this.idGenerator.id(schemaValue);
                        if (this.lookupCache.schemaKeyById(newId, qctx) != null) continue;
                        schema.setId(Integer.valueOf(newId));
                        schemaValue.setId(newId);
                        if (retries > 1) {
                            log.warn(String.format("Retrying to register the schema with ID %s", newId));
                        }
                        this.kafkaStore.put(schemaKey, schemaValue);
                        break;
                    }
                    if (retries >= this.kafkaStoreMaxRetries) {
                        throw new SchemaRegistryStoreException("Error while registering the schema due to generating an ID that is already in use.");
                    }
                }
                for (Schema deleted : deletedVersions) {
                    if (!deleted.getId().equals(schema.getId()) || deleted.getVersion().compareTo(schema.getVersion()) >= 0) continue;
                    SchemaKey key = new SchemaKey(deleted.getSubject(), deleted.getVersion());
                    this.kafkaStore.put(key, null);
                }
                return modifiedSchema ? schema : new Schema(subject, schema.getId());
            }
            throw new IncompatibleSchemaException(((Object)compatibilityErrorLogs).toString());
        }
        catch (EntryTooLargeException e) {
            throw new SchemaTooLargeException("Write failed because schema is too large", e);
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while registering the schema in the backend Kafka store", e);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SchemaRegistryException) {
                throw (SchemaRegistryException)e.getCause();
            }
            throw e;
        }
    }

    private void checkRegisterMode(String subject, Schema schema) throws OperationNotPermittedException, SchemaRegistryStoreException {
        if (this.isReadOnlyMode(subject)) {
            throw new OperationNotPermittedException("Subject " + subject + " is in read-only mode");
        }
        if (schema.getId() >= 0) {
            if (this.getModeInScope(subject) != Mode.IMPORT) {
                throw new OperationNotPermittedException("Subject " + subject + " is not in import mode");
            }
        } else if (this.getModeInScope(subject) != Mode.READWRITE) {
            throw new OperationNotPermittedException("Subject " + subject + " is not in read-write mode");
        }
    }

    private boolean isReadOnlyMode(String subject) throws SchemaRegistryStoreException {
        Mode subjectMode = this.getModeInScope(subject);
        return subjectMode == Mode.READONLY || subjectMode == Mode.READONLY_OVERRIDE;
    }

    private boolean maybePopulateFromPrevious(Config config, Schema schema, List<ParsedSchemaHolder> undeletedVersions, int newVersion) throws SchemaRegistryException {
        Schema previousSchema;
        boolean populatedSchema = false;
        SchemaValue previousSchemaValue = !undeletedVersions.isEmpty() ? ((LazyParsedSchemaHolder)undeletedVersions.get(0)).schemaValue() : null;
        Schema schema2 = previousSchema = previousSchemaValue != null ? this.toSchemaEntity(previousSchemaValue) : null;
        if (schema == null || schema.getSchema() == null || schema.getSchema().trim().isEmpty()) {
            if (previousSchemaValue != null) {
                schema.setSchema(previousSchema.getSchema());
                schema.setSchemaType(previousSchema.getSchemaType());
                schema.setReferences(previousSchema.getReferences());
                populatedSchema = true;
            } else {
                throw new InvalidSchemaException("Empty schema");
            }
        }
        boolean populatedMetadataRuleSet = this.maybeSetMetadataRuleSet(config, schema, previousSchema, newVersion);
        return populatedSchema || populatedMetadataRuleSet;
    }

    private boolean maybeSetMetadataRuleSet(Config config, Schema schema, Schema previousSchema, int newVersion) {
        Metadata specificMetadata = null;
        if (schema.getMetadata() != null) {
            specificMetadata = schema.getMetadata();
        } else if (previousSchema != null) {
            specificMetadata = previousSchema.getMetadata();
        }
        Metadata defaultMetadata = config.getDefaultMetadata();
        Metadata overrideMetadata = config.getOverrideMetadata();
        Metadata mergedMetadata = Metadata.mergeMetadata((Metadata)Metadata.mergeMetadata((Metadata)defaultMetadata, (Metadata)specificMetadata), (Metadata)overrideMetadata);
        RuleSet specificRuleSet = null;
        if (schema.getRuleSet() != null) {
            specificRuleSet = schema.getRuleSet();
        } else if (previousSchema != null) {
            specificRuleSet = previousSchema.getRuleSet();
        }
        RuleSet defaultRuleSet = config.getDefaultRuleSet();
        RuleSet overrideRuleSet = config.getOverrideRuleSet();
        RuleSet mergedRuleSet = RuleSet.mergeRuleSets((RuleSet)RuleSet.mergeRuleSets((RuleSet)defaultRuleSet, (RuleSet)specificRuleSet), (RuleSet)overrideRuleSet);
        if (mergedMetadata != null || mergedRuleSet != null) {
            SortedMap props;
            String versionStr;
            if (mergedMetadata != null && mergedMetadata.getProperties() != null && "0".equals(versionStr = (String)(props = mergedMetadata.getProperties()).get(CONFLUENT_VERSION))) {
                Map<String, String> newProps = Collections.singletonMap(CONFLUENT_VERSION, String.valueOf(newVersion));
                mergedMetadata = Metadata.mergeMetadata((Metadata)mergedMetadata, (Metadata)new Metadata(null, newProps, null));
            }
            schema.setMetadata(mergedMetadata);
            schema.setRuleSet(mergedRuleSet);
            return true;
        }
        return false;
    }

    public Schema registerOrForward(String subject, Schema schema, boolean normalize, Map<String, String> headerProperties) throws SchemaRegistryException {
        Schema existingSchema;
        Config config = this.getConfigInScope(subject);
        if (!config.hasDefaultsOrOverrides() && (existingSchema = this.lookUpSchemaUnderSubject(subject, schema, normalize, false)) != null && (schema.getId() == null || schema.getId() < 0 || schema.getId().equals(existingSchema.getId()))) {
            return new Schema(subject, existingSchema.getId());
        }
        this.kafkaStore.lockFor(subject).lock();
        try {
            Schema schema2;
            if (this.isLeader()) {
                schema2 = this.register(subject, schema, normalize);
                return schema2;
            }
            if (this.leaderIdentity != null) {
                schema2 = this.forwardRegisterRequestToLeader(subject, schema, normalize, headerProperties);
                return schema2;
            }
            throw new UnknownLeaderException("Register schema request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    public Schema modifySchemaTags(String subject, Schema schema, TagSchemaRequest request) throws SchemaRegistryException {
        ParsedSchema parsedSchema = this.parseSchema(schema);
        int newVersion = request.getNewVersion() != null ? request.getNewVersion() : 0;
        Metadata mergedMetadata = request.getMetadata() != null ? request.getMetadata() : parsedSchema.metadata();
        Metadata newMetadata = new Metadata(Collections.emptyMap(), Collections.singletonMap(CONFLUENT_VERSION, String.valueOf(newVersion)), Collections.emptySet());
        mergedMetadata = Metadata.mergeMetadata((Metadata)mergedMetadata, (Metadata)newMetadata);
        RuleSet ruleSet = this.maybeModifyPreviousRuleSet(subject, request);
        try {
            ParsedSchema newSchema = parsedSchema.copy(TagSchemaRequest.schemaTagsListToMap((List)request.getTagsToAdd()), TagSchemaRequest.schemaTagsListToMap((List)request.getTagsToRemove())).copy(mergedMetadata, ruleSet).copy(Integer.valueOf(newVersion));
            return this.register(subject, new Schema(subject, Integer.valueOf(newVersion), Integer.valueOf(-1), newSchema), false);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSchemaException(e);
        }
    }

    private RuleSet maybeModifyPreviousRuleSet(String subject, TagSchemaRequest request) throws SchemaRegistryException {
        RuleSet ruleSet;
        if (request.getRulesToMerge() == null && request.getRulesToRemove() == null) {
            return request.getRuleSet();
        }
        int oldVersion = request.getNewVersion() != null ? request.getNewVersion() - 1 : -1;
        Schema oldSchema = this.get(subject, oldVersion, false);
        RuleSet ruleSet2 = ruleSet = oldSchema != null ? oldSchema.getRuleSet() : null;
        if (request.getRulesToMerge() != null) {
            ruleSet = RuleSet.mergeRuleSets((RuleSet)ruleSet, (RuleSet)request.getRulesToMerge());
        }
        if (ruleSet != null && request.getRulesToRemove() != null) {
            List domainRules;
            List rulesToRemove = request.getRulesToRemove();
            List migrationRules = ruleSet.getMigrationRules();
            if (migrationRules != null) {
                migrationRules = migrationRules.stream().filter(r -> !rulesToRemove.contains(r.getName())).collect(Collectors.toList());
            }
            if ((domainRules = ruleSet.getDomainRules()) != null) {
                domainRules = domainRules.stream().filter(r -> !rulesToRemove.contains(r.getName())).collect(Collectors.toList());
            }
            ruleSet = new RuleSet(migrationRules, domainRules);
        }
        return ruleSet;
    }

    public Schema modifySchemaTagsOrForward(String subject, Schema schema, TagSchemaRequest request, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.kafkaStore.lockFor(subject).lock();
        try {
            if (this.isLeader()) {
                Schema schema2 = this.modifySchemaTags(subject, schema, request);
                return schema2;
            }
            if (this.leaderIdentity != null) {
                Schema schema3 = this.forwardModifySchemaTagsRequestToLeader(subject, schema, request, headerProperties);
                return schema3;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    @Override
    public void deleteSchemaVersion(String subject, Schema schema, boolean permanentDelete) throws SchemaRegistryException {
        try {
            if (this.isReadOnlyMode(subject)) {
                throw new OperationNotPermittedException("Subject " + subject + " is in read-only mode");
            }
            SchemaKey key = new SchemaKey(subject, schema.getVersion());
            if (!this.lookupCache.referencesSchema(key).isEmpty()) {
                throw new ReferenceExistsException(key.toString());
            }
            SchemaValue schemaValue = (SchemaValue)this.lookupCache.get(key);
            if (permanentDelete && schemaValue != null && !schemaValue.isDeleted()) {
                throw new SchemaVersionNotSoftDeletedException(subject, schema.getVersion().toString());
            }
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            if (!permanentDelete) {
                schemaValue = new SchemaValue(schema);
                schemaValue.setDeleted(true);
                this.metadataEncoder.encodeMetadata(schemaValue);
                this.kafkaStore.put(key, schemaValue);
                if (!this.getAllVersions(subject, LookupFilter.DEFAULT).hasNext()) {
                    if (this.getMode(subject) != null) {
                        this.deleteMode(subject);
                    }
                    if (this.getConfig(subject) != null) {
                        this.deleteConfig(subject);
                    }
                }
            } else {
                this.kafkaStore.put(key, null);
            }
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while deleting the schema for subject '" + subject + "' in the backend Kafka store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaVersionOrForward(Map<String, String> headerProperties, String subject, Schema schema, boolean permanentDelete) throws SchemaRegistryException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSchemaVersion(subject, schema, permanentDelete);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteSchemaVersionRequestToLeader(headerProperties, subject, schema.getVersion(), permanentDelete);
                    break block5;
                }
                throw new UnknownLeaderException("Register schema request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean permanentDelete) throws SchemaRegistryException {
        try {
            SubjectKey key;
            if (this.isReadOnlyMode(subject)) {
                throw new OperationNotPermittedException("Subject " + subject + " is in read-only mode");
            }
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            ArrayList<Integer> deletedVersions = new ArrayList<Integer>();
            int deleteWatermarkVersion = 0;
            Iterator<SchemaKey> schemasToBeDeleted = this.getAllVersions(subject, permanentDelete ? LookupFilter.INCLUDE_DELETED : LookupFilter.DEFAULT);
            while (schemasToBeDeleted.hasNext()) {
                SchemaValue schemaValue;
                deleteWatermarkVersion = schemasToBeDeleted.next().getVersion();
                key = new SchemaKey(subject, deleteWatermarkVersion);
                if (!this.lookupCache.referencesSchema((SchemaKey)key).isEmpty()) {
                    throw new ReferenceExistsException(((SchemaKey)key).toString());
                }
                if (permanentDelete && (schemaValue = (SchemaValue)this.lookupCache.get(key)) != null && !schemaValue.isDeleted()) {
                    throw new SubjectNotSoftDeletedException(subject);
                }
                deletedVersions.add(deleteWatermarkVersion);
            }
            if (!permanentDelete) {
                key = new DeleteSubjectKey(subject);
                DeleteSubjectValue value = new DeleteSubjectValue(subject, deleteWatermarkVersion);
                this.kafkaStore.put(key, value);
                if (this.getMode(subject) != null) {
                    this.deleteMode(subject);
                }
                if (this.getConfig(subject) != null) {
                    this.deleteConfig(subject);
                }
            } else {
                for (Integer version : deletedVersions) {
                    this.kafkaStore.put(new SchemaKey(subject, version), null);
                }
            }
            return deletedVersions;
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while deleting the subject in the backend Kafka store", e);
        }
    }

    public List<Integer> deleteSubjectOrForward(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws SchemaRegistryException {
        this.kafkaStore.lockFor(subject).lock();
        try {
            if (this.isLeader()) {
                List<Integer> list = this.deleteSubject(subject, permanentDelete);
                return list;
            }
            if (this.leaderIdentity != null) {
                List<Integer> list = this.forwardDeleteSubjectRequestToLeader(requestProperties, subject, permanentDelete);
                return list;
            }
            throw new UnknownLeaderException("Register schema request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    public Schema lookUpSchemaUnderSubjectUsingContexts(String subject, Schema schema, boolean normalize, boolean lookupDeletedSchema) throws SchemaRegistryException {
        boolean isQualifiedSubject;
        Schema matchingSchema = this.lookUpSchemaUnderSubject(subject, schema, normalize, lookupDeletedSchema);
        if (matchingSchema != null) {
            return matchingSchema;
        }
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean bl = isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        if (isQualifiedSubject) {
            return null;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                Schema qualSchema = schema.copy();
                qualSchema.setSubject(qualSub.toQualifiedSubject());
                try {
                    matchingSchema = this.lookUpSchemaUnderSubject(qualSub.toQualifiedSubject(), qualSchema, normalize, lookupDeletedSchema);
                }
                catch (InvalidSchemaException invalidSchemaException) {
                    // empty catch block
                }
                if (matchingSchema == null) continue;
                Schema schema2 = matchingSchema;
                return schema2;
            }
        }
        return null;
    }

    @Override
    public Schema lookUpSchemaUnderSubject(String subject, Schema schema, boolean normalize, boolean lookupDeletedSchema) throws SchemaRegistryException {
        try {
            SchemaIdAndSubjects schemaIdAndSubjects;
            Schema newSchema = schema != null ? schema.copy() : null;
            Config config = this.getConfigInScope(subject);
            ParsedSchema parsedSchema = this.canonicalizeSchema(newSchema, config, false, normalize);
            if (parsedSchema != null && (schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(newSchema)) != null && schemaIdAndSubjects.hasSubject(subject) && (lookupDeletedSchema || !this.isSubjectVersionDeleted(subject, schemaIdAndSubjects.getVersion(subject)))) {
                Schema matchingSchema = newSchema.copy();
                matchingSchema.setSubject(subject);
                matchingSchema.setVersion(Integer.valueOf(schemaIdAndSubjects.getVersion(subject)));
                matchingSchema.setId(Integer.valueOf(schemaIdAndSubjects.getSchemaId()));
                return matchingSchema;
            }
            List<SchemaKey> allVersions = this.getAllSchemaKeys(subject);
            Collections.reverse(allVersions);
            for (SchemaKey schemaKey : allVersions) {
                ParsedSchema prevSchema;
                Schema prev = this.get(schemaKey.getSubject(), schemaKey.getVersion(), lookupDeletedSchema);
                if (prev == null || parsedSchema == null || !parsedSchema.references().isEmpty() || prev.getReferences().isEmpty() || !parsedSchema.deepEquals(prevSchema = this.parseSchema(prev))) continue;
                return prev;
            }
            return null;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Schema getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws SchemaRegistryException {
        List<SchemaKey> allVersions = this.getAllSchemaKeys(subject);
        Collections.reverse(allVersions);
        for (SchemaKey schemaKey : allVersions) {
            SortedMap props;
            Schema schema = this.get(schemaKey.getSubject(), schemaKey.getVersion(), lookupDeletedSchema);
            if (schema == null || schema.getMetadata() == null || (props = schema.getMetadata().getProperties()) == null || !props.entrySet().containsAll(metadata.entrySet())) continue;
            return schema;
        }
        return null;
    }

    public void checkIfSchemaWithIdExist(int id, Schema schema) throws SchemaRegistryException, StoreException {
        SchemaRegistryValue existingValue;
        String qctx = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)schema.getSubject());
        SchemaKey existingKey = this.lookupCache.schemaKeyById(id, qctx);
        if (existingKey != null && (existingValue = (SchemaRegistryValue)this.lookupCache.get(existingKey)) instanceof SchemaValue) {
            SchemaValue existingSchemaValue = (SchemaValue)existingValue;
            Schema existingSchema = this.toSchemaEntity(existingSchemaValue);
            Schema schemaCopy = schema.copy();
            schemaCopy.setId(existingSchema.getId());
            schemaCopy.setSubject(existingSchema.getSubject());
            schemaCopy.setVersion(existingSchema.getVersion());
            if (!existingSchema.equals((Object)schemaCopy)) {
                throw new OperationNotPermittedException(String.format("Overwrite new schema with id %s is not permitted.", id));
            }
        }
    }

    private Schema forwardRegisterRequestToLeader(String subject, Schema schema, boolean normalize, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        RegisterSchemaRequest registerSchemaRequest = new RegisterSchemaRequest(schema);
        log.debug(String.format("Forwarding registering schema request to %s", baseUrl));
        try {
            RegisterSchemaResponse response = this.leaderRestService.registerSchema(headerProperties, registerSchemaRequest, subject, normalize);
            return new Schema(subject, response);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the registering schema request to %s", baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    public Schema forwardModifySchemaTagsRequestToLeader(String subject, Schema schema, TagSchemaRequest request, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug(String.format("Forwarding register schema tags request to %s", baseUrl));
        try {
            RegisterSchemaResponse response = this.leaderRestService.modifySchemaTags(headerProperties, request, subject, String.valueOf(schema.getVersion()));
            return new Schema(subject, response);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the register schema tags request to %s", baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardUpdateConfigRequestToLeader(String subject, Config config, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(config);
        log.debug(String.format("Forwarding update config request %s to %s", configUpdateRequest, baseUrl));
        try {
            this.leaderRestService.updateConfig(headerProperties, configUpdateRequest, subject);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update config request %s to %s", configUpdateRequest, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteSchemaVersionRequestToLeader(Map<String, String> headerProperties, String subject, Integer version, boolean permanentDelete) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug(String.format("Forwarding deleteSchemaVersion schema version request %s-%s to %s", subject, version, baseUrl));
        try {
            this.leaderRestService.deleteSchemaVersion(headerProperties, subject, String.valueOf(version), permanentDelete);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding deleteSchemaVersion schema version request %s-%s to %s", subject, version, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<Integer> forwardDeleteSubjectRequestToLeader(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug(String.format("Forwarding delete subject request for  %s to %s", subject, baseUrl));
        try {
            return this.leaderRestService.deleteSubject(requestProperties, subject, permanentDelete);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject request %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteConfigToLeader(Map<String, String> requestProperties, String subject) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug(String.format("Forwarding delete subject compatibility config request %s to %s", subject, baseUrl));
        try {
            this.leaderRestService.deleteConfig(requestProperties, subject);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject compatibility configrequest %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardSetModeRequestToLeader(String subject, Mode mode, boolean force, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        ModeUpdateRequest modeUpdateRequest = new ModeUpdateRequest();
        modeUpdateRequest.setMode(mode.name());
        log.debug(String.format("Forwarding update mode request %s to %s", modeUpdateRequest, baseUrl));
        try {
            this.leaderRestService.setMode(headerProperties, modeUpdateRequest, subject, force);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update mode request %s to %s", modeUpdateRequest, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteSubjectModeRequestToLeader(String subject, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug(String.format("Forwarding delete subject mode request %s to %s", subject, baseUrl));
        try {
            this.leaderRestService.deleteSubjectMode(headerProperties, subject);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject moderequest %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private ParsedSchema canonicalizeSchema(Schema schema, Config config, boolean isNew, boolean normalize) throws InvalidSchemaException {
        if (schema == null || schema.getSchema() == null || schema.getSchema().trim().isEmpty()) {
            return null;
        }
        ParsedSchema parsedSchema = this.parseSchema(schema, isNew, normalize);
        return this.maybeValidateAndNormalizeSchema(parsedSchema, schema, config, normalize);
    }

    private ParsedSchema maybeValidateAndNormalizeSchema(ParsedSchema parsedSchema, Schema schema, Config config, boolean normalize) throws InvalidSchemaException {
        try {
            if (this.getModeInScope(schema.getSubject()) != Mode.IMPORT) {
                parsedSchema.validate(this.isSchemaFieldValidationEnabled(config));
            }
            if (normalize) {
                parsedSchema = parsedSchema.normalize();
            }
        }
        catch (Exception e) {
            String errMsg = "Invalid schema " + schema + ", details: " + e.getMessage();
            log.error(errMsg, (Throwable)e);
            throw new InvalidSchemaException(errMsg, e);
        }
        schema.setSchemaType(parsedSchema.schemaType());
        schema.setSchema(parsedSchema.canonicalString());
        schema.setReferences(parsedSchema.references());
        return parsedSchema;
    }

    public ParsedSchema parseSchema(Schema schema) throws InvalidSchemaException {
        return this.parseSchema(schema, false, false);
    }

    public ParsedSchema parseSchema(Schema schema, boolean isNew, boolean normalize) throws InvalidSchemaException {
        try {
            ParsedSchema parsedSchema;
            ParsedSchema parsedSchema2 = parsedSchema = isNew ? (ParsedSchema)this.newSchemaCache.get((Object)new RawSchema(schema.toHashKey(), isNew, normalize)) : (ParsedSchema)this.oldSchemaCache.get((Object)new RawSchema(schema.toHashKey(), isNew, normalize));
            if (schema.getVersion() != null) {
                parsedSchema = parsedSchema.copy(schema.getVersion());
            }
            return parsedSchema;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidSchemaException) {
                throw (InvalidSchemaException)cause;
            }
            throw new InvalidSchemaException(e);
        }
    }

    private ParsedSchema loadSchema(Schema schema, boolean isNew, boolean normalize) throws InvalidSchemaException {
        SchemaProvider provider;
        String schemaType = schema.getSchemaType();
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((provider = this.schemaProvider(schemaType)) == null) {
            String errMsg = "Invalid schema type " + schemaType;
            log.error(errMsg);
            throw new InvalidSchemaException(errMsg);
        }
        String type = schemaType;
        try {
            return provider.parseSchemaOrElseThrow(schema, isNew, normalize);
        }
        catch (Exception e) {
            throw new InvalidSchemaException("Invalid schema " + schema + " with refs " + schema.getReferences() + " of type " + type + ", details: " + e.getMessage());
        }
    }

    public Schema getUsingContexts(String subject, int version, boolean returnDeletedSchema) throws SchemaRegistryException {
        boolean isQualifiedSubject;
        Schema schema = this.get(subject, version, returnDeletedSchema);
        if (schema != null) {
            return schema;
        }
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean bl = isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        if (isQualifiedSubject) {
            return null;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                schema = this.get(qualSub.toQualifiedSubject(), version, returnDeletedSchema);
                if (schema == null) continue;
                Schema schema2 = schema;
                return schema2;
            }
        }
        return null;
    }

    public boolean schemaVersionExists(String subject, VersionId versionId, boolean returnDeletedSchema) throws SchemaRegistryException {
        int version = versionId.getVersionId();
        Schema schema = this.get(subject, version, returnDeletedSchema);
        return schema != null;
    }

    @Override
    public Schema get(String subject, int version, boolean returnDeletedSchema) throws SchemaRegistryException {
        VersionId versionId = new VersionId(version);
        if (versionId.isLatest()) {
            return this.getLatestVersion(subject);
        }
        SchemaValue schemaValue = this.getSchemaValue(new SchemaKey(subject, version));
        Schema schema = null;
        if (schemaValue != null && (!schemaValue.isDeleted() || returnDeletedSchema)) {
            schema = this.toSchemaEntity(schemaValue);
        }
        return schema;
    }

    @Override
    public SchemaString get(int id, String subject) throws SchemaRegistryException {
        return this.get(id, subject, null, false);
    }

    public SchemaString get(int id, String subject, String format, boolean fetchMaxId) throws SchemaRegistryException {
        SchemaValue schema;
        try {
            SchemaKey subjectVersionKey = this.getSchemaKeyUsingContexts(id, subject);
            if (subjectVersionKey == null) {
                return null;
            }
            schema = (SchemaValue)this.kafkaStore.get(subjectVersionKey);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with id " + id + " from the backend Kafka store", e);
        }
        Schema schemaEntity = this.toSchemaEntity(schema);
        SchemaString schemaString = new SchemaString(schemaEntity);
        if (format != null && !format.trim().isEmpty()) {
            ParsedSchema parsedSchema = this.parseSchema(schemaEntity, false, false);
            schemaString.setSchemaString(parsedSchema.formattedString(format));
        } else {
            schemaString.setSchemaString(schema.getSchema());
        }
        if (fetchMaxId) {
            schemaString.setMaxId(Integer.valueOf(this.idGenerator.getMaxId(schema)));
        }
        return schemaString;
    }

    public Schema toSchemaEntity(SchemaValue schemaValue) throws SchemaRegistryStoreException {
        this.metadataEncoder.decodeMetadata(schemaValue);
        return schemaValue.toSchemaEntity();
    }

    protected SchemaValue getSchemaValue(SchemaKey key) throws SchemaRegistryException {
        try {
            return (SchemaValue)this.kafkaStore.get(key);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema from the backend Kafka store", e);
        }
    }

    private SchemaKey getSchemaKeyUsingContexts(int id, String subject) throws StoreException, SchemaRegistryException {
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        SchemaKey subjectVersionKey = this.lookupCache.schemaKeyById(id, subject);
        if (qs == null || qs.getSubject().isEmpty() || isQualifiedSubject || subjectVersionKey != null) {
            return subjectVersionKey;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                SchemaKey key = this.lookupCache.schemaKeyById(id, qualSub.toQualifiedSubject());
                if (key == null) continue;
                SchemaKey schemaKey = key;
                return schemaKey;
            }
        }
        return this.lookupCache.schemaKeyById(id, qs.toQualifiedContext());
    }

    private CloseableIterator<SchemaRegistryValue> allContexts() throws SchemaRegistryException {
        try {
            ContextKey key1 = new ContextKey(this.tenant(), String.valueOf('\u0000'));
            ContextKey key2 = new ContextKey(this.tenant(), String.valueOf('\uffff'));
            return this.kafkaStore.getAll(key1, key2);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    public List<Integer> getReferencedBy(String subject, VersionId versionId) throws SchemaRegistryException {
        try {
            int version = versionId.getVersionId();
            if (versionId.isLatest()) {
                version = this.getLatestVersion(subject).getVersion();
            }
            SchemaKey key = new SchemaKey(subject, version);
            ArrayList<Integer> ids = new ArrayList<Integer>(this.lookupCache.referencesSchema(key));
            Collections.sort(ids);
            return ids;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    public List<String> listContexts() throws SchemaRegistryException {
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add(".");
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue contextValue = (ContextValue)iter.next();
                contexts.add(contextValue.getContext());
            }
        }
        return contexts;
    }

    @Override
    public Set<String> listSubjects(LookupFilter filter) throws SchemaRegistryException {
        return this.listSubjectsWithPrefix(":*:", filter);
    }

    public Set<String> listSubjectsWithPrefix(String prefix, LookupFilter filter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(prefix, true);){
            Set<String> set = this.extractUniqueSubjects(allVersions, filter);
            return set;
        }
    }

    public Set<String> listSubjectsForId(int id, String subject) throws SchemaRegistryException {
        return this.listSubjectsForId(id, subject, false);
    }

    @Override
    public Set<String> listSubjectsForId(int id, String subject, boolean returnDeleted) throws SchemaRegistryException {
        List<SubjectVersion> versions = this.listVersionsForId(id, subject, returnDeleted);
        return versions != null ? (Set)versions.stream().map(SubjectVersion::getSubject).collect(Collectors.toCollection(LinkedHashSet::new)) : null;
    }

    public List<SubjectVersion> listVersionsForId(int id, String subject) throws SchemaRegistryException {
        return this.listVersionsForId(id, subject, false);
    }

    public List<SubjectVersion> listVersionsForId(int id, String subject, boolean lookupDeleted) throws SchemaRegistryException {
        try {
            SchemaKey subjectVersionKey = this.getSchemaKeyUsingContexts(id, subject);
            if (subjectVersionKey == null) {
                return null;
            }
            SchemaValue schema = (SchemaValue)this.kafkaStore.get(subjectVersionKey);
            if (schema == null) {
                return null;
            }
            SchemaIdAndSubjects schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(this.toSchemaEntity(schema));
            if (schemaIdAndSubjects == null) {
                return null;
            }
            return schemaIdAndSubjects.allSubjectVersions().entrySet().stream().flatMap(e -> {
                try {
                    SchemaValue schemaValue = (SchemaValue)this.kafkaStore.get(new SchemaKey((String)e.getKey(), (Integer)e.getValue()));
                    if (schemaValue != null && (!schemaValue.isDeleted() || lookupDeleted)) {
                        return Stream.of(new SubjectVersion((String)e.getKey(), (Integer)e.getValue()));
                    }
                    return Stream.empty();
                }
                catch (StoreException ex) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
        }
        catch (StoreException e2) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with id " + id + " from the backend Kafka store", e2);
        }
    }

    private Set<String> extractUniqueSubjects(Iterator<SchemaRegistryValue> allVersions, LookupFilter filter) {
        HashMap<String, Boolean> subjects = new HashMap<String, Boolean>();
        while (allVersions.hasNext()) {
            SchemaValue value = (SchemaValue)allVersions.next();
            subjects.merge(value.getSubject(), value.isDeleted(), (v1, v2) -> v1 != false && v2 != false);
        }
        return subjects.keySet().stream().filter(k -> KafkaSchemaRegistry.shouldInclude((Boolean)subjects.get(k), filter)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> subjects(String subject, boolean lookupDeletedSubjects) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.subjects(subject, lookupDeletedSubjects);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    public boolean hasSubjects(String subject, boolean lookupDeletedSubjects) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.hasSubjects(subject, lookupDeletedSubjects);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Iterator<SchemaKey> getAllVersions(String subject, LookupFilter filter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            Iterator<SchemaKey> iterator = this.sortSchemaKeysByVersion(allVersions, filter).iterator();
            return iterator;
        }
    }

    @Override
    public Iterator<Schema> getVersionsWithSubjectPrefix(String prefix, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(prefix, true);){
            Iterator<Schema> iterator = this.sortSchemasByVersion(allVersions, filter, returnLatestOnly, postFilter).iterator();
            return iterator;
        }
    }

    private List<SchemaKey> getAllSchemaKeys(String subject) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            List<SchemaKey> list = this.sortSchemaKeysByVersion(allVersions, LookupFilter.INCLUDE_DELETED);
            return list;
        }
    }

    @Override
    public Schema getLatestVersion(String subject) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            Schema schema = this.getLatestVersionFromSubjectSchemas(allVersions);
            return schema;
        }
    }

    private Schema getLatestVersionFromSubjectSchemas(CloseableIterator<SchemaRegistryValue> schemas) throws SchemaRegistryException {
        int latestVersionId = -1;
        SchemaValue latestSchemaValue = null;
        while (schemas.hasNext()) {
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            if (schemaValue.isDeleted() || schemaValue.getVersion() <= latestVersionId) continue;
            latestVersionId = schemaValue.getVersion();
            latestSchemaValue = schemaValue;
        }
        return latestSchemaValue != null ? this.toSchemaEntity(latestSchemaValue) : null;
    }

    private CloseableIterator<SchemaRegistryValue> allVersions(String subjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        try {
            String end;
            String start;
            int idx = subjectOrPrefix.indexOf(":*:");
            if (idx >= 0) {
                String prefix = subjectOrPrefix.substring(0, idx);
                String unqualifiedSubjectOrPrefix = subjectOrPrefix.substring(idx + ":*:".length());
                if (!unqualifiedSubjectOrPrefix.isEmpty()) {
                    return this.allVersionsFromAllContexts(prefix, unqualifiedSubjectOrPrefix, isPrefix);
                }
                start = prefix + ":." + ":";
                end = prefix + ":." + '\uffff' + ":";
            } else {
                start = subjectOrPrefix;
                end = isPrefix ? subjectOrPrefix + '\uffff' : subjectOrPrefix;
            }
            SchemaKey key1 = new SchemaKey(start, 1);
            SchemaKey key2 = new SchemaKey(end, Integer.MAX_VALUE);
            return FilteredIterator.filter(TransformedIterator.transform(this.kafkaStore.getAll(key1, key2), v -> {
                if (v instanceof SchemaValue) {
                    try {
                        this.metadataEncoder.decodeMetadata((SchemaValue)v);
                    }
                    catch (SchemaRegistryStoreException e) {
                        log.error("Failed to decode metadata for schema id {}", (Object)((SchemaValue)v).getId(), (Object)e);
                        return null;
                    }
                }
                return v;
            }), Objects::nonNull);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> allVersionsFromAllContexts(String tenantPrefix, String unqualifiedSubjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        ArrayList versions = new ArrayList();
        CloseableIterator<SchemaRegistryValue> iter = this.allVersions(tenantPrefix + unqualifiedSubjectOrPrefix, isPrefix);
        Object object = null;
        try {
            while (iter.hasNext()) {
                versions.add(iter.next());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (iter != null) {
                if (object != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    iter.close();
                }
            }
        }
        ArrayList<ContextValue> contexts = new ArrayList<ContextValue>();
        try (CloseableIterator<SchemaRegistryValue> iter2 = this.allContexts();){
            while (iter2.hasNext()) {
                contexts.add((ContextValue)iter2.next());
            }
        }
        for (ContextValue v : contexts) {
            QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), unqualifiedSubjectOrPrefix);
            CloseableIterator<SchemaRegistryValue> subiter = this.allVersions(qualSub.toQualifiedSubject(), isPrefix);
            Throwable throwable = null;
            try {
                while (subiter.hasNext()) {
                    versions.add(subiter.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (subiter == null) continue;
                if (throwable != null) {
                    try {
                        subiter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                subiter.close();
            }
        }
        return new DelegatingIterator<SchemaRegistryValue>(versions.iterator());
    }

    public void invalidateFromNewSchemaCache(Schema schema) {
        this.newSchemaCache.invalidate((Object)new RawSchema(schema, true, false));
        this.newSchemaCache.invalidate((Object)new RawSchema(schema, true, true));
    }

    public void invalidateFromOldSchemaCache(Schema schema) {
        this.oldSchemaCache.invalidate((Object)new RawSchema(schema, false, false));
        this.oldSchemaCache.invalidate((Object)new RawSchema(schema, false, true));
    }

    public void clearNewSchemaCache() {
        this.newSchemaCache.invalidateAll();
    }

    public void clearOldSchemaCache() {
        this.oldSchemaCache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        log.info("Shutting down schema registry");
        this.kafkaStore.close();
        this.metadataEncoder.close();
        if (this.leaderElector != null) {
            this.leaderElector.close();
        }
        if (this.leaderRestService != null) {
            this.leaderRestService.close();
        }
    }

    public void updateConfig(String subject, Config config) throws SchemaRegistryStoreException, OperationNotPermittedException, UnknownLeaderException {
        if (this.isReadOnlyMode(subject)) {
            throw new OperationNotPermittedException("Subject " + subject + " is in read-only mode");
        }
        ConfigKey configKey = new ConfigKey(subject);
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            ConfigValue oldConfig = (ConfigValue)this.kafkaStore.get(configKey);
            ConfigValue newConfig = new ConfigValue(subject, config, this.ruleSetHandler);
            this.kafkaStore.put(configKey, ConfigValue.update(oldConfig, newConfig));
            log.debug("Wrote new config: {} to the Kafka data store with key {}", (Object)config, (Object)configKey);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigOrForward(String subject, Config newConfig, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, UnknownLeaderException, OperationNotPermittedException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.updateConfig(subject, newConfig);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardUpdateConfigRequestToLeader(subject, newConfig, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Update config request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    public void deleteSubjectConfig(String subject) throws SchemaRegistryStoreException, OperationNotPermittedException {
        if (this.isReadOnlyMode(subject)) {
            throw new OperationNotPermittedException("Subject " + subject + " is in read-only mode");
        }
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            this.deleteConfig(subject);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to delete subject config value from store", e);
        }
    }

    public void deleteConfigOrForward(String subject, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSubjectConfig(subject);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteConfigToLeader(headerProperties, subject);
                    break block5;
                }
                throw new UnknownLeaderException("Delete config request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String kafkaClusterId(SchemaRegistryConfig config) throws SchemaRegistryException {
        Properties adminClientProps = new Properties();
        KafkaStore.addSchemaRegistryConfigsToClientProperties(config, adminClientProps);
        adminClientProps.put("bootstrap.servers", config.bootstrapBrokers());
        try (AdminClient adminClient = AdminClient.create((Properties)adminClientProps);){
            String string = (String)adminClient.describeCluster().clusterId().get((long)this.initTimeout, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new SchemaRegistryException("Failed to get Kafka cluster ID", e);
        }
    }

    public String getKafkaClusterId() {
        return this.kafkaClusterId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Config getConfig(String subject) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.config(subject, false, new Config(this.defaultCompatibilityLevel.name));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    public Config getConfigInScope(String subject) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.config(subject, true, new Config(this.defaultCompatibilityLevel.name));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public List<String> isCompatible(String subject, Schema newSchema, List<SchemaKey> previousSchemas, boolean normalize) throws SchemaRegistryException {
        if (previousSchemas == null) {
            log.error("Previous schema not provided");
            throw new InvalidSchemaException("Previous schema not provided");
        }
        try {
            ArrayList<ParsedSchemaHolder> prevParsedSchemas = new ArrayList<ParsedSchemaHolder>(previousSchemas.size());
            for (SchemaKey previousSchema : previousSchemas) {
                prevParsedSchemas.add(new LazyParsedSchemaHolder(this, previousSchema));
            }
            Config config = this.getConfigInScope(subject);
            ParsedSchema parsedSchema = this.canonicalizeSchema(newSchema, config, true, normalize);
            if (parsedSchema == null) {
                log.error("Empty schema");
                throw new InvalidSchemaException("Empty schema");
            }
            return this.isCompatibleWithPrevious(config, parsedSchema, prevParsedSchemas);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SchemaRegistryException) {
                throw (SchemaRegistryException)e.getCause();
            }
            throw e;
        }
    }

    private List<String> isCompatibleWithPrevious(Config config, ParsedSchema parsedSchema, List<ParsedSchemaHolder> previousSchemas) {
        ParsedSchemaHolder previousSchemaHolder;
        ArrayList<String> errorMessages = new ArrayList<String>();
        ParsedSchemaHolder parsedSchemaHolder = previousSchemaHolder = !previousSchemas.isEmpty() ? previousSchemas.get(previousSchemas.size() - 1) : null;
        if (this.isSchemaFieldValidationEnabled(config)) {
            errorMessages.addAll(this.validateReservedFields(parsedSchema, previousSchemaHolder));
        }
        CompatibilityLevel compatibility = CompatibilityLevel.forName((String)config.getCompatibilityLevel());
        String compatibilityGroup = config.getCompatibilityGroup();
        if (compatibilityGroup != null) {
            String groupValue = KafkaSchemaRegistry.getCompatibilityGroupValue(parsedSchema, compatibilityGroup);
            previousSchemas = previousSchemas.stream().filter(s -> Objects.equals(groupValue, KafkaSchemaRegistry.getCompatibilityGroupValue(s.schema(), compatibilityGroup))).collect(Collectors.toList());
        }
        errorMessages.addAll(parsedSchema.isCompatible(compatibility, previousSchemas));
        if (!errorMessages.isEmpty()) {
            try {
                errorMessages.add(String.format("{validateFields: '%b', compatibility: '%s'}", this.isSchemaFieldValidationEnabled(config), compatibility));
            }
            catch (UnsupportedOperationException e) {
                log.warn("Failed to append 'compatibility' to error messages");
            }
        }
        return errorMessages;
    }

    private List<String> validateReservedFields(ParsedSchema currentSchema, ParsedSchemaHolder previousSchema) {
        Sets.SetView removedFields;
        ArrayList<String> errorMessages = new ArrayList<String>();
        Set updatedReservedFields = currentSchema.getReservedFields();
        if (previousSchema != null && !(removedFields = Sets.difference((Set)previousSchema.schema().getReservedFields(), (Set)updatedReservedFields)).isEmpty()) {
            removedFields.forEach(field -> errorMessages.add(String.format(RESERVED_FIELD_REMOVED, field)));
        }
        updatedReservedFields.forEach(reservedField -> {
            if (currentSchema.hasTopLevelField(reservedField)) {
                errorMessages.add(String.format(FIELD_CONFLICTS_WITH_RESERVED_FIELD, reservedField));
            }
        });
        return errorMessages;
    }

    private static String getCompatibilityGroupValue(ParsedSchema parsedSchema, String compatibilityGroup) {
        if (parsedSchema.metadata() != null && parsedSchema.metadata().getProperties() != null) {
            return (String)parsedSchema.metadata().getProperties().get(compatibilityGroup);
        }
        return null;
    }

    private void deleteMode(String subject) throws StoreException {
        ModeKey modeKey = new ModeKey(subject);
        this.kafkaStore.delete(modeKey);
    }

    private void deleteConfig(String subject) throws StoreException {
        ConfigKey configKey = new ConfigKey(subject);
        this.kafkaStore.delete(configKey);
    }

    public Mode getMode(String subject) throws SchemaRegistryStoreException {
        try {
            Mode globalMode = this.lookupCache.mode(null, false, this.defaultMode);
            Mode subjectMode = this.lookupCache.mode(subject, false, this.defaultMode);
            return globalMode == Mode.READONLY_OVERRIDE ? globalMode : subjectMode;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    public Mode getModeInScope(String subject) throws SchemaRegistryStoreException {
        try {
            Mode globalMode = this.lookupCache.mode(null, true, this.defaultMode);
            Mode subjectMode = this.lookupCache.mode(subject, true, this.defaultMode);
            return globalMode == Mode.READONLY_OVERRIDE ? globalMode : subjectMode;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    public void setMode(String subject, Mode mode) throws SchemaRegistryStoreException, OperationNotPermittedException {
        this.setMode(subject, mode, false);
    }

    public void setMode(String subject, Mode mode, boolean force) throws SchemaRegistryStoreException, OperationNotPermittedException {
        if (!this.allowModeChanges) {
            throw new OperationNotPermittedException("Mode changes are not allowed");
        }
        ModeKey modeKey = new ModeKey(subject);
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            if (mode == Mode.IMPORT && this.getModeInScope(subject) != Mode.IMPORT && !force) {
                if (this.hasSubjects(subject, false)) {
                    throw new OperationNotPermittedException("Cannot import since found existing subjects");
                }
                this.kafkaStore.put(new ClearSubjectKey(subject), new ClearSubjectValue(subject));
            }
            this.kafkaStore.put(modeKey, new ModeValue(subject, mode));
            log.debug("Wrote new mode: {} to the Kafka data store with key {}", (Object)mode.name(), (Object)modeKey);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new mode to the store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModeOrForward(String subject, Mode mode, boolean force, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.setMode(subject, mode, force);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardSetModeRequestToLeader(subject, mode, force, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Update mode request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    public void deleteSubjectMode(String subject) throws SchemaRegistryStoreException, OperationNotPermittedException {
        if (!this.allowModeChanges) {
            throw new OperationNotPermittedException("Mode changes are not allowed");
        }
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            this.deleteMode(subject);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to delete subject config value from store", e);
        }
    }

    public void deleteSubjectModeOrForward(String subject, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSubjectMode(subject);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteSubjectModeRequestToLeader(subject, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Delete config request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    KafkaStore<SchemaRegistryKey, SchemaRegistryValue> getKafkaStore() {
        return this.kafkaStore;
    }

    private List<Schema> sortSchemasByVersion(CloseableIterator<SchemaRegistryValue> schemas, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) {
        List<Object> schemaList = new ArrayList<Schema>();
        Schema previousSchema = null;
        while (schemas.hasNext()) {
            Schema schema;
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            boolean shouldInclude = KafkaSchemaRegistry.shouldInclude(schemaValue.isDeleted(), filter);
            if (!shouldInclude) continue;
            try {
                schema = this.toSchemaEntity(schemaValue);
            }
            catch (SchemaRegistryStoreException e) {
                log.error("Failed to decode metadata for schema id {}", (Object)schemaValue.getId(), (Object)e);
                continue;
            }
            if (returnLatestOnly) {
                if (previousSchema != null && !schema.getSubject().equals(previousSchema.getSubject())) {
                    schemaList.add(previousSchema);
                }
            } else {
                schemaList.add(schema);
            }
            previousSchema = schema;
        }
        if (returnLatestOnly && previousSchema != null) {
            Schema lastSchema;
            Schema schema = lastSchema = schemaList.isEmpty() ? null : (Schema)schemaList.get(schemaList.size() - 1);
            if (lastSchema == null || !lastSchema.getSubject().equals(previousSchema.getSubject())) {
                schemaList.add(previousSchema);
            }
        }
        if (postFilter != null) {
            schemaList = schemaList.stream().filter(postFilter).collect(Collectors.toList());
        }
        Collections.sort(schemaList);
        return schemaList;
    }

    private List<SchemaKey> sortSchemaKeysByVersion(CloseableIterator<SchemaRegistryValue> schemas, LookupFilter filter) {
        ArrayList<SchemaKey> schemaList = new ArrayList<SchemaKey>();
        while (schemas.hasNext()) {
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            boolean shouldInclude = KafkaSchemaRegistry.shouldInclude(schemaValue.isDeleted(), filter);
            if (!shouldInclude) continue;
            SchemaKey schemaKey = schemaValue.toKey();
            schemaList.add(schemaKey);
        }
        Collections.sort(schemaList);
        return schemaList;
    }

    private boolean isSubjectVersionDeleted(String subject, int version) throws SchemaRegistryException {
        try {
            SchemaValue schemaValue = (SchemaValue)this.kafkaStore.get(new SchemaKey(subject, version));
            return schemaValue == null || schemaValue.isDeleted();
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema from the backend Kafka store", e);
        }
    }

    private static boolean shouldInclude(boolean isDeleted, LookupFilter filter) {
        switch (filter) {
            case DEFAULT: {
                return !isDeleted;
            }
            case INCLUDE_DELETED: {
                return true;
            }
            case DELETED_ONLY: {
                return isDeleted;
            }
        }
        return false;
    }

    @Override
    public SchemaRegistryConfig config() {
        return this.config;
    }

    @Override
    public Map<String, Object> properties() {
        return this.props;
    }

    public HostnameVerifier getHostnameVerifier() throws SchemaRegistryStoreException {
        String sslEndpointIdentificationAlgo = this.config.getString("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlgo == null || sslEndpointIdentificationAlgo.equals("none") || sslEndpointIdentificationAlgo.isEmpty()) {
            return (hostname, session) -> true;
        }
        if (sslEndpointIdentificationAlgo.equalsIgnoreCase("https")) {
            return null;
        }
        throw new SchemaRegistryStoreException("ssl.endpoint.identification.algorithm " + sslEndpointIdentificationAlgo + " not supported");
    }

    private boolean isSchemaFieldValidationEnabled(Config config) {
        return config.isValidateFields() != null ? config.isValidateFields() : this.defaultValidateFields;
    }

    public static class SchemeAndPort {
        public int port;
        public String scheme;

        public SchemeAndPort(String scheme, int port) {
            this.port = port;
            this.scheme = scheme;
        }
    }

    private static class RawSchema {
        private final Schema schema;
        private final boolean isNew;
        private final boolean normalize;

        public RawSchema(Schema schema, boolean isNew, boolean normalize) {
            this.schema = schema;
            this.isNew = isNew;
            this.normalize = normalize;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isNormalize() {
            return this.normalize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawSchema that = (RawSchema)o;
            return this.isNew == that.isNew && this.normalize == that.normalize && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.isNew, this.normalize);
        }

        public String toString() {
            return "RawSchema{schema=" + this.schema + ", isNew=" + this.isNew + ", normalize=" + this.normalize + '}';
        }
    }
}

