/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.monitoring.util;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;

public class HttpStatusCodeMapper {
    public static WebApplicationException mapStatusCode(int statusCode) {
        switch (statusCode) {
            case 400: {
                return new BadRequestException("Malformed message");
            }
            case 401: {
                return new NotAuthorizedException((Object)"Authentication failure", new Object[0]);
            }
            case 403: {
                return new NotAuthorizedException((Object)"Not permitted to access", new Object[0]);
            }
            case 404: {
                return new NotFoundException("Couldn\u2019t find resource");
            }
            case 405: {
                return new NotAllowedException("HTTP method not supported", new String[0]);
            }
            case 415: {
                return new NotSupportedException("Client posted media type not supported");
            }
            case 503: {
                return new ServiceUnavailableException("Server is temporarily unavailable or busy");
            }
        }
        return new InternalServerErrorException("General server error, status code was: " + statusCode);
    }
}

