/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperationDeserializer;
import java.util.EnumSet;

@JsonDeserialize(using=SchemaRegistryResourceOperationDeserializer.class)
public enum SchemaRegistryResourceOperation {
    SUBJECT_READ,
    SUBJECT_WRITE,
    SUBJECT_DELETE,
    SCHEMA_READ,
    SUBJECT_COMPATIBILITY_READ,
    SUBJECT_COMPATIBILITY_WRITE,
    GLOBAL_COMPATIBILITY_READ,
    GLOBAL_COMPATIBILITY_WRITE,
    GLOBAL_READ,
    AUTHORIZATION_NOT_REQUIRED,
    EXPORTER_ACCESS,
    KEK_READ,
    KEK_REGISTER,
    KEK_UPDATE,
    KEK_DEREGISTER;

    public static final EnumSet<SchemaRegistryResourceOperation> SUBJECT_RESOURCE_OPERATIONS;
    public static final EnumSet<SchemaRegistryResourceOperation> KEK_RESOURCE_OPERATIONS;
    public static final EnumSet<SchemaRegistryResourceOperation> GLOBAL_RESOURCE_OPERATIONS;
    public static final EnumSet<SchemaRegistryResourceOperation> ACL_COMMAND_OPERATIONS;

    static {
        SUBJECT_RESOURCE_OPERATIONS = EnumSet.of(SUBJECT_COMPATIBILITY_READ, SUBJECT_COMPATIBILITY_WRITE, SUBJECT_READ, SUBJECT_WRITE, SUBJECT_DELETE);
        KEK_RESOURCE_OPERATIONS = EnumSet.of(KEK_READ, KEK_REGISTER, KEK_UPDATE, KEK_DEREGISTER);
        GLOBAL_RESOURCE_OPERATIONS = EnumSet.of(GLOBAL_COMPATIBILITY_READ, GLOBAL_COMPATIBILITY_WRITE, GLOBAL_READ);
        ACL_COMMAND_OPERATIONS = EnumSet.noneOf(SchemaRegistryResourceOperation.class);
        for (SchemaRegistryResourceOperation subjectOperation : SUBJECT_RESOURCE_OPERATIONS) {
            if (SCHEMA_READ.equals((Object)subjectOperation)) continue;
            ACL_COMMAND_OPERATIONS.add(subjectOperation);
        }
        ACL_COMMAND_OPERATIONS.addAll(GLOBAL_RESOURCE_OPERATIONS);
    }
}

