/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.server;

import io.confluent.http.server.KafkaHttpApplicationLoadingException;
import io.confluent.http.server.KafkaHttpApplicationProvider;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.rest.Application;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KafkaHttpApplicationLoader {
    private static final Logger log = LoggerFactory.getLogger(KafkaHttpApplicationLoader.class);

    private KafkaHttpApplicationLoader() {
    }

    static List<Application<?>> load(Map<String, Object> configuration, KafkaHttpServerInjector injector) {
        ArrayList applications = new ArrayList();
        for (KafkaHttpApplicationProvider provider : ServiceLoader.load(KafkaHttpApplicationProvider.class)) {
            List<Application<?>> loaded;
            try {
                loaded = provider.provideApplications(configuration, injector);
            }
            catch (Throwable error) {
                throw new KafkaHttpApplicationLoadingException(String.format("Failed to load Applications from provider %s.", provider.getClass().getSimpleName()), error);
            }
            if (loaded.size() == 0) {
                log.info("Application provider '{}' did not provide any instances.", (Object)provider.getClass().getSimpleName());
                continue;
            }
            log.info("Application provider '{}' provided {} instance(s).", (Object)provider.getClass().getSimpleName(), (Object)loaded.size());
            applications.addAll(loaded);
        }
        return applications;
    }
}

