/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class BrokerRegistration {
    private final int id;
    private final long epoch;
    private final Uuid incarnationId;
    private final Map<String, Endpoint> listeners;
    private final Map<String, VersionRange> supportedFeatures;
    private final Optional<String> rack;
    private final boolean fenced;
    private final boolean inControlledShutdown;
    private final boolean isMigratingZkBroker;
    private final Set<DegradedBrokerHealthState> degradedComponents;

    private static Map<String, Endpoint> listenersToMap(Collection<Endpoint> listeners) {
        HashMap<String, Endpoint> listenersMap = new HashMap<String, Endpoint>();
        for (Endpoint endpoint : listeners) {
            listenersMap.put((String)endpoint.listenerName().get(), endpoint);
        }
        return listenersMap;
    }

    public static Optional<Long> zkBrokerEpoch(long value) {
        if (value == -1L) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, List<Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown) {
        this(id, epoch, incarnationId, BrokerRegistration.listenersToMap(listeners), supportedFeatures, rack, fenced, inControlledShutdown, false, Collections.emptySet());
    }

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, List<Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown, boolean isMigratingZkBroker, Set<DegradedBrokerHealthState> degradedComponents) {
        this(id, epoch, incarnationId, BrokerRegistration.listenersToMap(listeners), supportedFeatures, rack, fenced, inControlledShutdown, isMigratingZkBroker, degradedComponents);
    }

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown) {
        this(id, epoch, incarnationId, listeners, supportedFeatures, rack, fenced, inControlledShutdown, false, Collections.emptySet());
    }

    public BrokerRegistration(int id, long epoch, Uuid incarnationId, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown, boolean isMigratingZkBroker, Set<DegradedBrokerHealthState> degradedComponents) {
        this.id = id;
        this.epoch = epoch;
        this.incarnationId = incarnationId;
        HashMap<String, Endpoint> newListeners = new HashMap<String, Endpoint>(listeners.size());
        for (Map.Entry<String, Endpoint> entry : listeners.entrySet()) {
            if (!entry.getValue().listenerName().isPresent()) {
                throw new IllegalArgumentException("Broker listeners must be named.");
            }
            newListeners.put(entry.getKey(), entry.getValue());
        }
        this.listeners = Collections.unmodifiableMap(newListeners);
        Objects.requireNonNull(supportedFeatures);
        this.supportedFeatures = new HashMap<String, VersionRange>(supportedFeatures);
        Objects.requireNonNull(rack);
        this.rack = rack;
        this.fenced = fenced;
        this.inControlledShutdown = inControlledShutdown;
        this.isMigratingZkBroker = isMigratingZkBroker;
        Objects.requireNonNull(degradedComponents);
        this.degradedComponents = degradedComponents;
    }

    public static BrokerRegistration fromRecord(RegisterBrokerRecord record) {
        Object endpoint;
        HashMap<String, Endpoint> listeners = new HashMap<String, Endpoint>();
        Iterator iterator = record.endPoints().iterator();
        while (iterator.hasNext()) {
            endpoint = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            listeners.put(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), new Endpoint(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), SecurityProtocol.forId((short)((RegisterBrokerRecord.BrokerEndpoint)endpoint).securityProtocol()), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).host(), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).port()));
        }
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        endpoint = record.features().iterator();
        while (endpoint.hasNext()) {
            RegisterBrokerRecord.BrokerFeature feature = (RegisterBrokerRecord.BrokerFeature)endpoint.next();
            supportedFeatures.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        Set<DegradedBrokerHealthState> degradedComponents = record.degradedComponents() != null ? DegradedBrokerHealthState.fromRegisterBrokerRecord(record.degradedComponents()) : Collections.emptySet();
        return new BrokerRegistration(record.brokerId(), record.brokerEpoch(), record.incarnationId(), listeners, supportedFeatures, Optional.ofNullable(record.rack()), record.fenced(), record.inControlledShutdown(), record.isMigratingZkBroker(), degradedComponents);
    }

    public int id() {
        return this.id;
    }

    public long epoch() {
        return this.epoch;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Optional<Node> node(String listenerName) {
        Endpoint endpoint = this.listeners().get(listenerName);
        if (endpoint == null) {
            return Optional.empty();
        }
        return Optional.of(new Node(this.id, endpoint.host(), endpoint.port(), (String)this.rack.orElse(null)));
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public boolean inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public boolean isMigratingZkBroker() {
        return this.isMigratingZkBroker;
    }

    public Set<DegradedBrokerHealthState> degradedComponents() {
        return this.degradedComponents;
    }

    public ApiMessageAndVersion toRecord(ImageWriterOptions options) {
        RegisterBrokerRecord registrationRecord = new RegisterBrokerRecord().setBrokerId(this.id).setRack(this.rack.orElse(null)).setBrokerEpoch(this.epoch).setIncarnationId(this.incarnationId).setFenced(this.fenced);
        if (this.inControlledShutdown) {
            if (options.metadataVersion().isInControlledShutdownStateSupported()) {
                registrationRecord.setInControlledShutdown(true);
            } else {
                options.handleLoss("the inControlledShutdown state of a broker");
            }
        }
        if (!this.degradedComponents.isEmpty()) {
            if (options.metadataVersion().isSettingBrokerHealthSupported()) {
                registrationRecord.setDegradedComponents(this.degradedComponents.stream().map(degradedComponent -> new RegisterBrokerRecord.DegradedComponent().setReason(degradedComponent.reason()).setComponentCode(degradedComponent.component().id())).collect(Collectors.toList()));
            } else {
                options.handleLoss("the demotion status of a broker");
            }
        }
        if (this.isMigratingZkBroker) {
            if (options.metadataVersion().isMigrationSupported()) {
                registrationRecord.setIsMigratingZkBroker(this.isMigratingZkBroker);
            } else {
                options.handleLoss("the isMigratingZkBroker state of one or more brokers");
            }
        }
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            Endpoint endpoint = entry.getValue();
            registrationRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setName(entry.getKey()).setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        }
        for (Map.Entry<String, Object> entry : this.supportedFeatures.entrySet()) {
            registrationRecord.features().add(new RegisterBrokerRecord.BrokerFeature().setName(entry.getKey()).setMinSupportedVersion(((VersionRange)entry.getValue()).min()).setMaxSupportedVersion(((VersionRange)entry.getValue()).max()));
        }
        return new ApiMessageAndVersion((ApiMessage)registrationRecord, options.metadataVersion().registerBrokerRecordVersion());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced, this.inControlledShutdown, this.isMigratingZkBroker, this.degradedComponents);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrokerRegistration)) {
            return false;
        }
        BrokerRegistration other = (BrokerRegistration)o;
        return other.id == this.id && other.epoch == this.epoch && other.incarnationId.equals((Object)this.incarnationId) && other.listeners.equals(this.listeners) && other.supportedFeatures.equals(this.supportedFeatures) && other.rack.equals(this.rack) && other.fenced == this.fenced && other.inControlledShutdown == this.inControlledShutdown && other.isMigratingZkBroker == this.isMigratingZkBroker && other.degradedComponents.equals(this.degradedComponents);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("BrokerRegistration(id=").append(this.id);
        bld.append(", epoch=").append(this.epoch);
        bld.append(", incarnationId=").append(this.incarnationId);
        bld.append(", listeners=[").append(this.listeners.keySet().stream().sorted().map(n -> this.listeners.get(n).toString()).collect(Collectors.joining(", ")));
        bld.append("], supportedFeatures={").append(this.supportedFeatures.keySet().stream().sorted().map(k -> k + ": " + this.supportedFeatures.get(k)).collect(Collectors.joining(", ")));
        bld.append("}");
        bld.append(", rack=").append(this.rack);
        bld.append(", fenced=").append(this.fenced);
        bld.append(", inControlledShutdown=").append(this.inControlledShutdown);
        bld.append(", isMigratingZkBroker=").append(this.isMigratingZkBroker);
        bld.append(", degradedComponents=").append(this.degradedComponents);
        bld.append(")");
        return bld.toString();
    }

    public BrokerRegistration cloneWith(Optional<Boolean> fencingChange, Optional<Boolean> inControlledShutdownChange, Optional<Set<DegradedBrokerHealthState>> brokerStatusChanges) {
        boolean newFenced = fencingChange.orElse(this.fenced);
        boolean newInControlledShutdownChange = inControlledShutdownChange.orElse(this.inControlledShutdown);
        Set<DegradedBrokerHealthState> newDegradedComponents = brokerStatusChanges.orElse(this.degradedComponents);
        if (newFenced == this.fenced && newInControlledShutdownChange == this.inControlledShutdown && newDegradedComponents.equals(this.degradedComponents)) {
            return this;
        }
        return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, newFenced, newInControlledShutdownChange, this.isMigratingZkBroker, newDegradedComponents);
    }
}

