/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.handler.intercept;

import io.confluent.shaded.io.netty.channel.Channel;
import io.confluent.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.confluent.shaded.org.asynchttpclient.AsyncHandler;
import io.confluent.shaded.org.asynchttpclient.AsyncHttpClientConfig;
import io.confluent.shaded.org.asynchttpclient.HttpResponseStatus;
import io.confluent.shaded.org.asynchttpclient.filter.FilterContext;
import io.confluent.shaded.org.asynchttpclient.filter.FilterException;
import io.confluent.shaded.org.asynchttpclient.filter.ResponseFilter;
import io.confluent.shaded.org.asynchttpclient.netty.NettyResponseFuture;
import io.confluent.shaded.org.asynchttpclient.netty.request.NettyRequestSender;
import io.confluent.shaded.org.asynchttpclient.util.Assertions;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

