/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;
import java.util.Objects;

public class Encrypted {
    private final String derivationInfo;
    private final String content;
    private final String iv;

    public static Encrypted of(String info, byte[] content, byte[] iv) {
        Base64.Encoder encoder = Base64.getEncoder();
        String contentBase64 = encoder.encodeToString(content);
        String ivBase64 = encoder.encodeToString(iv);
        return new Encrypted(info, contentBase64, ivBase64);
    }

    @JsonCreator
    public static Encrypted fromJson(@JsonProperty(value="derivationInfo") String derivationInfo, @JsonProperty(value="content") String content, @JsonProperty(value="iv") String iv) {
        return new Encrypted(derivationInfo, content, iv);
    }

    public Encrypted(String derivationInfo, String content, String iv) {
        this.derivationInfo = derivationInfo;
        this.content = content;
        this.iv = iv;
    }

    @JsonProperty
    public String derivationInfo() {
        return this.derivationInfo;
    }

    @JsonProperty
    public String content() {
        return this.content;
    }

    @JsonProperty
    public String iv() {
        return this.iv;
    }

    public byte[] contentBytes() {
        return Base64.getDecoder().decode(this.content());
    }

    public byte[] ivBytes() {
        return Base64.getDecoder().decode(this.iv());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Encrypted encrypted = (Encrypted)o;
        return Objects.equals(this.derivationInfo, encrypted.derivationInfo) && Objects.equals(this.content, encrypted.content) && Objects.equals(this.iv, encrypted.iv);
    }

    public int hashCode() {
        return Objects.hash(this.derivationInfo, this.content, this.iv);
    }

    public String toString() {
        return "Encrypted{derivationInfo='" + this.derivationInfo + '\'' + ", content='[hidden]', iv='[hidden]'" + '}';
    }
}

