/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Optional;
import org.apache.kafka.metadata.MirrorTopic;

public interface MirrorTopicDelta {
    public boolean changed();

    public static class Changed
    implements MirrorTopicDelta {
        public static final Changed REMOVED = new Changed(Optional.empty());
        private final Optional<MirrorTopic> newValue;

        public Changed(MirrorTopic newValue) {
            this.newValue = Optional.of(newValue);
        }

        public Changed(Optional<MirrorTopic> newValue) {
            this.newValue = newValue;
        }

        public Optional<MirrorTopic> newValue() {
            return this.newValue;
        }

        @Override
        public boolean changed() {
            return true;
        }

        public String toString() {
            if (this.newValue.isPresent()) {
                return "Changed(newValue=" + this.newValue.get() + ")";
            }
            return "Removed";
        }
    }

    public static class Unchanged
    implements MirrorTopicDelta {
        public static final Unchanged INSTANCE = new Unchanged();

        @Override
        public boolean changed() {
            return false;
        }

        public String toString() {
            return "Unchanged";
        }
    }
}

