/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.auditlogger;

import com.google.protobuf.Message;
import io.confluent.auditlog.emitter.auditlogger.EventParams;
import io.confluent.auditlog.emitter.auditlogger.HealthChecker;
import io.confluent.auditlog.emitter.auditlogger.InitParams;
import io.confluent.auditlog.emitter.errormappers.AuditLoggerException;
import io.confluent.auditlog.emitter.errormappers.ServiceIdentityException;
import io.confluent.auditlog.emitter.errormappers.TranslatorException;
import io.confluent.auditlog.emitter.telemetry.Telemetry;
import io.confluent.auditlog.emitter.translator.Translator;
import io.confluent.auditlog.emitter.transport.KafkaTransport;
import io.confluent.auditlog.emitter.transport.Transport;
import io.confluent.auditlog.emitter.utils.LogOptions;
import io.confluent.auditlog.emitter.utils.ServiceIdentity;
import io.confluent.auditlog.eventtype.EventType;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private static final Logger log = LoggerFactory.getLogger(AuditLogger.class);
    private static final String AUDIT_HEALTH_CHECK_METHOD_NAME = "AuditHealthCheck";
    private final Transport transport;
    private final ServiceIdentity identity;
    private final Telemetry telemetry;
    private final String serviceName;
    HealthChecker healthChecker;

    public AuditLogger(InitParams params) {
        if (params == null) {
            throw new AuditLoggerException("AuditLogger should have non null params");
        }
        log.debug("Initializing a new AuditLogger");
        this.telemetry = params.getTelemetry();
        this.serviceName = params.getIdentityParams().getServiceName();
        try {
            this.identity = new ServiceIdentity(params.getIdentityParams());
        }
        catch (ServiceIdentityException e) {
            this.telemetry.errorCounter.increment("error_in", "init", "error_type", "service_identity_exception", "service_name", this.serviceName, "lib", "java");
            log.error("Error encountered while creating ServiceIdentity - " + e.getMessage());
            throw new AuditLoggerException("could not create service identity (ServiceIdentityException): " + e.getMessage(), e);
        }
        this.transport = params.getTransport();
        this.transport.init(this.telemetry, this.serviceName);
        log.info("AuditLogger initialized");
        this.telemetry.successCounter.increment("success_in", "init", "service_name", this.serviceName, "lib", "java");
        if (this.transport instanceof KafkaTransport) {
            this.healthChecker = new HealthChecker(this, params.getHealthCheckFrequencyInMillis());
            log.debug("Healthchecker initialized");
        }
    }

    void logHealthCheckEvent() throws AuditLoggerException {
        Event event;
        AuditLog auditLog = AuditLog.newBuilder().setMethodName(AUDIT_HEALTH_CHECK_METHOD_NAME).setServiceName(this.identity.getServiceNameCrn()).setInternalServiceName(this.identity.getInternalServiceNameCrn()).setServiceLocation(this.identity.getServiceLocation()).build();
        try {
            event = new Event().setId(UUID.randomUUID().toString()).setTime(OffsetDateTime.now(ZoneOffset.UTC)).setType(EventType.HEALTH_CHECK.toString()).setSubject(auditLog.getServiceName()).setSource("crn://confluent.cloud/").setData("application/protobuf", URI.create("https://confluent.io/internal/events/AuditLog.v2"), EventUtils.protoToBytes((Message)auditLog, (String)"application/protobuf"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.telemetry.errorCounter.increment("error_in", "healthcheck", "error_type", "translator_exception", "service_name", this.serviceName, "lib", "java");
            throw new AuditLoggerException("Error while creating HealthCheck event: " + e.getMessage(), e);
        }
        try {
            this.transport.log(event);
        }
        catch (Exception e) {
            this.telemetry.errorCounter.increment("error_in", "healthcheck", "error_type", "transport_exception", "service_name", this.serviceName, "lib", "java");
            throw new AuditLoggerException("Got an error while logging event: " + e.getMessage(), e);
        }
        this.telemetry.successCounter.increment("success_in", "healthcheck", "service_name", this.serviceName, "lib", "java");
    }

    public void logWithOptions(AuditLog auditLog, LogOptions options) {
        EventParams eventParams = EventParams.builder().eventType(EventType.CONFLUENT_CLOUD).build();
        this.logWithOptions(auditLog, options, eventParams);
    }

    public void logWithOptions(AuditLog auditLog, LogOptions options, EventParams eventParams) {
        try {
            this.telemetry.logCallsCounter.increment("service_name", this.serviceName, "lib", "java");
            log.debug("[logWithOptions]: Translating AuditLog to an Event");
            Event event = Translator.auditEntryToEvent(auditLog, this.identity, options, eventParams);
            log.debug(String.format("[logWithOptions]: Successfully translated AuditLog [id = %s] to an Event", event.id()));
            log.debug(String.format("[logWithOptions]: Sending the AuditLog [id = %s] to Transport", event.id()));
            this.transport.log(event);
            log.debug(String.format("[logWithOptions]: Transport log for AuditLog [id = %s] completed", event.id()));
            this.telemetry.successCounter.increment("success_in", "log", "service_name", this.serviceName, "lib", "java");
        }
        catch (TranslatorException e) {
            log.error("[logWithOptions]: Error encountered while converting AuditLog to Event", (Throwable)e);
            this.telemetry.errorCounter.increment("error_in", "log", "error_type", "translator_exception", "service_name", this.serviceName, "lib", "java");
        }
        catch (Exception e) {
            log.error("[logWithOptions]: Unknown Error encountered while logging audit event", (Throwable)e);
            this.telemetry.errorCounter.increment("error_in", "log", "error_type", "unknown_exception", "service_name", this.serviceName, "lib", "java");
        }
    }

    public void log(AuditLog auditLog) {
        this.logWithOptions(auditLog, null);
    }

    public void close() {
        try {
            if (this.healthChecker != null) {
                this.healthChecker.close();
            }
            this.transport.close();
            log.debug("[close]: Successfully closed AuditLogger");
            this.telemetry.successCounter.increment("success_in", "close", "service_name", this.serviceName, "lib", "java");
        }
        catch (Exception e) {
            this.telemetry.errorCounter.increment("error_in", "close", "service_name", this.serviceName, "lib", "java");
            log.error("[close]: Error while closing AuditLogger", (Throwable)e);
        }
    }
}

