/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.auditlogger;

import io.confluent.auditlog.emitter.auditlogger.AuditLogger;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker {
    private static final Logger log = LoggerFactory.getLogger(HealthChecker.class);
    private static final long DEFAULT_HEALTH_CHECK_FREQUENCY = 600000L;
    Timer timer;
    private long healthCheckFrequency;

    HealthChecker(AuditLogger auditLogger, long frequency) {
        this.healthCheckFrequency = frequency;
        if (frequency == 0L) {
            this.healthCheckFrequency = 600000L;
        }
        this.timer = new Timer();
        this.start(auditLogger);
    }

    void start(final AuditLogger auditLogger) {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    auditLogger.logHealthCheckEvent();
                }
                catch (Exception e) {
                    log.error("Could not log HealthCheck event.", (Throwable)e);
                }
            }
        }, 0L, this.healthCheckFrequency);
    }

    void close() {
        this.timer.cancel();
    }
}

