/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.telemetry;

import io.confluent.auditlog.emitter.telemetry.TelemetryCounter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxCounter
implements TelemetryCounter {
    private static final Logger log = LoggerFactory.getLogger(JmxCounter.class);
    private String metricName;
    private Metrics metrics;
    private String desc;
    private static final String GROUP_NAME = "auditlogs";
    private final Map<String, Sensor> sensors;

    public JmxCounter(String name, String desc, Metrics metrics, Map<String, Sensor> sensorMap) {
        this.metricName = name;
        this.metrics = metrics;
        this.desc = desc;
        this.sensors = sensorMap;
    }

    @Override
    public void increment(String k1, String v1) {
        this.record(k1, v1);
    }

    @Override
    public void increment(String k1, String v1, String k2, String v2) {
        this.record(k1, v1, k2, v2);
    }

    @Override
    public void increment(String k1, String v1, String k2, String v2, String k3, String v3) {
        this.record(k1, v1, k2, v2, k3, v3);
    }

    @Override
    public void increment(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        this.record(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    private void record(String ... keyValuePairs) {
        try {
            if (keyValuePairs.length % 2 != 0) {
                log.error("Invalid number of arguments.");
                return;
            }
            HashMap<String, String> tags = new HashMap<String, String>();
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                tags.put(keyValuePairs[i], keyValuePairs[i + 1]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.metricName);
            for (Map.Entry tag : new TreeMap(tags).entrySet()) {
                sb.append(':');
                sb.append((String)tag.getKey());
                sb.append('=');
                sb.append((String)tag.getValue());
            }
            String sensorName = sb.toString();
            Sensor sensor = this.getOrCreateSensor(sensorName, tags);
            sensor.record();
        }
        catch (Exception e) {
            log.error("Exception while logging JMX metrics.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sensor getOrCreateSensor(String sensorName, Map<String, String> tags) {
        Map<String, Sensor> map = this.sensors;
        synchronized (map) {
            this.sensors.computeIfAbsent(sensorName, key -> {
                Sensor sensor = this.metrics.sensor(sensorName);
                sensor.add(this.metrics.metricName(this.metricName, GROUP_NAME, this.desc, tags), (MeasurableStat)new CumulativeCount());
                return sensor;
            });
        }
        return this.sensors.get(sensorName);
    }
}

