/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.telemetry;

import io.confluent.auditlog.emitter.telemetry.JmxCounter;
import io.confluent.auditlog.emitter.telemetry.Telemetry;
import io.confluent.auditlog.emitter.telemetry.TelemetryCounter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;

public class JmxTelemetry
extends Telemetry {
    static final int DEFAULT_CACHE_SIZE = 1000;
    private static Metrics metrics = new Metrics(new MetricConfig(), Collections.singletonList(new JmxReporter()), Time.SYSTEM, true, (MetricsContext)new KafkaMetricsContext("auditlogs"));
    private static final Map<String, Sensor> sensorMap = new LinkedHashMap<String, Sensor>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    };

    @Override
    public TelemetryCounter getCounter(String name, String desc, String unit) {
        return new JmxCounter(name, desc, metrics, sensorMap);
    }
}

