/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.translator;

import io.confluent.auditlog.emitter.errormappers.SubjectBuilderException;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import java.util.ArrayList;
import java.util.List;

public class SubjectBuilder {
    public static final String CONFLUENT_CLOUD_AUTHORITY = "confluent.cloud";

    private static String formatResourceType(TypedCloudResourceRef.ResourceType resourceType) {
        String resource = resourceType.toString().toLowerCase();
        resource = resource.replaceAll("_", "-");
        return resource;
    }

    private static List<ConfluentResourceName.Element> cloudResourceToElements(FullyQualifiedCloudResourceRef fullyQualifiedCloudResourceRef) throws CrnSyntaxException {
        if (fullyQualifiedCloudResourceRef == null) {
            throw new SubjectBuilderException("given cloud resource ref is null");
        }
        ArrayList<ConfluentResourceName.Element> elements = new ArrayList<ConfluentResourceName.Element>();
        if (fullyQualifiedCloudResourceRef.hasScope()) {
            for (TypedCloudResourceRef eachTypedCloudResourceRef : fullyQualifiedCloudResourceRef.getScope().getResourcesList()) {
                if (eachTypedCloudResourceRef.getResourceId().equals("")) {
                    throw new SubjectBuilderException("scope resource cannot have empty resource id");
                }
                elements.add(new ConfluentResourceName.Element(SubjectBuilder.formatResourceType(eachTypedCloudResourceRef.getType()), eachTypedCloudResourceRef.getResourceId()));
            }
        }
        if (!fullyQualifiedCloudResourceRef.hasResource()) {
            throw new SubjectBuilderException("cannot have null cloud resource");
        }
        TypedCloudResourceRef resource = fullyQualifiedCloudResourceRef.getResource();
        if (resource.getResourceId().equals("")) {
            throw new SubjectBuilderException("cannot have empty cloud resource id");
        }
        elements.add(new ConfluentResourceName.Element(SubjectBuilder.formatResourceType(resource.getType()), resource.getResourceId()));
        return elements;
    }

    private static int longestCommonPrefixIndex(List<List<ConfluentResourceName.Element>> elementLists) {
        int lcpIndex;
        if (elementLists.isEmpty()) {
            throw new SubjectBuilderException("must have at least one cloud resource to build a crn");
        }
        int shortestLengthList = Integer.MAX_VALUE;
        for (List<ConfluentResourceName.Element> elementList : elementLists) {
            if (elementList.size() >= shortestLengthList) continue;
            shortestLengthList = elementList.size();
        }
        for (lcpIndex = 0; lcpIndex < shortestLengthList; ++lcpIndex) {
            for (int i = 1; i < elementLists.size(); ++i) {
                if (elementLists.get(0).get(lcpIndex).equals((Object)elementLists.get(i).get(lcpIndex))) continue;
                return lcpIndex;
            }
        }
        return lcpIndex;
    }

    protected static String buildSubjectCrn(List<FullyQualifiedCloudResourceRef> cloudResourceRefs) throws CrnSyntaxException {
        if (cloudResourceRefs.isEmpty()) {
            throw new SubjectBuilderException("must have at least one cloud resource to build a crn");
        }
        ArrayList<List<ConfluentResourceName.Element>> allElements = new ArrayList<List<ConfluentResourceName.Element>>();
        for (FullyQualifiedCloudResourceRef fullyQualifiedCloudResourceRef : cloudResourceRefs) {
            List<ConfluentResourceName.Element> elements = SubjectBuilder.cloudResourceToElements(fullyQualifiedCloudResourceRef);
            allElements.add(elements);
        }
        int lcpIndex = SubjectBuilder.longestCommonPrefixIndex(allElements);
        List crnResources = ((List)allElements.get(0)).subList(0, lcpIndex);
        ConfluentResourceName.Builder crnBuilder = ConfluentResourceName.newBuilder();
        crnBuilder.setAuthority(CONFLUENT_CLOUD_AUTHORITY);
        for (ConfluentResourceName.Element element : crnResources) {
            crnBuilder.addElement(element.resourceType(), element.encodedResourceName());
        }
        return crnBuilder.build().toString();
    }
}

