/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.translator;

import io.confluent.auditlog.emitter.errormappers.ValidatorException;
import io.confluent.auditlog.emitter.utils.LogOptions;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.AuthenticationInfo;
import io.confluent.protobuf.events.auditlog.v2.Credentials;
import io.confluent.protobuf.events.auditlog.v2.ExternalAccount;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Principal;
import io.confluent.protobuf.events.auditlog.v2.RequestMetadata;
import io.confluent.protobuf.events.auditlog.v2.ResourceRef;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);

    private static void validateRequestMetadata(RequestMetadata metadata, LogOptions options) {
        boolean allowEmptyIp = false;
        if (options != null) {
            allowEmptyIp = options.isAllowEmptyIpAddress();
        }
        if (!allowEmptyIp) {
            List clientAddresses = metadata.getClientAddressList();
            if (clientAddresses.size() == 0) {
                throw new ValidatorException("request metadata must have at least one client ip address");
            }
            for (RequestMetadata.Address ip : clientAddresses) {
                if (!StringUtils.isBlank((CharSequence)ip.getIp())) continue;
                throw new ValidatorException("request metadata client ip cannot be empty");
            }
        }
    }

    private static void validateResourceRef(ResourceRef resource) {
        if (StringUtils.isBlank((CharSequence)resource.getResourceId()) && StringUtils.isBlank((CharSequence)resource.getInternalId())) {
            throw new ValidatorException("resource ref cannot have an empty resource id and an empty internal id");
        }
    }

    private static void validateExternalAccount(ExternalAccount externalAccount) {
        if (StringUtils.isBlank((CharSequence)externalAccount.getSubject())) {
            throw new ValidatorException("authentication info external account cannot have an empty subject");
        }
        for (ExternalAccount.Namespace namespace : externalAccount.getNamespaceList()) {
            if (!StringUtils.isBlank((CharSequence)namespace.getType()) && !StringUtils.isBlank((CharSequence)namespace.getId())) continue;
            throw new ValidatorException("authentication info external account namespaces must contain both type and id");
        }
    }

    private static void validatePrincipal(AuthenticationInfo authenticationInfo, LogOptions options) {
        if (options != null && options.isAllowEmptyPrincipal()) {
            return;
        }
        if (!authenticationInfo.hasPrincipal()) {
            throw new ValidatorException("authentication info must have a principal");
        }
        Principal principal = authenticationInfo.getPrincipal();
        if (principal.getAccountCase() == Principal.AccountCase.ACCOUNT_NOT_SET) {
            throw new ValidatorException("authentication info principal account cannot be unset");
        }
        if (principal.hasExternalAccount()) {
            Validator.validateExternalAccount(principal.getExternalAccount());
        }
        if (principal.hasConfluentUser()) {
            Validator.validateResourceRef(principal.getConfluentUser());
        }
        if (principal.hasConfluentServiceAccount()) {
            Validator.validateResourceRef(principal.getConfluentServiceAccount());
        }
        if (principal.hasIdentityPool()) {
            Validator.validateResourceRef(principal.getIdentityPool());
        }
    }

    private static void validateAuthenticationInfo(AuthenticationInfo authenticationInfo, LogOptions options) {
        Validator.validatePrincipal(authenticationInfo, options);
        if (authenticationInfo.hasCredentials() && authenticationInfo.getCredentials().getMechanism() == Credentials.Mechanism.UNSET) {
            throw new ValidatorException("authentication info credentials cannot be " + Credentials.Mechanism.UNSET);
        }
    }

    private static void validateCloudResource(TypedCloudResourceRef resource) {
        if (StringUtils.isBlank((CharSequence)resource.getResourceId())) {
            throw new ValidatorException("cloud resource ref cannot have an empty resource id");
        }
    }

    private static void validateCloudResources(List<FullyQualifiedCloudResourceRef> resources) {
        if (resources.isEmpty()) {
            throw new ValidatorException("must have at least one cloud resource");
        }
        for (FullyQualifiedCloudResourceRef resource : resources) {
            if (resource.hasScope()) {
                for (TypedCloudResourceRef scopeResource : resource.getScope().getResourcesList()) {
                    Validator.validateCloudResource(scopeResource);
                }
            }
            if (!resource.hasResource()) {
                throw new ValidatorException("cannot have unset target resource");
            }
            Validator.validateCloudResource(resource.getResource());
        }
    }

    protected static void validateAuditEntry(AuditLog auditLog, LogOptions options) {
        log.debug("[validateAuditEntry]: validating auditEntry");
        if (auditLog == null) {
            throw new ValidatorException("audit entry cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)auditLog.getMethodName())) {
            throw new ValidatorException("method name cannot be empty");
        }
        Validator.validateCloudResources(auditLog.getCloudResourcesList());
        if (!auditLog.hasAuthenticationInfo()) {
            throw new ValidatorException("audit entry must have an authentication info");
        }
        Validator.validateAuthenticationInfo(auditLog.getAuthenticationInfo(), options);
        if (!auditLog.hasRequestMetadata()) {
            throw new ValidatorException("audit entry must have request metadata");
        }
        Validator.validateRequestMetadata(auditLog.getRequestMetadata(), options);
    }
}

