/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public abstract class DropStatement
extends Statement {
    private final SourceName name;
    private final boolean ifExists;
    private final boolean deleteTopic;

    DropStatement(Optional<NodeLocation> location, SourceName name, boolean ifExists, boolean deleteTopic) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.ifExists = ifExists;
        this.deleteTopic = deleteTopic;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public SourceName getName() {
        return this.name;
    }

    public boolean isDeleteTopic() {
        return this.deleteTopic;
    }

    public abstract DropStatement withoutDeleteClause();

    public int hashCode() {
        return Objects.hash(this.name, this.ifExists, this.deleteTopic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DropStatement)) {
            return false;
        }
        DropStatement o = (DropStatement)((Object)obj);
        return Objects.equals(this.name, o.name) && this.ifExists == o.ifExists && this.deleteTopic == o.deleteTopic;
    }
}

