/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@Immutable
public class PrintTopic
extends Statement {
    private final String topic;
    private final boolean fromBeginning;
    private final int intervalValue;
    private final OptionalInt limit;

    public PrintTopic(Optional<NodeLocation> location, String topic, boolean fromBeginning, OptionalInt intervalValue, OptionalInt limit) {
        super(location);
        this.topic = Objects.requireNonNull(topic, "topic");
        this.fromBeginning = fromBeginning;
        this.intervalValue = Objects.requireNonNull(intervalValue, "intervalValue").orElse(1);
        this.limit = Objects.requireNonNull(limit, "limit");
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean getFromBeginning() {
        return this.fromBeginning;
    }

    public int getIntervalValue() {
        return this.intervalValue;
    }

    public OptionalInt getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrintTopic)) {
            return false;
        }
        PrintTopic that = (PrintTopic)((Object)o);
        return this.fromBeginning == that.fromBeginning && Objects.equals(this.topic, that.topic) && this.intervalValue == that.intervalValue && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.fromBeginning, this.intervalValue, this.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("topic", (Object)this.topic).add("fromBeginning", this.fromBeginning).add("intervalValue", this.intervalValue).add("limit", (Object)this.limit).toString();
    }
}

