/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.ConfluentAuthorizerConfig;
import io.confluent.security.authorizer.EmbeddedAuthorizer;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.ResourceType;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class AuthnzServerAuthorizer
extends EmbeddedAuthorizer {
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        ConfluentAuthorizerConfig.Providers providers = this.authorizerConfig.createProviders(null);
        this.providersCreated.addAll(providers.accessRuleProviders);
        this.accessRuleProviders = providers.accessRuleProviders;
        this.configureProviders(providers.accessRuleProviders, providers.groupProvider, providers.metadataProvider, null);
    }

    public CompletableFuture<Void> start(Metrics metrics, Map<String, ?> clientConfigs) {
        this.initTimeout = this.authorizerConfig.initTimeout;
        if (this.authorizerMetrics == null) {
            this.authorizerMetrics = new EmbeddedAuthorizer.AuthorizerMetrics(metrics, Time.SYSTEM);
        }
        HashSet allProviders = new HashSet(this.accessRuleProviders);
        CompletableFuture[] futureArray = (CompletableFuture[])allProviders.stream().map(provider -> provider.start((ConfluentAuthorizerServerInfo)new AuthnzServerInfo(metrics), clientConfigs)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
        CompletionStage readyFuture = CompletableFuture.allOf(futureArray).thenAccept(unused -> {
            this.ready = true;
        });
        return this.futureOrTimeout((CompletableFuture<Void>)readyFuture, this.initTimeout);
    }

    protected AuthorizeResult authorizeByResourceType(RequestContext requestContext, Operation op, ResourceType resourceType) {
        return super.authorizeByResourceType(requestContext, op, resourceType);
    }

    protected Action actionForAuthorizeByResourceType(RequestContext requestContext, Operation op, ResourceType resourceType) {
        return super.actionForAuthorizeByResourceType(requestContext, op, resourceType);
    }

    protected CompletableFuture<Void> futureOrTimeout(CompletableFuture<Void> readyFuture, Duration timeout) {
        return super.futureOrTimeout(readyFuture, timeout);
    }

    protected boolean ready() {
        return super.ready();
    }

    void setupAuthorizerMetrics(Time time) {
        this.authorizerMetrics = new EmbeddedAuthorizer.AuthorizerMetrics(new Metrics(), time);
    }

    protected Time metricsTime() {
        return super.metricsTime();
    }

    protected Metrics metrics() {
        return this.authorizerMetrics.metrics();
    }

    public void configureServerInfo(ConfluentAuthorizerServerInfo serverInfo) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public CompletableFuture<Void> start(ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> interBrokerListenerConfigs, Runnable initTask) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public static class AuthnzServerInfo
    implements ConfluentAuthorizerServerInfo {
        private Metrics metrics;

        public AuthnzServerInfo(Metrics metrics) {
            this.metrics = metrics;
        }

        public ClusterResource clusterResource() {
            return null;
        }

        public int brokerId() {
            return 0;
        }

        public Collection<Endpoint> endpoints() {
            return null;
        }

        public Endpoint interBrokerEndpoint() {
            return null;
        }

        public Collection<String> earlyStartListeners() {
            return Collections.emptyList();
        }

        public Metrics metrics() {
            return this.metrics;
        }
    }
}

