/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.LatencyRecordKey;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Utils;

public class AuthStoreMetrics {
    public static final String GROUP_NAME = "confluent-auth-store-metrics";
    public static final String RBAC_ROLE_BINDINGS_COUNT = "rbac-role-bindings-count";
    public static final String RBAC_ACCESS_RULES_COUNT = "rbac-access-rules-count";
    public static final String ACL_ACCESS_RULES_COUNT = "acl-access-rules-count";
    public static final String JWT_ISSUER_COUNT = "jwt-issuer-count";
    public static final String IDENTITY_POOL_COUNT = "identity-pool-count";
    public static final String RECORD_LATENCY_GAUGE = "rbac.synthetic.time_since_last_message";
    public static final String RECORD_LATENCY_METRIC = "rbac.synthetic.latest_message_latency";
    public static final String REFRESH_TOKEN_INFOS_COUNT = "refresh-token-infos-count";
    private final Metrics metrics;
    public final EnumMap<AuthEntryType, Sensor> recordsProcessedSensors;
    private final AbstractAuthCache authCache;
    private final Map<LatencyRecordKey, Sensor> recordLatencySensors;

    public AuthStoreMetrics(Metrics metrics, AbstractAuthCache authCache) {
        this.metrics = metrics;
        this.authCache = authCache;
        this.recordsProcessedSensors = new EnumMap(AuthEntryType.class);
        this.registerAuthStoreMeters();
        this.recordLatencySensors = new HashMap<LatencyRecordKey, Sensor>();
    }

    void registerAuthStoreMeters() {
        this.metrics.addMetricIfAbsent(this.metrics.metricName(RBAC_ROLE_BINDINGS_COUNT, GROUP_NAME, "The number of role bindings defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalRoleBindings()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(JWT_ISSUER_COUNT, GROUP_NAME, "The number of JWT Issuers defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalJwtIssuers()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(IDENTITY_POOL_COUNT, GROUP_NAME, "The number of Identity Pools defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalIdentityPools()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(RBAC_ACCESS_RULES_COUNT, GROUP_NAME, "The number of rbac access rules defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalRbacAccessRules()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(ACL_ACCESS_RULES_COUNT, GROUP_NAME, "The number of acl access rules defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalAclAccessRules()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(REFRESH_TOKEN_INFOS_COUNT, GROUP_NAME, "The number of refresh token infos defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalRefreshTokenInfos()));
        for (AuthEntryType entryType : AuthEntryType.values()) {
            String recordType = entryType.name().toLowerCase(Locale.ROOT);
            Sensor sensor = this.metrics.sensor("auth-records-processed-count-" + recordType);
            sensor.add((CompoundStat)new Meter(this.metrics.metricName("auth-records-processed-rate", GROUP_NAME, "The average number of records processed per second by the AuthStore consumer.", new String[]{"record-type", recordType}), this.metrics.metricName("auth-records-processed-total", GROUP_NAME, "The total number of processed by the AuthStore consumer.", new String[]{"record-type", recordType})));
            this.recordsProcessedSensors.put(entryType, sensor);
        }
    }

    public void registerLatencyGauge(String app, Supplier<Long> valueSupplier) {
        MetricName metricName = this.metrics.metricName(RECORD_LATENCY_GAUGE, GROUP_NAME, "Time in seconds elapsed since last latency record seen", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"app", (Object)app)}));
        if (this.metrics.metrics().get(metricName) == null) {
            this.metrics.addMetric(metricName, (MetricValueProvider)new LongGauge(valueSupplier));
        }
    }

    private void registerLatencyMetrics(LatencyRecordKey latencyRecordKey) {
        String metricBaseDescription = "Time in milliseconds to consume latency records";
        Map tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"app", (Object)latencyRecordKey.app()), Utils.mkEntry((Object)"cluster", (Object)latencyRecordKey.cluster())});
        Sensor sensor = this.metrics.sensor("rbac.synthetic.latest_message_latency_sensor." + latencyRecordKey.app() + "." + latencyRecordKey.cluster());
        sensor.add(this.metrics.metricName(RECORD_LATENCY_METRIC, GROUP_NAME, metricBaseDescription, tags), (MeasurableStat)new Value());
        sensor.add(this.metrics.metricName("rbac.synthetic.latest_message_latency_min", GROUP_NAME, metricBaseDescription + " min", tags), (MeasurableStat)new Min());
        sensor.add(this.metrics.metricName("rbac.synthetic.latest_message_latency_max", GROUP_NAME, metricBaseDescription + " max", tags), (MeasurableStat)new Max());
        sensor.add(this.metrics.metricName("rbac.synthetic.latest_message_latency_avg", GROUP_NAME, metricBaseDescription + " avg", tags), (MeasurableStat)new Avg());
        double maxTotalTimeMs = 100000.0;
        int totalBucketSizeInBytes = 4000;
        Percentile p50 = new Percentile(this.metrics.metricName("rbac.synthetic.latest_message_latency_p50", GROUP_NAME, metricBaseDescription + " p50", tags), 50.0);
        Percentile p95 = new Percentile(this.metrics.metricName("rbac.synthetic.latest_message_latency_p90", GROUP_NAME, metricBaseDescription + " p90", tags), 90.0);
        Percentile p99 = new Percentile(this.metrics.metricName("rbac.synthetic.latest_message_latency_p99", GROUP_NAME, metricBaseDescription + " p99", tags), 99.0);
        sensor.add((CompoundStat)new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.LINEAR, new Percentile[]{p50, p95, p99}));
        this.recordLatencySensors.put(latencyRecordKey, sensor);
    }

    public void recordLatencyMetric(LatencyRecordKey latencyRecordKey, long latency) {
        if (this.recordLatencySensors.get(latencyRecordKey) == null) {
            this.registerLatencyMetrics(latencyRecordKey);
        }
        this.recordLatencySensors.get(latencyRecordKey).record((double)latency);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public static class LongGauge
    implements Gauge<Long> {
        private final Supplier<Long> valueSupplier;

        LongGauge(Supplier<Long> valueSupplier) {
            this.valueSupplier = valueSupplier;
        }

        public synchronized Long value(MetricConfig config, long now) {
            return this.valueSupplier.get();
        }
    }
}

