/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import org.apache.kafka.common.errors.InvalidClusterLinkException;

public class ClusterLinkUtils {
    public static void validateLinkNameOrThrow(String linkName) {
        int maxLength = 200;
        if (linkName == null) {
            throw new InvalidClusterLinkException("Cluster link name is null");
        }
        if (linkName.isEmpty()) {
            throw new InvalidClusterLinkException("Cluster link name is empty");
        }
        if (linkName.equals(".") || linkName.equals("..")) {
            throw new InvalidClusterLinkException("Link name cannot be \".\" or \"..\"");
        }
        if (linkName.length() > 200) {
            throw new InvalidClusterLinkException("Link name exceeds maximum size of '200' characters");
        }
        boolean isValid = linkName.chars().allMatch(c -> c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 46 || c == 95 || c == 45);
        if (!isValid) {
            throw new InvalidClusterLinkException("Link name '" + linkName + "' is illegal, valid characters: [a-zA-Z0-9._-]");
        }
    }
}

