/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import java.util.Properties;
import org.apache.kafka.common.network.ProxyProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeKafkaRestConfig
extends KafkaRestConfig {
    private static final Logger log = LoggerFactory.getLogger(CeKafkaRestConfig.class);
    public static final String PROXY_PROTOCOL_CLIENT_VERSION = "proxy.protocol.client.version";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DOC = "The version of the PROXY Protocol that will be set in admin/produce/consume clients. This mirrors the config  client config PROXY_PROTOCOL_CLIENT_VERSION defined in ConfluentConfigs.java.";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT = ProxyProtocol.NONE.toString();
    public static final String USE_PROXY_PROTOCOL_WITH_BROKER = "use.proxy.protocol.with.broker";
    public static final String USE_PROXY_PROTOCOL_WITH_BROKER_DOC = "This controls if proxy-protocol is used between REST <-> BROKER. Default is false.";
    public static final boolean USE_PROXY_PROTOCOL_WITH_BROKER_DEFAULT = false;

    public CeKafkaRestConfig(Properties props) {
        super(props);
    }

    public static int getIntOrDefault(KafkaRestConfig config, String key, int defaultValue) {
        int result;
        Object value = config.getOriginalProperties().get(key);
        try {
            if (value instanceof Integer) {
                result = (Integer)value;
            } else if (value instanceof String) {
                result = Integer.parseInt((String)value);
            } else {
                if (value != null) {
                    log.error("Value for config {} cannot be converted to int. Ignoring it and using default {}", (Object)key, (Object)defaultValue);
                }
                result = defaultValue;
            }
        }
        catch (NumberFormatException var6) {
            log.error("Error converting value for config {} to int. Ignoring it and using default {}", (Object)key, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    public static long getLongOrDefault(KafkaRestConfig config, String key, long defaultValue) {
        long result;
        Object value = config.getOriginalProperties().get(key);
        try {
            if (value instanceof Long) {
                result = (Long)value;
            } else if (value instanceof String) {
                result = Long.parseLong((String)value);
            } else {
                if (value != null) {
                    log.error("Value for config {} cannot be converted to long. Ignoring it and using default {}", (Object)key, (Object)defaultValue);
                }
                result = defaultValue;
            }
        }
        catch (NumberFormatException var8) {
            log.error("Error converting value for config {} to long. Ignoring it and using default {}", (Object)key, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    public static boolean getBooleanOrDefault(KafkaRestConfig config, String configKey, boolean defaultValue) {
        boolean configValue = defaultValue;
        if (config != null) {
            Object value = config.getOriginalProperties().get(configKey);
            if (value instanceof Boolean) {
                configValue = (Boolean)value;
            } else if (value instanceof String) {
                configValue = Boolean.parseBoolean((String)value);
            }
        }
        return configValue;
    }
}

