/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.backends.kafka;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.CloudKafkaRestContext;
import io.confluent.kafkarest.auth.KafkaProducerCacheImpl;
import io.confluent.kafkarest.backends.kafka.KafkaProducerCache;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudKafkaModule
extends AbstractBinder {
    public static final String KAFKA_REST_CONTEXT_PROPERTY_NAME = "io.confluent.kafkarest.backends.kafka.CloudKafkaModule.KafkaRestContext";
    public static final String KAFKA_PRODUCER_CACHE_ENABLE_CONFIG = "kafka.producer.cache.enable";
    private static final boolean KAFKA_PRODUCER_CACHE_ENABLE_DEFAULT = false;
    private final boolean kafkaProducerCacheEnable;
    private final Logger log = LoggerFactory.getLogger(CloudKafkaModule.class);

    @Inject
    public CloudKafkaModule(Provider<KafkaRestConfig> configProvider) {
        this.kafkaProducerCacheEnable = this.kafkaProducerCacheEnable((KafkaRestConfig)configProvider.get());
    }

    private boolean kafkaProducerCacheEnable(KafkaRestConfig config) {
        boolean kafkaProducerCacheEnable = false;
        if (config != null) {
            Object value = config.getOriginalProperties().getOrDefault((Object)KAFKA_PRODUCER_CACHE_ENABLE_CONFIG, (Object)false);
            if (value instanceof Boolean) {
                kafkaProducerCacheEnable = (Boolean)value;
            } else if (value instanceof String) {
                kafkaProducerCacheEnable = Boolean.parseBoolean((String)value);
            }
        }
        this.log.info("KRest cache: producer cache enabled {}", (Object)kafkaProducerCacheEnable);
        return kafkaProducerCacheEnable;
    }

    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(RequestScoped.class).ranked(1);
        if (this.kafkaProducerCacheEnable) {
            this.bind(KafkaProducerCacheImpl.class).to(KafkaProducerCache.class).in(Singleton.class);
            this.bindFactory(CachingProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class).ranked(1);
        } else {
            this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class).ranked(1);
        }
    }

    @VisibleForTesting
    boolean isKafkaProducerCacheEnabled() {
        return this.kafkaProducerCacheEnable;
    }

    private static final class CachingProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final Provider<KafkaRestContext> context;
        private final KafkaProducerCache cache;

        @Inject
        private CachingProducerFactory(Provider<KafkaRestContext> context, KafkaProducerCache cache) {
            this.context = Objects.requireNonNull(context);
            this.cache = Objects.requireNonNull(cache);
        }

        public Producer<byte[], byte[]> provide() {
            return this.cache.provide(((CloudKafkaRestContext)this.context.get()).getProducerCacheKey(), ((CloudKafkaRestContext)this.context.get()).getProducerConfigs());
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private ProducerFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return ((KafkaRestContext)this.context.get()).getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }

    private static final class ConfluentAdminFactory
    implements Factory<ConfluentAdmin> {
        private final Provider<Admin> admin;

        @Inject
        public ConfluentAdminFactory(Provider<Admin> admin) {
            this.admin = Objects.requireNonNull(admin);
        }

        public ConfluentAdmin provide() {
            return (ConfluentAdmin)this.admin.get();
        }

        public void dispose(ConfluentAdmin instance) {
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private AdminFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return ((KafkaRestContext)this.context.get()).getAdmin();
        }

        public void dispose(Admin admin) {
            admin.close();
        }
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private final Provider<ContainerRequestContext> requestContext;

        @Inject
        private KafkaRestContextFactory(@Context Provider<ContainerRequestContext> requestContext) {
            this.requestContext = Objects.requireNonNull(requestContext);
        }

        public KafkaRestContext provide() {
            return (KafkaRestContext)Objects.requireNonNull(((ContainerRequestContext)this.requestContext.get()).getProperty(CloudKafkaModule.KAFKA_REST_CONTEXT_PROPERTY_NAME), "KafkaRestContext cannot be null.");
        }

        public void dispose(KafkaRestContext context) {
            context.shutdown();
        }
    }
}

