/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AlterMirrorsData;
import io.confluent.kafkarest.entities.v3.MirrorLagData;
import io.confluent.kafkarest.entities.v3.Resource;
import javax.annotation.Nullable;

final class AutoValue_AlterMirrorsData
extends AlterMirrorsData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String mirrorTopicName;
    private final Integer errorCode;
    private final String errorMessage;
    private final ImmutableList<MirrorLagData> mirrorLags;

    private AutoValue_AlterMirrorsData(String kind, Resource.Metadata metadata, String mirrorTopicName, @Nullable Integer errorCode, @Nullable String errorMessage, ImmutableList<MirrorLagData> mirrorLags) {
        this.kind = kind;
        this.metadata = metadata;
        this.mirrorTopicName = mirrorTopicName;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.mirrorLags = mirrorLags;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="mirror_topic_name")
    public String getMirrorTopicName() {
        return this.mirrorTopicName;
    }

    @Override
    @JsonProperty(value="error_code")
    @Nullable
    public Integer getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="mirror_lags")
    public ImmutableList<MirrorLagData> getMirrorLags() {
        return this.mirrorLags;
    }

    public String toString() {
        return "AlterMirrorsData{kind=" + this.kind + ", metadata=" + this.metadata + ", mirrorTopicName=" + this.mirrorTopicName + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", mirrorLags=" + this.mirrorLags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AlterMirrorsData) {
            AlterMirrorsData that = (AlterMirrorsData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.mirrorTopicName.equals(that.getMirrorTopicName()) && (this.errorCode == null ? that.getErrorCode() == null : this.errorCode.equals(that.getErrorCode())) && (this.errorMessage == null ? that.getErrorMessage() == null : this.errorMessage.equals(that.getErrorMessage())) && this.mirrorLags.equals(that.getMirrorLags());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorTopicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode == null ? 0 : this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage == null ? 0 : this.errorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.mirrorLags.hashCode();
    }

    static final class Builder
    extends AlterMirrorsData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String mirrorTopicName;
        private Integer errorCode;
        private String errorMessage;
        private ImmutableList<MirrorLagData> mirrorLags;

        Builder() {
        }

        public AlterMirrorsData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public AlterMirrorsData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public AlterMirrorsData.Builder setMirrorTopicName(String mirrorTopicName) {
            if (mirrorTopicName == null) {
                throw new NullPointerException("Null mirrorTopicName");
            }
            this.mirrorTopicName = mirrorTopicName;
            return this;
        }

        @Override
        public AlterMirrorsData.Builder setErrorCode(@Nullable Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public AlterMirrorsData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public AlterMirrorsData.Builder setMirrorLags(ImmutableList<MirrorLagData> mirrorLags) {
            if (mirrorLags == null) {
                throw new NullPointerException("Null mirrorLags");
            }
            this.mirrorLags = mirrorLags;
            return this;
        }

        @Override
        public AlterMirrorsData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.mirrorTopicName == null) {
                missing = missing + " mirrorTopicName";
            }
            if (this.mirrorLags == null) {
                missing = missing + " mirrorLags";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AlterMirrorsData(this.kind, this.metadata, this.mirrorTopicName, this.errorCode, this.errorMessage, this.mirrorLags);
        }
    }
}

