/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.CreateMirrorRequest;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_CreateMirrorRequest
extends CreateMirrorRequest {
    private final String sourceTopicName;
    private final String mirrorTopicName;
    private final Optional<Short> replicationFactor;
    private final ImmutableList<CreateTopicRequest.ConfigEntry> configs;

    private AutoValue_CreateMirrorRequest(String sourceTopicName, String mirrorTopicName, Optional<Short> replicationFactor, ImmutableList<CreateTopicRequest.ConfigEntry> configs) {
        this.sourceTopicName = sourceTopicName;
        this.mirrorTopicName = mirrorTopicName;
        this.replicationFactor = replicationFactor;
        this.configs = configs;
    }

    @Override
    @JsonProperty(value="source_topic_name")
    public String getSourceTopicName() {
        return this.sourceTopicName;
    }

    @Override
    @JsonProperty(value="mirror_topic_name")
    public String getMirrorTopicName() {
        return this.mirrorTopicName;
    }

    @Override
    @JsonProperty(value="replication_factor")
    public Optional<Short> getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<CreateTopicRequest.ConfigEntry> getConfigs() {
        return this.configs;
    }

    public String toString() {
        return "CreateMirrorRequest{sourceTopicName=" + this.sourceTopicName + ", mirrorTopicName=" + this.mirrorTopicName + ", replicationFactor=" + this.replicationFactor + ", configs=" + this.configs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateMirrorRequest) {
            CreateMirrorRequest that = (CreateMirrorRequest)o;
            return this.sourceTopicName.equals(that.getSourceTopicName()) && this.mirrorTopicName.equals(that.getMirrorTopicName()) && this.replicationFactor.equals(that.getReplicationFactor()) && this.configs.equals(that.getConfigs());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sourceTopicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorTopicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicationFactor.hashCode();
        h$ *= 1000003;
        return h$ ^= this.configs.hashCode();
    }

    static final class Builder
    extends CreateMirrorRequest.Builder {
        private String sourceTopicName;
        private String mirrorTopicName;
        private Optional<Short> replicationFactor = Optional.empty();
        private ImmutableList<CreateTopicRequest.ConfigEntry> configs;

        Builder() {
        }

        @Override
        public CreateMirrorRequest.Builder setSourceTopicName(String sourceTopicName) {
            if (sourceTopicName == null) {
                throw new NullPointerException("Null sourceTopicName");
            }
            this.sourceTopicName = sourceTopicName;
            return this;
        }

        @Override
        public CreateMirrorRequest.Builder setMirrorTopicName(String mirrorTopicName) {
            if (mirrorTopicName == null) {
                throw new NullPointerException("Null mirrorTopicName");
            }
            this.mirrorTopicName = mirrorTopicName;
            return this;
        }

        @Override
        public CreateMirrorRequest.Builder setReplicationFactor(@Nullable Short replicationFactor) {
            this.replicationFactor = Optional.ofNullable(replicationFactor);
            return this;
        }

        @Override
        public CreateMirrorRequest.Builder setConfigs(List<CreateTopicRequest.ConfigEntry> configs) {
            this.configs = ImmutableList.copyOf(configs);
            return this;
        }

        @Override
        public CreateMirrorRequest build() {
            String missing = "";
            if (this.sourceTopicName == null) {
                missing = missing + " sourceTopicName";
            }
            if (this.mirrorTopicName == null) {
                missing = missing + " mirrorTopicName";
            }
            if (this.configs == null) {
                missing = missing + " configs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CreateMirrorRequest(this.sourceTopicName, this.mirrorTopicName, this.replicationFactor, this.configs);
        }
    }
}

