/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.MirrorLagData;

final class AutoValue_MirrorLagData
extends MirrorLagData {
    private final Integer partition;
    private final Long lag;
    private final Long lastSourceFetchHighWatermark;

    private AutoValue_MirrorLagData(Integer partition, Long lag, Long lastSourceFetchHighWatermark) {
        this.partition = partition;
        this.lag = lag;
        this.lastSourceFetchHighWatermark = lastSourceFetchHighWatermark;
    }

    @Override
    @JsonProperty(value="partition")
    public Integer getPartition() {
        return this.partition;
    }

    @Override
    @JsonProperty(value="lag")
    public Long getLag() {
        return this.lag;
    }

    @Override
    @JsonProperty(value="last_source_fetch_offset")
    public Long getLastSourceFetchHighWatermark() {
        return this.lastSourceFetchHighWatermark;
    }

    public String toString() {
        return "MirrorLagData{partition=" + this.partition + ", lag=" + this.lag + ", lastSourceFetchHighWatermark=" + this.lastSourceFetchHighWatermark + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MirrorLagData) {
            MirrorLagData that = (MirrorLagData)o;
            return this.partition.equals(that.getPartition()) && this.lag.equals(that.getLag()) && this.lastSourceFetchHighWatermark.equals(that.getLastSourceFetchHighWatermark());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.lag.hashCode();
        h$ *= 1000003;
        return h$ ^= this.lastSourceFetchHighWatermark.hashCode();
    }

    static final class Builder
    extends MirrorLagData.Builder {
        private Integer partition;
        private Long lag;
        private Long lastSourceFetchHighWatermark;

        Builder() {
        }

        @Override
        public MirrorLagData.Builder setPartition(Integer partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public MirrorLagData.Builder setLag(Long lag) {
            if (lag == null) {
                throw new NullPointerException("Null lag");
            }
            this.lag = lag;
            return this;
        }

        @Override
        public MirrorLagData.Builder setLastSourceFetchHighWatermark(Long lastSourceFetchHighWatermark) {
            if (lastSourceFetchHighWatermark == null) {
                throw new NullPointerException("Null lastSourceFetchHighWatermark");
            }
            this.lastSourceFetchHighWatermark = lastSourceFetchHighWatermark;
            return this;
        }

        @Override
        public MirrorLagData build() {
            String missing = "";
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.lag == null) {
                missing = missing + " lag";
            }
            if (this.lastSourceFetchHighWatermark == null) {
                missing = missing + " lastSourceFetchHighWatermark";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MirrorLagData(this.partition, this.lag, this.lastSourceFetchHighWatermark);
        }
    }
}

