/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.TopicPartitionLag;
import io.confluent.kafkarest.entities.v3.AutoValue_MirrorLagData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@AutoValue
public abstract class MirrorLagData {
    MirrorLagData() {
    }

    @JsonProperty(value="partition")
    public abstract Integer getPartition();

    @JsonProperty(value="lag")
    public abstract Long getLag();

    @JsonProperty(value="last_source_fetch_offset")
    public abstract Long getLastSourceFetchHighWatermark();

    public static Builder builder() {
        return new AutoValue_MirrorLagData.Builder();
    }

    @JsonCreator
    static MirrorLagData fromJson(@JsonProperty(value="partition") Integer partition, @JsonProperty(value="lag") Long lag, @JsonProperty(value="last_source_fetch_offset") Long lastSourceFetchHighWatermark) {
        return MirrorLagData.builder().setPartition(partition).setLag(lag).setLastSourceFetchHighWatermark(lastSourceFetchHighWatermark).build();
    }

    public static ImmutableList<MirrorLagData> fromPartitionLagInfo(List<TopicPartitionLag> partitionLagList) {
        return ImmutableList.copyOf((Collection)partitionLagList.stream().map(partitionLag -> MirrorLagData.fromPartitionLag(partitionLag.getTopicPartition().partition(), partitionLag.getLag(), partitionLag.getLastSourceFetchHighWatermark()).build()).collect(Collectors.toList()));
    }

    public static Builder fromPartitionLag(Integer partition, Long lag, Long lastSourceFetchHighWatermark) {
        return MirrorLagData.builder().setPartition(partition).setLag(lag).setLastSourceFetchHighWatermark(lastSourceFetchHighWatermark);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setPartition(Integer var1);

        public abstract Builder setLag(Long var1);

        public abstract Builder setLastSourceFetchHighWatermark(Long var1);

        public abstract MirrorLagData build();
    }
}

