/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.entities.v3.AutoValue_PartitionConsumeRecord;
import io.confluent.kafkarest.entities.v3.AutoValue_PartitionConsumeRecord_Header;
import io.confluent.kafkarest.utils.SimpleConsumeKeyValueDeserializer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;

@AutoValue
public abstract class PartitionConsumeRecord {
    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="offset")
    public abstract long getOffset();

    @JsonProperty(value="timestamp")
    public abstract long getTimestamp();

    @Nullable
    @JsonProperty(value="key")
    public abstract Object getKey();

    @Nullable
    @JsonProperty(value="value")
    public abstract Object getValue();

    @Nullable
    @JsonProperty(value="timestamp_type")
    public abstract TimestampType getTimestampType();

    @JsonProperty(value="headers")
    public abstract List<Header> getHeaders();

    public static Builder builder() {
        return new AutoValue_PartitionConsumeRecord.Builder();
    }

    static PartitionConsumeRecord fromConsumerRecord(ConsumerRecord<byte[], byte[]> consumerRecord) {
        return PartitionConsumeRecord.builder().setPartitionId(consumerRecord.partition()).setOffset(consumerRecord.offset()).setTimestamp(consumerRecord.timestamp()).setKey(SimpleConsumeKeyValueDeserializer.jsonFromBytes((byte[])consumerRecord.key())).setValue(SimpleConsumeKeyValueDeserializer.jsonFromBytes((byte[])consumerRecord.value())).setTimestampType(TimestampType.fromKafkaTimestampType(consumerRecord.timestampType())).setHeaders(Header.listFromKafkaHeaders(consumerRecord.headers())).build();
    }

    @JsonCreator
    static PartitionConsumeRecord fromJson(@JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="offset") long offset, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="key") @Nullable String key, @JsonProperty(value="value") @Nullable String value, @JsonProperty(value="timestamp_type") @Nullable TimestampType timestampType, @JsonProperty(value="headers") @Nullable List<Header> headers) {
        return PartitionConsumeRecord.builder().setPartitionId(partitionId).setOffset(offset).setTimestamp(timestamp).setKey(key).setValue(value).setTimestampType(timestampType).setHeaders(headers == null ? Collections.emptyList() : headers).build();
    }

    public static List<PartitionConsumeRecord> listFromConsumerRecordList(List<ConsumerRecord<byte[], byte[]>> consumerRecords) {
        return consumerRecords == null ? Collections.emptyList() : consumerRecords.parallelStream().map(PartitionConsumeRecord::fromConsumerRecord).collect(Collectors.toList());
    }

    @AutoValue
    public static abstract class Header {
        @JsonProperty(value="key")
        public abstract String getKey();

        @JsonIgnore
        public abstract Optional<ByteString> getValue();

        @JsonProperty(value="value")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        final Optional<BinaryNode> getStringValue() {
            return this.getValue().map(value -> BinaryNode.valueOf((byte[])value.toByteArray()));
        }

        public static Header create(String name, @Nullable ByteString value) {
            return new AutoValue_PartitionConsumeRecord_Header(name, Optional.ofNullable(value));
        }

        @JsonCreator
        static Header fromJson(@JsonProperty(value="key") String key, @JsonProperty(value="value") @Nullable byte[] value) {
            return Header.create(key, value != null ? ByteString.copyFrom((byte[])value) : null);
        }

        static Header fromKafkaHeader(@Nonnull org.apache.kafka.common.header.Header header) {
            String key = header.key();
            byte[] value = header.value();
            return Header.create(key, value != null ? ByteString.copyFrom((byte[])value) : null);
        }

        static List<Header> listFromKafkaHeaders(@Nonnull Headers headers) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (org.apache.kafka.common.header.Header header : headers) {
                listBuilder.add((Object)Header.fromKafkaHeader(header));
            }
            return listBuilder.build();
        }
    }

    public static enum TimestampType {
        NO_TIMESTAMP_TYPE,
        CREATE_TIME,
        LOG_APPEND_TIME;


        static TimestampType fromKafkaTimestampType(org.apache.kafka.common.record.TimestampType kafkaTimestampType) {
            switch (kafkaTimestampType) {
                case NO_TIMESTAMP_TYPE: {
                    return NO_TIMESTAMP_TYPE;
                }
                case CREATE_TIME: {
                    return CREATE_TIME;
                }
                case LOG_APPEND_TIME: {
                    return LOG_APPEND_TIME;
                }
            }
            throw new IllegalArgumentException("Unknown timestamp type " + kafkaTimestampType);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPartitionId(int var1);

        public abstract Builder setOffset(long var1);

        public abstract Builder setTimestamp(long var1);

        public abstract Builder setTimestampType(TimestampType var1);

        public abstract Builder setHeaders(List<Header> var1);

        public abstract Builder setKey(Object var1);

        public abstract Builder setValue(Object var1);

        public abstract PartitionConsumeRecord build();
    }
}

