/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.remote.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.telemetry.config.NamedFilter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class RemoteConfiguration {
    private static final String schemaVersion = "1.0";
    private final Set<String> activeFilters;
    private final Set<NamedFilter> filters;

    public RemoteConfiguration() {
        this(Collections.emptySet(), Collections.singleton("_default"));
    }

    @JsonCreator
    public RemoteConfiguration(@JsonProperty(value="filters") Set<NamedFilter> filters, @JsonProperty(value="activeFilters") Set<String> activeFilters) {
        this.filters = filters == null ? Collections.emptySet() : filters;
        this.activeFilters = activeFilters == null ? Collections.singleton("_default") : activeFilters;
    }

    public Set<String> getActiveFilters() {
        return this.activeFilters;
    }

    public Set<NamedFilter> getFilters() {
        return this.filters;
    }

    @JsonIgnore
    public static String getSchemaVersion() {
        return schemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteConfiguration)) {
            return false;
        }
        RemoteConfiguration that = (RemoteConfiguration)o;
        return Objects.equals(this.activeFilters, that.activeFilters) && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.activeFilters, this.filters);
    }
}

