/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeCellsResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.server.util.ToolsUtils;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.DescribeCellsCommand;

public class CreateQuarantinedCellCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "create-quarantined-cell";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Create quarantined cell");
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        Config clusterConfig;
        try {
            ConfigResource cluster = new ConfigResource(ConfigResource.Type.BROKER, "0");
            Map describedConfigs = (Map)admin.describeConfigs(Collections.singleton(cluster)).all().get();
            clusterConfig = (Config)describedConfigs.get(cluster);
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to fetch cluster details", e.getCause());
            return;
        }
        List cells = new ArrayList();
        try {
            DescribeCellsResult result = admin.describeCells(Collections.emptyList());
            cells = ((DescribeCellsResponseData)result.value().get()).cells();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to describe cells", e.getCause());
        }
        int minimumCellSize = Integer.parseInt(clusterConfig.get("confluent.cells.min.size").value());
        int defaultCellSize = Integer.parseInt(clusterConfig.get("confluent.cells.default.size").value());
        int maxCellId = -1;
        int maxBrokerId = -1;
        for (DescribeCellsResponseData.Cell cell : cells) {
            List brokers = cell.brokers();
            if (CellState.QUARANTINED.code() == cell.state()) {
                if (cell.brokers().size() >= minimumCellSize) {
                    this.printCellDetails(cell.cellId(), CellState.QUARANTINED, brokers, out);
                    String message = "Quarantined cell already exists. Assign tenant to cell " + cell.cellId();
                    CellsAdminCommand.printMessageAndExit(out, message);
                } else {
                    this.printCellDetails(cell.cellId(), CellState.QUARANTINED, brokers, out);
                    String message = "Quarantined cell " + cell.cellId() + " already exists. Broker size less than minimum cell requirement. Please contact KCFUN team.";
                    CellsAdminCommand.printErrorAndExit(message);
                }
                return;
            }
            maxBrokerId = Math.max(maxBrokerId, (Integer)Collections.max(brokers));
            maxCellId = Math.max(maxCellId, cell.cellId());
        }
        int quarantinedCellId = maxCellId + 1;
        try {
            admin.createCell(quarantinedCellId, CellState.QUARANTINED).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to create cell", e.getCause());
            return;
        }
        int expectedExistingBrokersCnt = (maxCellId + 1) * defaultCellSize;
        int numQuarantinedCellBrokers = minimumCellSize;
        int totalBrokersInClusterAfterExpansion = expectedExistingBrokersCnt + numQuarantinedCellBrokers;
        List<Integer> brokersForQuarantinedCell = IntStream.range(expectedExistingBrokersCnt, totalBrokersInClusterAfterExpansion).boxed().collect(Collectors.toList());
        try {
            admin.assignBrokersToCell(brokersForQuarantinedCell, quarantinedCellId, true).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to assign brokers to cell", e.getCause());
            return;
        }
        String message = String.format("Quarantined cell %s successfully created. Please ensure the cluster has at least %s pods", quarantinedCellId, totalBrokersInClusterAfterExpansion);
        this.printCellDetails(quarantinedCellId, CellState.QUARANTINED, brokersForQuarantinedCell, out);
        CellsAdminCommand.printMessageAndExit(out, message);
    }

    private void printCellDetails(Integer cellId, CellState state, List<Integer> brokers, PrintStream out) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        rows.add(new String[]{Integer.toString(cellId), state.name(), String.join((CharSequence)",", brokers.stream().map(String::valueOf).collect(Collectors.toList()))});
        ToolsUtils.prettyPrintTable((String[])DescribeCellsCommand.OUTPUT_HEADERS, rows, (PrintStream)out);
    }
}

