/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeTenantsResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.server.util.ToolsUtils;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class DescribeTenantsCommand
implements CloudAdminCommand {
    public static final String[] OUTPUT_HEADERS = new String[]{"TenantId", "CellId", "PlacementStrategy"};

    @Override
    public String name() {
        return "describe-tenants";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Describes the tenant information");
        parser.addArgument(new String[]{"--tenant-ids"}).help("tenant ids to describe separated by commas, an empty list describes all the tenants in the cluster").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        List tenants;
        List<String> tenantIds = CellsAdminCommand.getTenantIdsFromArgs(ns);
        try {
            DescribeTenantsResult result = admin.describeTenants(tenantIds);
            tenants = (List)result.value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to describe tenants", e.getCause());
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (DescribeTenantsResponseData.TenantDescription tenant : tenants) {
            rows.add(new String[]{tenant.tenantId(), Integer.toString(tenant.cellId()), PartitionPlacementStrategy.toEnum((Integer)tenant.partitionPlacementStrategy()).name()});
        }
        ToolsUtils.prettyPrintTable((String[])OUTPUT_HEADERS, rows, (PrintStream)out);
    }
}

